/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.FsDirectoryService;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.process.ProcessProbe;

public class NodeEnvironment
extends AbstractComponent
implements Closeable {
    private final NodePath[] nodePaths;
    private final Path sharedDataPath;
    private final Lock[] locks;
    private final boolean addNodeId;
    private final int localNodeId;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Map<ShardId, InternalShardLock> shardLocks = new HashMap<ShardId, InternalShardLock>();
    public static final String ADD_NODE_ID_TO_CUSTOM_PATH = "node.add_id_to_custom_path";
    public static final String SETTING_ENABLE_LUCENE_SEGMENT_INFOS_TRACE = "node.enable_lucene_segment_infos_trace";
    public static final String NODES_FOLDER = "nodes";
    public static final String INDICES_FOLDER = "indices";
    public static final String NODE_LOCK_FILENAME = "node.lock";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Inject
    @SuppressForbidden(reason="System.out.*")
    public NodeEnvironment(Settings settings, Environment environment) throws IOException {
        super(settings);
        this.addNodeId = settings.getAsBoolean(ADD_NODE_ID_TO_CUSTOM_PATH, (Boolean)true);
        if (!DiscoveryNode.nodeRequiresLocalStorage(settings)) {
            this.nodePaths = null;
            this.sharedDataPath = null;
            this.locks = null;
            this.localNodeId = -1;
            return;
        }
        NodePath[] nodePaths = new NodePath[environment.dataWithClusterFiles().length];
        Lock[] locks = new Lock[nodePaths.length];
        this.sharedDataPath = environment.sharedDataFile();
        int localNodeId = -1;
        IOException lastException = null;
        int maxLocalStorageNodes = settings.getAsInt("node.max_local_storage_nodes", (Integer)50);
        for (int possibleLockId = 0; possibleLockId < maxLocalStorageNodes; ++possibleLockId) {
            for (int dirIndex = 0; dirIndex < environment.dataWithClusterFiles().length; ++dirIndex) {
                Path dir = environment.dataWithClusterFiles()[dirIndex].resolve(NODES_FOLDER).resolve(Integer.toString(possibleLockId));
                Files.createDirectories(dir, new FileAttribute[0]);
                try {
                    FSDirectory luceneDir;
                    block21: {
                        luceneDir = FSDirectory.open(dir, NativeFSLockFactory.INSTANCE);
                        Throwable throwable = null;
                        try {
                            this.logger.trace("obtaining node lock on {} ...", dir.toAbsolutePath());
                            try {
                                locks[dirIndex] = ((Directory)luceneDir).obtainLock(NODE_LOCK_FILENAME);
                                nodePaths[dirIndex] = new NodePath(dir, environment);
                                localNodeId = possibleLockId;
                            }
                            catch (LockObtainFailedException ex) {
                                this.logger.trace("failed to obtain node lock on {}", dir.toAbsolutePath());
                                NodeEnvironment.releaseAndNullLocks(locks);
                                if (luceneDir == null) break;
                                if (throwable != null) {
                                    try {
                                        ((Directory)luceneDir).close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    break;
                                }
                                ((Directory)luceneDir).close();
                                break;
                            }
                            if (luceneDir == null) continue;
                            if (throwable == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (luceneDir == null) throw throwable3;
                                if (throwable == null) {
                                    ((Directory)luceneDir).close();
                                    throw throwable3;
                                }
                                try {
                                    ((Directory)luceneDir).close();
                                    throw throwable3;
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            ((Directory)luceneDir).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((Directory)luceneDir).close();
                    continue;
                }
                catch (IOException e) {
                    this.logger.trace("failed to obtain node lock on {}", e, dir.toAbsolutePath());
                    lastException = new IOException("failed to obtain lock on " + dir.toAbsolutePath(), e);
                    NodeEnvironment.releaseAndNullLocks(locks);
                    break;
                }
            }
            if (locks[0] != null) break;
        }
        if (locks[0] == null) {
            throw new IllegalStateException("Failed to obtain node lock, is the following location writable?: " + Arrays.toString(environment.dataWithClusterFiles()), lastException);
        }
        this.localNodeId = localNodeId;
        this.locks = locks;
        this.nodePaths = nodePaths;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using node location [{}], local_node_id [{}]", nodePaths, localNodeId);
        }
        this.maybeLogPathDetails();
        this.maybeLogHeapDetails();
        this.maybeWarnFileDescriptors();
        if (settings.getAsBoolean(SETTING_ENABLE_LUCENE_SEGMENT_INFOS_TRACE, (Boolean)false) == false) return;
        SegmentInfos.setInfoStream(System.out);
    }

    private static void releaseAndNullLocks(Lock[] locks) {
        for (int i = 0; i < locks.length; ++i) {
            if (locks[i] != null) {
                IOUtils.closeWhileHandlingException(locks[i]);
            }
            locks[i] = null;
        }
    }

    private void maybeLogPathDetails() throws IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("node data locations details:");
            for (NodePath nodePath : this.nodePaths) {
                sb.append('\n').append(" -> ").append(nodePath.path.toAbsolutePath());
                String spinsDesc = nodePath.spins == null ? "unknown" : (nodePath.spins != false ? "possibly" : "no");
                FsInfo.Path fsPath = FsProbe.getFSInfo(nodePath);
                sb.append(", free_space [").append(fsPath.getFree()).append("], usable_space [").append(fsPath.getAvailable()).append("], total_space [").append(fsPath.getTotal()).append("], spins? [").append(spinsDesc).append("], mount [").append(fsPath.getMount()).append("], type [").append(fsPath.getType()).append(']');
            }
            this.logger.debug(sb.toString(), new Object[0]);
        } else if (this.logger.isInfoEnabled()) {
            FsInfo.Path totFSPath = new FsInfo.Path();
            HashSet<String> allTypes = new HashSet<String>();
            HashSet<String> allSpins = new HashSet<String>();
            HashSet<String> allMounts = new HashSet<String>();
            for (NodePath nodePath : this.nodePaths) {
                Boolean spins;
                FsInfo.Path fsPath = FsProbe.getFSInfo(nodePath);
                String mount = fsPath.getMount();
                if (allMounts.contains(mount)) continue;
                allMounts.add(mount);
                String type = fsPath.getType();
                if (type != null) {
                    allTypes.add(type);
                }
                if ((spins = fsPath.getSpins()) == null) {
                    allSpins.add("unknown");
                } else if (spins.booleanValue()) {
                    allSpins.add("possibly");
                } else {
                    allSpins.add("no");
                }
                totFSPath.add(fsPath);
            }
            this.logger.info(String.format(Locale.ROOT, "using [%d] data paths, mounts [%s], net usable_space [%s], net total_space [%s], spins? [%s], types [%s]", this.nodePaths.length, allMounts, totFSPath.getAvailable(), totFSPath.getTotal(), NodeEnvironment.toString(allSpins), NodeEnvironment.toString(allTypes)), new Object[0]);
        }
    }

    private void maybeLogHeapDetails() {
        JvmInfo jvmInfo = JvmInfo.jvmInfo();
        ByteSizeValue maxHeapSize = jvmInfo.getMem().getHeapMax();
        String useCompressedOops = jvmInfo.useCompressedOops();
        this.logger.info("heap size [{}], compressed ordinary object pointers [{}]", maxHeapSize, useCompressedOops);
    }

    private void maybeWarnFileDescriptors() {
        long maxFileDescriptorCount = ProcessProbe.getInstance().getMaxFileDescriptorCount();
        if (maxFileDescriptorCount == -1L) {
            return;
        }
        int fileDescriptorCountThreshold = 65536;
        if (maxFileDescriptorCount < (long)fileDescriptorCountThreshold) {
            this.logger.warn("max file descriptors [{}] for elasticsearch process likely too low, consider increasing to at least [{}]", maxFileDescriptorCount, fileDescriptorCountThreshold);
        }
    }

    private static String toString(Collection<String> items) {
        StringBuilder b = new StringBuilder();
        for (String item : items) {
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(item);
        }
        return b.toString();
    }

    public void deleteShardDirectorySafe(ShardId shardId, Settings indexSettings) throws IOException {
        assert (indexSettings != Settings.EMPTY);
        Path[] paths = this.availableShardPaths(shardId);
        this.logger.trace("deleting shard {} directory, paths: [{}]", shardId, paths);
        try (ShardLock lock = this.shardLock(shardId);){
            this.deleteShardDirectoryUnderLock(lock, indexSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acquireFSLockForPaths(Settings indexSettings, Path ... shardPaths) throws IOException {
        Closeable[] locks = new Lock[shardPaths.length];
        Closeable[] dirs = new Directory[shardPaths.length];
        try {
            for (int i = 0; i < shardPaths.length; ++i) {
                Path p = shardPaths[i].resolve("index");
                dirs[i] = new SimpleFSDirectory(p, FsDirectoryService.buildLockFactory(indexSettings));
                try {
                    locks[i] = ((Directory)dirs[i]).obtainLock("write.lock");
                    continue;
                }
                catch (IOException ex) {
                    throw new LockObtainFailedException("unable to acquire write.lock for " + p);
                }
            }
        }
        finally {
            IOUtils.closeWhileHandlingException(locks);
            IOUtils.closeWhileHandlingException(dirs);
        }
    }

    public void deleteShardDirectoryUnderLock(ShardLock lock, Settings indexSettings) throws IOException {
        assert (indexSettings != Settings.EMPTY);
        ShardId shardId = lock.getShardId();
        assert (this.isShardLocked(shardId)) : "shard " + shardId + " is not locked";
        Path[] paths = this.availableShardPaths(shardId);
        this.logger.trace("acquiring locks for {}, paths: [{}]", shardId, paths);
        NodeEnvironment.acquireFSLockForPaths(indexSettings, paths);
        IOUtils.rm(paths);
        if (NodeEnvironment.hasCustomDataPath(indexSettings)) {
            Path customLocation = this.resolveCustomLocation(indexSettings, shardId);
            this.logger.trace("acquiring lock for {}, custom path: [{}]", shardId, customLocation);
            NodeEnvironment.acquireFSLockForPaths(indexSettings, customLocation);
            this.logger.trace("deleting custom shard {} directory [{}]", shardId, customLocation);
            IOUtils.rm(customLocation);
        }
        this.logger.trace("deleted shard {} directory, paths: [{}]", shardId, paths);
        assert (!FileSystemUtils.exists(paths));
    }

    private boolean isShardLocked(ShardId id) {
        try {
            this.shardLock(id, 0L).close();
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndexDirectorySafe(Index index, long lockTimeoutMS, Settings indexSettings) throws IOException {
        assert (indexSettings != Settings.EMPTY);
        List<ShardLock> locks = this.lockAllForIndex(index, indexSettings, lockTimeoutMS);
        try {
            this.deleteIndexDirectoryUnderLock(index, indexSettings);
        }
        finally {
            IOUtils.closeWhileHandlingException(locks);
        }
    }

    public void deleteIndexDirectoryUnderLock(Index index, Settings indexSettings) throws IOException {
        assert (indexSettings != Settings.EMPTY);
        Path[] indexPaths = this.indexPaths(index);
        this.logger.trace("deleting index {} directory, paths({}): [{}]", index, indexPaths.length, indexPaths);
        IOUtils.rm(indexPaths);
        if (NodeEnvironment.hasCustomDataPath(indexSettings)) {
            Path customLocation = this.resolveCustomLocation(indexSettings, index.name());
            this.logger.trace("deleting custom index {} directory [{}]", index, customLocation);
            IOUtils.rm(customLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ShardLock> lockAllForIndex(Index index, Settings settings, long lockTimeoutMS) throws IOException {
        Integer numShards = settings.getAsInt("index.number_of_shards", null);
        if (numShards == null || numShards <= 0) {
            throw new IllegalArgumentException("settings must contain a non-null > 0 number of shards");
        }
        this.logger.trace("locking all shards for index {} - [{}]", index, numShards);
        ArrayList<ShardLock> allLocks = new ArrayList<ShardLock>(numShards);
        boolean success = false;
        long startTimeNS = System.nanoTime();
        try {
            for (int i = 0; i < numShards; ++i) {
                long timeoutLeftMS = Math.max(0L, lockTimeoutMS - TimeValue.nsecToMSec(System.nanoTime() - startTimeNS));
                allLocks.add(this.shardLock(new ShardId(index, i), timeoutLeftMS));
            }
            success = true;
            if (success) return allLocks;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            this.logger.trace("unable to lock all shards for index {}", index);
            IOUtils.closeWhileHandlingException(allLocks);
            throw throwable;
        }
        this.logger.trace("unable to lock all shards for index {}", index);
        IOUtils.closeWhileHandlingException(allLocks);
        return allLocks;
    }

    public ShardLock shardLock(ShardId id) throws IOException {
        return this.shardLock(id, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShardLock shardLock(final ShardId id, long lockTimeoutMS) throws IOException {
        boolean acquired;
        InternalShardLock shardLock;
        this.logger.trace("acquiring node shardlock on [{}], timeout [{}]", id, lockTimeoutMS);
        Map<ShardId, InternalShardLock> map = this.shardLocks;
        synchronized (map) {
            if (this.shardLocks.containsKey(id)) {
                shardLock = this.shardLocks.get(id);
                shardLock.incWaitCount();
                acquired = false;
            } else {
                shardLock = new InternalShardLock(id);
                this.shardLocks.put(id, shardLock);
                acquired = true;
            }
        }
        if (!acquired) {
            boolean success = false;
            try {
                shardLock.acquire(lockTimeoutMS);
                success = true;
            }
            finally {
                if (!success) {
                    shardLock.decWaitCount();
                }
            }
        }
        this.logger.trace("successfully acquired shardlock for [{}]", id);
        return new ShardLock(id){

            @Override
            protected void closeInternal() {
                shardLock.release();
                NodeEnvironment.this.logger.trace("released shard lock for [{}]", id);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ShardId> lockedShards() {
        Map<ShardId, InternalShardLock> map = this.shardLocks;
        synchronized (map) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            return ((ImmutableSet.Builder)builder.addAll(this.shardLocks.keySet())).build();
        }
    }

    public int localNodeId() {
        return this.localNodeId;
    }

    public boolean hasNodeFile() {
        return this.nodePaths != null && this.locks != null;
    }

    public Path[] nodeDataPaths() {
        assert (this.assertEnvIsLocked());
        if (this.nodePaths == null || this.locks == null) {
            throw new IllegalStateException("node is not configured to store local location");
        }
        Path[] paths = new Path[this.nodePaths.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = this.nodePaths[i].path;
        }
        return paths;
    }

    public NodePath[] nodePaths() {
        assert (this.assertEnvIsLocked());
        if (this.nodePaths == null || this.locks == null) {
            throw new IllegalStateException("node is not configured to store local location");
        }
        return this.nodePaths;
    }

    public Path[] indexPaths(Index index) {
        assert (this.assertEnvIsLocked());
        Path[] indexPaths = new Path[this.nodePaths.length];
        for (int i = 0; i < this.nodePaths.length; ++i) {
            indexPaths[i] = this.nodePaths[i].indicesPath.resolve(index.name());
        }
        return indexPaths;
    }

    public Path[] availableShardPaths(ShardId shardId) {
        assert (this.assertEnvIsLocked());
        NodePath[] nodePaths = this.nodePaths();
        Path[] shardLocations = new Path[nodePaths.length];
        for (int i = 0; i < nodePaths.length; ++i) {
            shardLocations[i] = nodePaths[i].resolve(shardId);
        }
        return shardLocations;
    }

    public Set<String> findAllIndices() throws IOException {
        if (this.nodePaths == null || this.locks == null) {
            throw new IllegalStateException("node is not configured to store local location");
        }
        assert (this.assertEnvIsLocked());
        HashSet<String> indices = Sets.newHashSet();
        for (NodePath nodePath : this.nodePaths) {
            Path indicesLocation = nodePath.indicesPath;
            if (!Files.isDirectory(indicesLocation, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(indicesLocation);){
                for (Path index : stream) {
                    if (!Files.isDirectory(index, new LinkOption[0])) continue;
                    indices.add(index.getFileName().toString());
                }
            }
        }
        return indices;
    }

    public Set<ShardId> findAllShardIds(Index index) throws IOException {
        assert (index != null);
        if (this.nodePaths == null || this.locks == null) {
            throw new IllegalStateException("node is not configured to store local location");
        }
        assert (this.assertEnvIsLocked());
        HashSet<ShardId> shardIds = Sets.newHashSet();
        String indexName = index.name();
        for (NodePath nodePath : this.nodePaths) {
            Path location = nodePath.indicesPath;
            if (!Files.isDirectory(location, new LinkOption[0])) continue;
            try (DirectoryStream<Path> indexStream = Files.newDirectoryStream(location);){
                for (Path indexPath : indexStream) {
                    if (!indexName.equals(indexPath.getFileName().toString())) continue;
                    shardIds.addAll(NodeEnvironment.findAllShardsForIndex(indexPath));
                }
            }
        }
        return shardIds;
    }

    private static Set<ShardId> findAllShardsForIndex(Path indexPath) throws IOException {
        HashSet<ShardId> shardIds = new HashSet<ShardId>();
        if (Files.isDirectory(indexPath, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(indexPath);){
                String currentIndex = indexPath.getFileName().toString();
                for (Path shardPath : stream) {
                    Integer shardId;
                    if (!Files.isDirectory(shardPath, new LinkOption[0]) || (shardId = Ints.tryParse(shardPath.getFileName().toString())) == null) continue;
                    ShardId id = new ShardId(currentIndex, (int)shardId);
                    shardIds.add(id);
                }
            }
        }
        return shardIds;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true) && this.locks != null) {
            for (Lock lock : this.locks) {
                try {
                    this.logger.trace("releasing lock [{}]", lock);
                    lock.close();
                }
                catch (IOException e) {
                    this.logger.trace("failed to release lock [{}]", e, lock);
                }
            }
        }
    }

    private boolean assertEnvIsLocked() {
        if (!this.closed.get() && this.locks != null) {
            for (Lock lock : this.locks) {
                try {
                    lock.ensureValid();
                }
                catch (IOException e) {
                    this.logger.warn("lock assertion failed", e, new Object[0]);
                    return false;
                }
            }
        }
        return true;
    }

    public void ensureAtomicMoveSupported() throws IOException {
        NodePath[] nodePaths;
        for (NodePath nodePath : nodePaths = this.nodePaths()) {
            assert (Files.isDirectory(nodePath.path, new LinkOption[0])) : nodePath.path + " is not a directory";
            Path src = nodePath.path.resolve("__es__.tmp");
            Files.createFile(src, new FileAttribute[0]);
            Path target = nodePath.path.resolve("__es__.final");
            try {
                Files.move(src, target, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException ex) {
                throw new IllegalStateException("atomic_move is not supported by the filesystem on path [" + nodePath.path + "] atomic_move is required for elasticsearch to work correctly.", ex);
            }
            finally {
                Files.deleteIfExists(src);
                Files.deleteIfExists(target);
            }
        }
    }

    Settings getSettings() {
        return this.settings;
    }

    public static boolean hasCustomDataPath(Settings indexSettings) {
        return indexSettings.get("index.data_path") != null;
    }

    private Path resolveCustomLocation(Settings indexSettings) {
        assert (indexSettings != Settings.EMPTY);
        String customDataDir = indexSettings.get("index.data_path");
        if (customDataDir != null) {
            assert (this.sharedDataPath != null);
            if (this.addNodeId) {
                return this.sharedDataPath.resolve(customDataDir).resolve(Integer.toString(this.localNodeId));
            }
            return this.sharedDataPath.resolve(customDataDir);
        }
        throw new IllegalArgumentException("no custom index.data_path setting available");
    }

    private Path resolveCustomLocation(Settings indexSettings, String indexName) {
        return this.resolveCustomLocation(indexSettings).resolve(indexName);
    }

    public Path resolveCustomLocation(Settings indexSettings, ShardId shardId) {
        return this.resolveCustomLocation(indexSettings, shardId.index().name()).resolve(Integer.toString(shardId.id()));
    }

    public static Path shardStatePathToDataPath(Path shardPath) {
        int count = shardPath.getNameCount();
        assert (Integer.parseInt(shardPath.getName(count - 1).toString()) >= 0);
        assert (INDICES_FOLDER.equals(shardPath.getName(count - 3).toString()));
        return shardPath.getParent().getParent().getParent();
    }

    private final class InternalShardLock {
        private final Semaphore mutex = new Semaphore(1);
        private int waitCount = 1;
        private ShardId shardId;

        InternalShardLock(ShardId id) {
            this.shardId = id;
            this.mutex.acquireUninterruptibly();
        }

        protected void release() {
            this.mutex.release();
            this.decWaitCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incWaitCount() {
            Map map = NodeEnvironment.this.shardLocks;
            synchronized (map) {
                assert (this.waitCount > 0) : "waitCount is " + this.waitCount + " but should be > 0";
                ++this.waitCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decWaitCount() {
            Map map = NodeEnvironment.this.shardLocks;
            synchronized (map) {
                assert (this.waitCount > 0) : "waitCount is " + this.waitCount + " but should be > 0";
                --this.waitCount;
                NodeEnvironment.this.logger.trace("shard lock wait count for [{}] is now [{}]", this.shardId, this.waitCount);
                if (this.waitCount == 0) {
                    NodeEnvironment.this.logger.trace("last shard lock wait decremented, removing lock for [{}]", this.shardId);
                    InternalShardLock remove = (InternalShardLock)NodeEnvironment.this.shardLocks.remove(this.shardId);
                    assert (remove != null) : "Removed lock was null";
                }
            }
        }

        void acquire(long timeoutInMillis) throws LockObtainFailedException {
            try {
                if (!this.mutex.tryAcquire(timeoutInMillis, TimeUnit.MILLISECONDS)) {
                    throw new LockObtainFailedException("Can't lock shard " + this.shardId + ", timed out after " + timeoutInMillis + "ms");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new LockObtainFailedException("Can't lock shard " + this.shardId + ", interrupted", e);
            }
        }
    }

    public static class NodePath {
        public final Path path;
        public final Path indicesPath;
        public final FileStore fileStore;
        public final Boolean spins;

        public NodePath(Path path, Environment environment) throws IOException {
            this.path = path;
            this.indicesPath = path.resolve(NodeEnvironment.INDICES_FOLDER);
            this.fileStore = Environment.getFileStore(path);
            this.spins = this.fileStore.supportsFileAttributeView("lucene") ? (Boolean)this.fileStore.getAttribute("lucene:spins") : null;
        }

        public Path resolve(ShardId shardId) {
            return this.resolve(shardId.index()).resolve(Integer.toString(shardId.id()));
        }

        public Path resolve(Index index) {
            return this.indicesPath.resolve(index.name());
        }

        public String toString() {
            return "NodePath{path=" + this.path + ", spins=" + this.spins + '}';
        }
    }
}

