/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.rounding;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.joda.Joda;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public enum DateTimeUnit {
    WEEK_OF_WEEKYEAR(1, new FieldFunction(){

        @Override
        public DateTimeField apply(DateTimeZone tz) {
            return ISOChronology.getInstance(tz).weekOfWeekyear();
        }
    }),
    YEAR_OF_CENTURY(2, new FieldFunction(){

        @Override
        public DateTimeField apply(DateTimeZone tz) {
            return ISOChronology.getInstance(tz).yearOfCentury();
        }
    }),
    QUARTER(3, new FieldFunction(){

        @Override
        public DateTimeField apply(DateTimeZone tz) {
            return Joda.QuarterOfYear.getField(ISOChronology.getInstance(tz));
        }
    }),
    MONTH_OF_YEAR(4, new FieldFunction(){

        @Override
        public DateTimeField apply(DateTimeZone tz) {
            return ISOChronology.getInstance(tz).monthOfYear();
        }
    }),
    DAY_OF_MONTH(5, new FieldFunction(){

        @Override
        public DateTimeField apply(DateTimeZone tz) {
            return ISOChronology.getInstance(tz).dayOfMonth();
        }
    }),
    HOUR_OF_DAY(6, new FieldFunction(){

        @Override
        public DateTimeField apply(DateTimeZone tz) {
            return ISOChronology.getInstance(tz).hourOfDay();
        }
    }),
    MINUTES_OF_HOUR(7, new FieldFunction(){

        @Override
        public DateTimeField apply(DateTimeZone tz) {
            return ISOChronology.getInstance(tz).minuteOfHour();
        }
    }),
    SECOND_OF_MINUTE(8, new FieldFunction(){

        @Override
        public DateTimeField apply(DateTimeZone tz) {
            return ISOChronology.getInstance(tz).secondOfMinute();
        }
    });

    private final byte id;
    private final FieldFunction fieldFunction;

    private DateTimeUnit(byte id, FieldFunction fieldFunction) {
        this.id = id;
        this.fieldFunction = fieldFunction;
    }

    public byte id() {
        return this.id;
    }

    public DateTimeField field(DateTimeZone tz) {
        return this.fieldFunction.apply(tz);
    }

    public static DateTimeUnit resolve(byte id) {
        switch (id) {
            case 1: {
                return WEEK_OF_WEEKYEAR;
            }
            case 2: {
                return YEAR_OF_CENTURY;
            }
            case 3: {
                return QUARTER;
            }
            case 4: {
                return MONTH_OF_YEAR;
            }
            case 5: {
                return DAY_OF_MONTH;
            }
            case 6: {
                return HOUR_OF_DAY;
            }
            case 7: {
                return MINUTES_OF_HOUR;
            }
            case 8: {
                return SECOND_OF_MINUTE;
            }
        }
        throw new ElasticsearchException("Unknown date time unit id [" + id + "]", new Object[0]);
    }

    private static abstract class FieldFunction {
        private FieldFunction() {
        }

        abstract DateTimeField apply(DateTimeZone var1);
    }
}

