/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.shard.ShardId;

public class RoutingNodes
implements Iterable<RoutingNode> {
    private final MetaData metaData;
    private final ClusterBlocks blocks;
    private final RoutingTable routingTable;
    private final Map<String, RoutingNode> nodesToShards = Maps.newHashMap();
    private final UnassignedShards unassignedShards = new UnassignedShards(this);
    private final Map<ShardId, List<ShardRouting>> assignedShards = Maps.newHashMap();
    private final ImmutableOpenMap<String, ClusterState.Custom> customs;
    private final boolean readOnly;
    private int inactivePrimaryCount = 0;
    private int inactiveShardCount = 0;
    private int relocatingShards = 0;
    private final Map<String, ObjectIntHashMap<String>> nodesPerAttributeNames = new HashMap<String, ObjectIntHashMap<String>>();
    private static final List<ShardRouting> EMPTY = Collections.emptyList();

    public RoutingNodes(ClusterState clusterState) {
        this(clusterState, true);
    }

    public RoutingNodes(ClusterState clusterState, boolean readOnly) {
        this.readOnly = readOnly;
        this.metaData = clusterState.metaData();
        this.blocks = clusterState.blocks();
        this.routingTable = clusterState.routingTable();
        this.customs = clusterState.customs();
        HashMap nodesToShards = Maps.newHashMap();
        for (ObjectCursor<DiscoveryNode> objectCursor : clusterState.nodes().dataNodes().values()) {
            nodesToShards.put(((DiscoveryNode)objectCursor.value).id(), new ArrayList());
        }
        for (IndexRoutingTable indexRoutingTable : this.routingTable.indicesRouting().values()) {
            for (IndexShardRoutingTable indexShard : indexRoutingTable) {
                for (ShardRouting shard : indexShard) {
                    if (shard.assignedToNode()) {
                        List<ShardRouting> entries = (ArrayList<ShardRouting>)nodesToShards.get(shard.currentNodeId());
                        if (entries == null) {
                            entries = new ArrayList<ShardRouting>();
                            nodesToShards.put(shard.currentNodeId(), entries);
                        }
                        ShardRouting sr = RoutingNodes.getRouting(shard, readOnly);
                        entries.add(sr);
                        this.assignedShardsAdd(sr);
                        if (shard.relocating()) {
                            entries = (List)nodesToShards.get(shard.relocatingNodeId());
                            ++this.relocatingShards;
                            if (entries == null) {
                                entries = new ArrayList();
                                nodesToShards.put(shard.relocatingNodeId(), entries);
                            }
                            ShardRouting targetShardRouting = shard.buildTargetRelocatingShard();
                            if (readOnly) {
                                targetShardRouting.freeze();
                            }
                            entries.add(targetShardRouting);
                            this.assignedShardsAdd(targetShardRouting);
                            continue;
                        }
                        if (shard.active()) continue;
                        if (shard.primary()) {
                            ++this.inactivePrimaryCount;
                        }
                        ++this.inactiveShardCount;
                        continue;
                    }
                    ShardRouting sr = RoutingNodes.getRouting(shard, readOnly);
                    this.assignedShardsAdd(sr);
                    this.unassignedShards.add(sr);
                }
            }
        }
        for (Map.Entry entry : nodesToShards.entrySet()) {
            String nodeId = (String)entry.getKey();
            this.nodesToShards.put(nodeId, new RoutingNode(nodeId, clusterState.nodes().get(nodeId), (List)entry.getValue()));
        }
    }

    private static ShardRouting getRouting(ShardRouting src, boolean readOnly) {
        if (readOnly) {
            src.freeze();
        } else {
            src = new ShardRouting(src);
        }
        return src;
    }

    @Override
    public Iterator<RoutingNode> iterator() {
        return Iterators.unmodifiableIterator(this.nodesToShards.values().iterator());
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable();
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public MetaData getMetaData() {
        return this.metaData();
    }

    public ClusterBlocks blocks() {
        return this.blocks;
    }

    public ClusterBlocks getBlocks() {
        return this.blocks;
    }

    public ImmutableOpenMap<String, ClusterState.Custom> customs() {
        return this.customs;
    }

    public <T extends ClusterState.Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public UnassignedShards unassigned() {
        return this.unassignedShards;
    }

    public RoutingNodesIterator nodes() {
        return new RoutingNodesIterator(this.nodesToShards.values().iterator());
    }

    public RoutingNode node(String nodeId) {
        return this.nodesToShards.get(nodeId);
    }

    public ObjectIntHashMap<String> nodesPerAttributesCounts(String attributeName) {
        ObjectIntHashMap<String> nodesPerAttributesCounts = this.nodesPerAttributeNames.get(attributeName);
        if (nodesPerAttributesCounts != null) {
            return nodesPerAttributesCounts;
        }
        nodesPerAttributesCounts = new ObjectIntHashMap();
        for (RoutingNode routingNode : this) {
            String attrValue = routingNode.node().attributes().get(attributeName);
            nodesPerAttributesCounts.addTo(attrValue, 1);
        }
        this.nodesPerAttributeNames.put(attributeName, nodesPerAttributesCounts);
        return nodesPerAttributesCounts;
    }

    public boolean hasUnassignedPrimaries() {
        return this.unassignedShards.getNumPrimaries() + this.unassignedShards.getNumIgnoredPrimaries() > 0;
    }

    public boolean hasUnassignedShards() {
        return !this.unassignedShards.isEmpty() || !this.unassignedShards.isIgnoredEmpty();
    }

    public boolean hasInactivePrimaries() {
        return this.inactivePrimaryCount > 0;
    }

    public boolean hasInactiveShards() {
        return this.inactiveShardCount > 0;
    }

    public int getRelocatingShardCount() {
        return this.relocatingShards;
    }

    public ShardRouting activePrimary(ShardRouting shard) {
        for (ShardRouting shardRouting : this.assignedShards(shard.shardId())) {
            if (!shardRouting.primary() || !shardRouting.active()) continue;
            return shardRouting;
        }
        return null;
    }

    public ShardRouting activeReplica(ShardRouting shard) {
        for (ShardRouting shardRouting : this.assignedShards(shard.shardId())) {
            if (shardRouting.primary() || !shardRouting.active()) continue;
            return shardRouting;
        }
        return null;
    }

    public Iterable<ShardRouting> assignedShards(ShardRouting shard) {
        return this.assignedShards(shard.shardId());
    }

    public boolean allReplicasActive(ShardRouting shardRouting) {
        List<ShardRouting> shards = this.assignedShards(shardRouting.shardId());
        if (shards.isEmpty() || shards.size() < this.routingTable.index(shardRouting.index()).shard(shardRouting.id()).size()) {
            return false;
        }
        for (ShardRouting shard : shards) {
            if (shard.active()) continue;
            return false;
        }
        return true;
    }

    public List<ShardRouting> shards(Predicate<ShardRouting> predicate) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (RoutingNode routingNode : this) {
            for (ShardRouting shardRouting : routingNode) {
                if (!predicate.apply(shardRouting)) continue;
                shards.add(shardRouting);
            }
        }
        return shards;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState ... state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (RoutingNode routingNode : this) {
            shards.addAll(routingNode.shardsWithState(state));
        }
        for (ShardRoutingState s : state) {
            if (s != ShardRoutingState.UNASSIGNED) continue;
            Iterables.addAll(shards, this.unassigned());
            break;
        }
        return shards;
    }

    public List<ShardRouting> shardsWithState(String index, ShardRoutingState ... state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (RoutingNode routingNode : this) {
            shards.addAll(routingNode.shardsWithState(index, state));
        }
        for (ShardRoutingState s : state) {
            if (s != ShardRoutingState.UNASSIGNED) continue;
            for (ShardRouting unassignedShard : this.unassignedShards) {
                if (!unassignedShard.index().equals(index)) continue;
                shards.add(unassignedShard);
            }
            break;
        }
        return shards;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder("routing_nodes:\n");
        for (RoutingNode routingNode : this) {
            sb.append(routingNode.prettyPrint());
        }
        sb.append("---- unassigned\n");
        for (ShardRouting shardEntry : this.unassignedShards) {
            sb.append("--------").append(shardEntry.shortSummary()).append('\n');
        }
        return sb.toString();
    }

    public void initialize(ShardRouting shard, String nodeId, long expectedSize) {
        this.ensureMutable();
        assert (shard.unassigned()) : shard;
        shard.initialize(nodeId, expectedSize);
        this.node(nodeId).add(shard);
        ++this.inactiveShardCount;
        if (shard.primary()) {
            ++this.inactivePrimaryCount;
        }
        this.assignedShardsAdd(shard);
    }

    public ShardRouting relocate(ShardRouting shard, String nodeId, long expectedShardSize) {
        this.ensureMutable();
        ++this.relocatingShards;
        shard.relocate(nodeId, expectedShardSize);
        ShardRouting target = shard.buildTargetRelocatingShard();
        this.node(target.currentNodeId()).add(target);
        this.assignedShardsAdd(target);
        return target;
    }

    public void started(ShardRouting shard) {
        this.ensureMutable();
        assert (!shard.active()) : "expected an intializing shard " + shard;
        if (shard.relocatingNodeId() == null) {
            --this.inactiveShardCount;
            if (shard.primary()) {
                --this.inactivePrimaryCount;
            }
        }
        shard.moveToStarted();
    }

    public void cancelRelocation(ShardRouting shard) {
        this.ensureMutable();
        --this.relocatingShards;
        shard.cancelRelocation();
    }

    public void swapPrimaryFlag(ShardRouting ... shards) {
        this.ensureMutable();
        for (ShardRouting shard : shards) {
            if (shard.primary()) {
                shard.moveFromPrimary();
                if (!shard.unassigned()) continue;
                this.unassignedShards.primaries--;
                continue;
            }
            shard.moveToPrimary();
            if (!shard.unassigned()) continue;
            this.unassignedShards.primaries++;
        }
    }

    private List<ShardRouting> assignedShards(ShardId shardId) {
        List<ShardRouting> replicaSet = this.assignedShards.get(shardId);
        return replicaSet == null ? EMPTY : Collections.unmodifiableList(replicaSet);
    }

    private void remove(ShardRouting shard) {
        this.ensureMutable();
        if (!shard.active() && shard.relocatingNodeId() == null) {
            --this.inactiveShardCount;
            assert (this.inactiveShardCount >= 0);
            if (shard.primary()) {
                --this.inactivePrimaryCount;
            }
        } else if (shard.relocating()) {
            this.cancelRelocation(shard);
        }
        this.assignedShardsRemove(shard);
    }

    private void assignedShardsAdd(ShardRouting shard) {
        if (shard.unassigned()) {
            return;
        }
        List<ShardRouting> shards = this.assignedShards.get(shard.shardId());
        if (shards == null) {
            shards = new ArrayList<ShardRouting>();
            this.assignedShards.put(shard.shardId(), shards);
        }
        assert (this.assertInstanceNotInList(shard, shards));
        shards.add(shard);
    }

    private boolean assertInstanceNotInList(ShardRouting shard, List<ShardRouting> shards) {
        for (ShardRouting s : shards) {
            assert (s != shard);
        }
        return true;
    }

    private void assignedShardsRemove(ShardRouting shard) {
        this.ensureMutable();
        List<ShardRouting> replicaSet = this.assignedShards.get(shard.shardId());
        if (replicaSet != null) {
            Iterator<ShardRouting> iterator = replicaSet.iterator();
            while (iterator.hasNext()) {
                if (shard != iterator.next()) continue;
                iterator.remove();
                return;
            }
            assert (false) : "Illegal state";
        }
    }

    public boolean isKnown(DiscoveryNode node) {
        return this.nodesToShards.containsKey(node.getId());
    }

    public void addNode(DiscoveryNode node) {
        this.ensureMutable();
        RoutingNode routingNode = new RoutingNode(node.id(), node);
        this.nodesToShards.put(routingNode.nodeId(), routingNode);
    }

    public RoutingNodeIterator routingNodeIter(String nodeId) {
        RoutingNode routingNode = this.nodesToShards.get(nodeId);
        if (routingNode == null) {
            return null;
        }
        return new RoutingNodeIterator(routingNode);
    }

    public RoutingNode[] toArray() {
        return this.nodesToShards.values().toArray(new RoutingNode[this.nodesToShards.size()]);
    }

    public void reinitShadowPrimary(ShardRouting candidate) {
        this.ensureMutable();
        if (candidate.relocating()) {
            this.cancelRelocation(candidate);
        }
        candidate.reinitializeShard();
        ++this.inactivePrimaryCount;
        ++this.inactiveShardCount;
    }

    public static boolean assertShardStats(RoutingNodes routingNodes) {
        boolean run = false;
        if (!$assertionsDisabled) {
            run = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!run) {
            return true;
        }
        int unassignedPrimaryCount = 0;
        int unassignedIgnoredPrimaryCount = 0;
        int inactivePrimaryCount = 0;
        int inactiveShardCount = 0;
        int relocating = 0;
        HashMap<String, Integer> indicesAndShards = new HashMap<String, Integer>();
        for (RoutingNode node : routingNodes) {
            for (ShardRouting shardRouting : node) {
                Integer i;
                if (!shardRouting.active() && shardRouting.relocatingNodeId() == null && !shardRouting.relocating()) {
                    ++inactiveShardCount;
                    if (shardRouting.primary()) {
                        ++inactivePrimaryCount;
                    }
                }
                if (shardRouting.relocating()) {
                    ++relocating;
                }
                if ((i = (Integer)indicesAndShards.get(shardRouting.index())) == null) {
                    i = shardRouting.id();
                }
                indicesAndShards.put(shardRouting.index(), Math.max(i, shardRouting.id()));
            }
        }
        Set entries = indicesAndShards.entrySet();
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (Map.Entry entry : entries) {
            String index = (String)entry.getKey();
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                for (RoutingNode routingNode : routingNodes) {
                    for (ShardRouting shardRouting : routingNode) {
                        if (!shardRouting.index().equals(index) || shardRouting.id() != i) continue;
                        shards.add(shardRouting);
                    }
                }
                List<ShardRouting> mutableShardRoutings = routingNodes.assignedShards(new ShardId(index, i));
                assert (mutableShardRoutings.size() == shards.size());
                for (ShardRouting r : mutableShardRoutings) {
                    assert (shards.contains(r));
                    shards.remove(r);
                }
                assert (shards.isEmpty());
            }
        }
        for (ShardRouting shardRouting : routingNodes.unassigned()) {
            if (!shardRouting.primary()) continue;
            ++unassignedPrimaryCount;
        }
        for (ShardRouting shardRouting : routingNodes.unassigned().ignored()) {
            if (!shardRouting.primary()) continue;
            ++unassignedIgnoredPrimaryCount;
        }
        assert (unassignedPrimaryCount == routingNodes.unassignedShards.getNumPrimaries()) : "Unassigned primaries is [" + unassignedPrimaryCount + "] but RoutingNodes returned unassigned primaries [" + routingNodes.unassigned().getNumPrimaries() + "]";
        assert (unassignedIgnoredPrimaryCount == routingNodes.unassignedShards.getNumIgnoredPrimaries()) : "Unassigned ignored primaries is [" + unassignedIgnoredPrimaryCount + "] but RoutingNodes returned unassigned ignored primaries [" + routingNodes.unassigned().getNumIgnoredPrimaries() + "]";
        assert (inactivePrimaryCount == routingNodes.inactivePrimaryCount) : "Inactive Primary count [" + inactivePrimaryCount + "] but RoutingNodes returned inactive primaries [" + routingNodes.inactivePrimaryCount + "]";
        assert (inactiveShardCount == routingNodes.inactiveShardCount) : "Inactive Shard count [" + inactiveShardCount + "] but RoutingNodes returned inactive shards [" + routingNodes.inactiveShardCount + "]";
        assert (routingNodes.getRelocatingShardCount() == relocating) : "Relocating shards mismatch [" + routingNodes.getRelocatingShardCount() + "] but expected [" + relocating + "]";
        return true;
    }

    private void ensureMutable() {
        if (this.readOnly) {
            throw new IllegalStateException("can't modify RoutingNodes - readonly");
        }
    }

    public final class RoutingNodeIterator
    implements Iterator<ShardRouting>,
    Iterable<ShardRouting> {
        private final RoutingNode iterable;
        private ShardRouting shard;
        private final Iterator<ShardRouting> delegate;
        private boolean removed = false;

        public RoutingNodeIterator(RoutingNode iterable) {
            this.delegate = iterable.mutableIterator();
            this.iterable = iterable;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public ShardRouting next() {
            this.removed = false;
            this.shard = this.delegate.next();
            return this.shard;
        }

        @Override
        public void remove() {
            RoutingNodes.this.ensureMutable();
            this.delegate.remove();
            RoutingNodes.this.remove(this.shard);
            this.removed = true;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        @Override
        public Iterator<ShardRouting> iterator() {
            return this.iterable.iterator();
        }

        public void moveToUnassigned(UnassignedInfo unassignedInfo) {
            RoutingNodes.this.ensureMutable();
            if (!this.isRemoved()) {
                this.remove();
            }
            ShardRouting unassigned = new ShardRouting(this.shard);
            unassigned.moveToUnassigned(unassignedInfo);
            RoutingNodes.this.unassigned().add(unassigned);
        }

        public ShardRouting current() {
            return this.shard;
        }
    }

    public class RoutingNodesIterator
    implements Iterator<RoutingNode>,
    Iterable<ShardRouting> {
        private RoutingNode current;
        private final Iterator<RoutingNode> delegate;

        public RoutingNodesIterator(Iterator<RoutingNode> iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public RoutingNode next() {
            this.current = this.delegate.next();
            return this.current;
        }

        public RoutingNodeIterator nodeShards() {
            return new RoutingNodeIterator(this.current);
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public Iterator<ShardRouting> iterator() {
            return this.nodeShards();
        }
    }

    public static final class UnassignedShards
    implements Iterable<ShardRouting> {
        private final RoutingNodes nodes;
        private final List<ShardRouting> unassigned;
        private final List<ShardRouting> ignored;
        private int primaries = 0;
        private int ignoredPrimaries = 0;

        public UnassignedShards(RoutingNodes nodes) {
            this.nodes = nodes;
            this.unassigned = new ArrayList<ShardRouting>();
            this.ignored = new ArrayList<ShardRouting>();
        }

        public void add(ShardRouting shardRouting) {
            if (shardRouting.primary()) {
                ++this.primaries;
            }
            this.unassigned.add(shardRouting);
        }

        public void sort(Comparator<ShardRouting> comparator) {
            CollectionUtil.timSort(this.unassigned, comparator);
        }

        public int size() {
            return this.unassigned.size();
        }

        public int ignoredSize() {
            return this.ignored.size();
        }

        public int getNumPrimaries() {
            return this.primaries;
        }

        public int getNumIgnoredPrimaries() {
            return this.ignoredPrimaries;
        }

        public UnassignedIterator iterator() {
            return new UnassignedIterator();
        }

        public List<ShardRouting> ignored() {
            return Collections.unmodifiableList(this.ignored);
        }

        public void ignoreShard(ShardRouting shard) {
            if (shard.primary()) {
                ++this.ignoredPrimaries;
            }
            this.ignored.add(shard);
        }

        public boolean isEmpty() {
            return this.unassigned.isEmpty();
        }

        public boolean isIgnoredEmpty() {
            return this.ignored.isEmpty();
        }

        public void shuffle() {
            Collections.shuffle(this.unassigned);
        }

        public ShardRouting[] drain() {
            ShardRouting[] mutableShardRoutings = this.unassigned.toArray(new ShardRouting[this.unassigned.size()]);
            this.unassigned.clear();
            this.primaries = 0;
            return mutableShardRoutings;
        }

        public class UnassignedIterator
        implements Iterator<ShardRouting> {
            private final Iterator<ShardRouting> iterator;
            private ShardRouting current;

            public UnassignedIterator() {
                this.iterator = UnassignedShards.this.unassigned.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ShardRouting next() {
                this.current = this.iterator.next();
                return this.current;
            }

            public void initialize(String nodeId, long version, long expectedShardSize) {
                this.innerRemove();
                UnassignedShards.this.nodes.initialize(new ShardRouting(this.current, version), nodeId, expectedShardSize);
            }

            public void removeAndIgnore() {
                this.innerRemove();
                UnassignedShards.this.ignoreShard(this.current);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported in unassigned iterator, use removeAndIgnore or initialize");
            }

            private void innerRemove() {
                UnassignedShards.this.nodes.ensureMutable();
                this.iterator.remove();
                if (this.current.primary()) {
                    UnassignedShards.this.primaries--;
                }
            }
        }
    }
}

