/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;

public class DiscoveryNodeFilters {
    private final Map<String, String[]> filters;
    private final OpType opType;

    public static DiscoveryNodeFilters buildFromSettings(OpType opType, String prefix, Settings settings) {
        return DiscoveryNodeFilters.buildFromKeyValue(opType, settings.getByPrefix(prefix).getAsMap());
    }

    public static DiscoveryNodeFilters buildFromKeyValue(OpType opType, Map<String, String> filters) {
        HashMap<String, String[]> bFilters = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            String[] values = Strings.splitStringByCommaToArray(entry.getValue());
            if (values.length <= 0) continue;
            bFilters.put(entry.getKey(), values);
        }
        if (bFilters.isEmpty()) {
            return null;
        }
        return new DiscoveryNodeFilters(opType, bFilters);
    }

    DiscoveryNodeFilters(OpType opType, Map<String, String[]> filters) {
        this.opType = opType;
        this.filters = filters;
    }

    private boolean matchByIP(String[] values, @Nullable String hostIp, @Nullable String publishIp) {
        for (String value : values) {
            boolean matchIp;
            boolean bl = matchIp = Regex.simpleMatch(value, hostIp) || Regex.simpleMatch(value, publishIp);
            if (!matchIp) continue;
            return matchIp;
        }
        return false;
    }

    public boolean match(DiscoveryNode node) {
        for (Map.Entry<String, String[]> entry : this.filters.entrySet()) {
            int i$;
            String attr = entry.getKey();
            String[] values = entry.getValue();
            if ("_ip".equals(attr)) {
                String publishAddress = null;
                if (node.address() instanceof InetSocketTransportAddress) {
                    publishAddress = NetworkAddress.format(((InetSocketTransportAddress)node.address()).address().getAddress());
                }
                boolean match = this.matchByIP(values, node.getHostAddress(), publishAddress);
                if (this.opType == OpType.AND) {
                    if (match) continue;
                    return false;
                }
                if (!match || this.opType != OpType.OR) continue;
                return true;
            }
            if ("_host_ip".equals(attr)) {
                boolean match = this.matchByIP(values, node.getHostAddress(), null);
                if (this.opType == OpType.AND) {
                    if (match) continue;
                    return false;
                }
                if (!match || this.opType != OpType.OR) continue;
                return true;
            }
            if ("_publish_ip".equals(attr)) {
                String address = null;
                if (node.address() instanceof InetSocketTransportAddress) {
                    address = NetworkAddress.format(((InetSocketTransportAddress)node.address()).address().getAddress());
                }
                boolean match = this.matchByIP(values, address, null);
                if (this.opType == OpType.AND) {
                    if (match) continue;
                    return false;
                }
                if (!match || this.opType != OpType.OR) continue;
                return true;
            }
            if ("_host".equals(attr)) {
                String[] arr$ = values;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String value = arr$[i$];
                    if (Regex.simpleMatch(value, node.getHostName())) {
                        if (this.opType == OpType.OR) {
                            return true;
                        }
                    } else if (this.opType == OpType.AND) {
                        return false;
                    }
                    if (Regex.simpleMatch(value, node.getHostAddress())) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            if ("_id".equals(attr)) {
                String[] arr$ = values;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String value = arr$[i$];
                    if (node.id().equals(value)) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            if ("_name".equals(attr) || "name".equals(attr)) {
                String[] arr$ = values;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String value = arr$[i$];
                    if (Regex.simpleMatch(value, node.name())) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            String nodeAttributeValue = node.attributes().get(attr);
            if (nodeAttributeValue == null) {
                if (this.opType != OpType.AND) continue;
                return false;
            }
            for (String value : values) {
                if (Regex.simpleMatch(value, nodeAttributeValue)) {
                    if (this.opType != OpType.OR) continue;
                    return true;
                }
                if (this.opType != OpType.AND) continue;
                return false;
            }
        }
        return this.opType != OpType.OR;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int entryCount = this.filters.size();
        for (Map.Entry<String, String[]> entry : this.filters.entrySet()) {
            String attr = entry.getKey();
            String[] values = entry.getValue();
            sb.append(attr);
            sb.append(":\"");
            int valueCount = values.length;
            for (String value : values) {
                sb.append(value);
                if (valueCount > 1) {
                    sb.append(" ").append(this.opType.toString()).append(" ");
                }
                --valueCount;
            }
            sb.append("\"");
            if (entryCount > 1) {
                sb.append(",");
            }
            --entryCount;
        }
        return sb.toString();
    }

    public static enum OpType {
        AND,
        OR;

    }
}

