/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;

public class ClusterBlockException
extends ElasticsearchException {
    private final ImmutableSet<ClusterBlock> blocks;

    public ClusterBlockException(ImmutableSet<ClusterBlock> blocks) {
        super(ClusterBlockException.buildMessage(blocks), new Object[0]);
        this.blocks = blocks;
    }

    public ClusterBlockException(StreamInput in) throws IOException {
        super(in);
        int num = in.readVInt();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < num; ++i) {
            builder.add(ClusterBlock.readClusterBlock(in));
        }
        this.blocks = builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.blocks != null) {
            out.writeVInt(this.blocks.size());
            for (ClusterBlock block : this.blocks) {
                block.writeTo(out);
            }
        } else {
            out.writeVInt(0);
        }
    }

    public boolean retryable() {
        for (ClusterBlock block : this.blocks) {
            if (block.retryable()) continue;
            return false;
        }
        return true;
    }

    public ImmutableSet<ClusterBlock> blocks() {
        return this.blocks;
    }

    private static String buildMessage(ImmutableSet<ClusterBlock> blocks) {
        StringBuilder sb = new StringBuilder("blocked by: ");
        for (ClusterBlock block : blocks) {
            sb.append("[").append((Object)block.status()).append("/").append(block.id()).append("/").append(block.description()).append("];");
        }
        return sb.toString();
    }

    @Override
    public RestStatus status() {
        RestStatus status = null;
        for (ClusterBlock block : this.blocks) {
            if (status == null) {
                status = block.status();
                continue;
            }
            if (status.getStatus() >= block.status().getStatus()) continue;
            status = block.status();
        }
        return status;
    }
}

