/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.io.IOException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class NodeMappingRefreshAction
extends AbstractComponent {
    public static final String ACTION_NAME = "internal:cluster/node/mapping/refresh";
    private final TransportService transportService;
    private final MetaDataMappingService metaDataMappingService;

    @Inject
    public NodeMappingRefreshAction(Settings settings, TransportService transportService, MetaDataMappingService metaDataMappingService) {
        super(settings);
        this.transportService = transportService;
        this.metaDataMappingService = metaDataMappingService;
        transportService.registerRequestHandler(ACTION_NAME, NodeMappingRefreshRequest.class, "same", new NodeMappingRefreshTransportHandler());
    }

    public void nodeMappingRefresh(ClusterState state, NodeMappingRefreshRequest request) {
        DiscoveryNodes nodes = state.nodes();
        if (nodes.masterNode() == null) {
            this.logger.warn("can't send mapping refresh for [{}][{}], no master known.", request.index(), Strings.arrayToCommaDelimitedString(request.types()));
            return;
        }
        this.transportService.sendRequest(nodes.masterNode(), ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
    }

    public static class NodeMappingRefreshRequest
    extends TransportRequest
    implements IndicesRequest {
        private String index;
        private String indexUUID = "_na_";
        private String[] types;
        private String nodeId;

        public NodeMappingRefreshRequest() {
        }

        public NodeMappingRefreshRequest(String index, String indexUUID, String[] types, String nodeId) {
            this.index = index;
            this.indexUUID = indexUUID;
            this.types = types;
            this.nodeId = nodeId;
        }

        @Override
        public String[] indices() {
            return new String[]{this.index};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public String index() {
            return this.index;
        }

        public String indexUUID() {
            return this.indexUUID;
        }

        public String[] types() {
            return this.types;
        }

        public String nodeId() {
            return this.nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeStringArray(this.types);
            out.writeString(this.nodeId);
            out.writeString(this.indexUUID);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.index = in.readString();
            this.types = in.readStringArray();
            this.nodeId = in.readString();
            this.indexUUID = in.readString();
        }
    }

    private class NodeMappingRefreshTransportHandler
    extends TransportRequestHandler<NodeMappingRefreshRequest> {
        private NodeMappingRefreshTransportHandler() {
        }

        @Override
        public void messageReceived(NodeMappingRefreshRequest request, TransportChannel channel) throws Exception {
            NodeMappingRefreshAction.this.metaDataMappingService.refreshMapping(request.index(), request.indexUUID());
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }
}

