/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.elasticsearch.Build;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cli.CliTool;
import org.elasticsearch.common.cli.CliToolConfig;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.monitor.jvm.JvmInfo;

final class BootstrapCLIParser
extends CliTool {
    private static final CliToolConfig CONFIG = CliToolConfig.config("elasticsearch", BootstrapCLIParser.class).cmds(Start.access$000(), Version.access$100()).build();

    public BootstrapCLIParser() {
        super(CONFIG);
    }

    public BootstrapCLIParser(Terminal terminal) {
        super(CONFIG, terminal);
    }

    @Override
    protected CliTool.Command parse(String cmdName, CommandLine cli) throws Exception {
        switch (cmdName.toLowerCase(Locale.ROOT)) {
            case "start": {
                return Start.parse(this.terminal, cli);
            }
            case "version": {
                return Version.parse(this.terminal, cli);
            }
        }
        assert (false) : "should never get here, if the user enters an unknown command, an error message should be shown before parse is called";
        return null;
    }

    static class Start
    extends CliTool.Command {
        private static final String NAME = "start";
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd("start", Start.class).options(CliToolConfig.Builder.optionBuilder("d", "daemonize").hasArg(false).required(false), CliToolConfig.Builder.optionBuilder("p", "pidfile").hasArg(true).required(false), CliToolConfig.Builder.optionBuilder("V", "version").hasArg(false).required(false), Option.builder("D").argName("property=value").valueSeparator('=').numberOfArgs(2)).stopAtNonOption(true).build();

        public static CliTool.Command parse(Terminal terminal, CommandLine cli) {
            String key;
            String pidFile;
            if (cli.hasOption("V")) {
                return Version.parse(terminal, cli);
            }
            if (cli.hasOption("d")) {
                System.setProperty("es.foreground", "false");
            }
            if (!Strings.isNullOrEmpty(pidFile = cli.getOptionValue("pidfile"))) {
                System.setProperty("es.pidfile", pidFile);
            }
            if (cli.hasOption("D")) {
                Properties properties = cli.getOptionProperties("D");
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    key = (String)entry.getKey();
                    String propertyName = key.startsWith("es.") ? key : "es." + key;
                    System.setProperty(propertyName, entry.getValue().toString());
                }
            }
            Iterator<String> iterator = cli.getArgList().iterator();
            while (iterator.hasNext()) {
                String arg = iterator.next();
                if (!arg.startsWith("--")) {
                    if (arg.startsWith("-D") || arg.startsWith("-d") || arg.startsWith("-p")) {
                        throw new IllegalArgumentException("Parameter [" + arg + "] starting with \"-D\", \"-d\" or \"-p\" must be before any parameters starting with --");
                    }
                    throw new IllegalArgumentException("Parameter [" + arg + "]does not start with --");
                }
                if ((arg = arg.replace("--", "")).contains("=")) {
                    String[] splitArg = arg.split("=", 2);
                    key = splitArg[0];
                    String value = splitArg[1];
                    System.setProperty("es." + key, value);
                    continue;
                }
                if (iterator.hasNext()) {
                    String value = iterator.next();
                    if (value.startsWith("--")) {
                        throw new IllegalArgumentException("Parameter [" + arg + "] needs value");
                    }
                    System.setProperty("es." + arg, value);
                    continue;
                }
                throw new IllegalArgumentException("Parameter [" + arg + "] needs value");
            }
            return new Start(terminal);
        }

        public Start(Terminal terminal) {
            super(terminal);
        }

        @Override
        public CliTool.ExitStatus execute(Settings settings, Environment env) throws Exception {
            return CliTool.ExitStatus.OK;
        }

        static /* synthetic */ CliToolConfig.Cmd access$000() {
            return CMD;
        }
    }

    static class Version
    extends CliTool.Command {
        private static final String NAME = "version";
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd("version", Version.class).build();

        public static CliTool.Command parse(Terminal terminal, CommandLine cli) {
            return new Version(terminal);
        }

        public Version(Terminal terminal) {
            super(terminal);
        }

        @Override
        public CliTool.ExitStatus execute(Settings settings, Environment env) throws Exception {
            this.terminal.println("Version: %s, Build: %s/%s, JVM: %s", org.elasticsearch.Version.CURRENT, Build.CURRENT.hashShort(), Build.CURRENT.timestamp(), JvmInfo.jvmInfo().version());
            return CliTool.ExitStatus.OK_AND_EXIT;
        }

        static /* synthetic */ CliToolConfig.Cmd access$100() {
            return CMD;
        }
    }
}

