/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.get;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;

public class GetIndexResponse
extends ActionResponse {
    private ImmutableOpenMap<String, List<IndexWarmersMetaData.Entry>> warmers = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappings = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, List<AliasMetaData>> aliases = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, Settings> settings = ImmutableOpenMap.of();
    private String[] indices;

    GetIndexResponse(String[] indices, ImmutableOpenMap<String, List<IndexWarmersMetaData.Entry>> warmers, ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappings, ImmutableOpenMap<String, List<AliasMetaData>> aliases, ImmutableOpenMap<String, Settings> settings) {
        this.indices = indices;
        if (warmers != null) {
            this.warmers = warmers;
        }
        if (mappings != null) {
            this.mappings = mappings;
        }
        if (aliases != null) {
            this.aliases = aliases;
        }
        if (settings != null) {
            this.settings = settings;
        }
    }

    GetIndexResponse() {
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] getIndices() {
        return this.indices();
    }

    public ImmutableOpenMap<String, List<IndexWarmersMetaData.Entry>> warmers() {
        return this.warmers;
    }

    public ImmutableOpenMap<String, List<IndexWarmersMetaData.Entry>> getWarmers() {
        return this.warmers();
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> getMappings() {
        return this.mappings();
    }

    public ImmutableOpenMap<String, List<AliasMetaData>> aliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, List<AliasMetaData>> getAliases() {
        return this.aliases();
    }

    public ImmutableOpenMap<String, Settings> settings() {
        return this.settings;
    }

    public ImmutableOpenMap<String, Settings> getSettings() {
        return this.settings();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        int warmersSize = in.readVInt();
        ImmutableOpenMap.Builder warmersMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < warmersSize; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ArrayList<IndexWarmersMetaData.Entry> warmerEntryBuilder = new ArrayList<IndexWarmersMetaData.Entry>();
            for (int j = 0; j < valueSize; ++j) {
                warmerEntryBuilder.add(new IndexWarmersMetaData.Entry(in.readString(), in.readStringArray(), in.readOptionalBoolean(), in.readBytesReference()));
            }
            warmersMapBuilder.put(key, Collections.unmodifiableList(warmerEntryBuilder));
        }
        this.warmers = warmersMapBuilder.build();
        int mappingsSize = in.readVInt();
        ImmutableOpenMap.Builder mappingsMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < mappingsSize; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ImmutableOpenMap.Builder<String, MappingMetaData> mappingEntryBuilder = ImmutableOpenMap.builder();
            for (int j = 0; j < valueSize; ++j) {
                mappingEntryBuilder.put(in.readString(), MappingMetaData.PROTO.readFrom(in));
            }
            mappingsMapBuilder.put(key, mappingEntryBuilder.build());
        }
        this.mappings = mappingsMapBuilder.build();
        int aliasesSize = in.readVInt();
        ImmutableOpenMap.Builder aliasesMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < aliasesSize; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ArrayList<AliasMetaData> aliasEntryBuilder = new ArrayList<AliasMetaData>();
            for (int j = 0; j < valueSize; ++j) {
                aliasEntryBuilder.add(AliasMetaData.Builder.readFrom(in));
            }
            aliasesMapBuilder.put(key, Collections.unmodifiableList(aliasEntryBuilder));
        }
        this.aliases = aliasesMapBuilder.build();
        int settingsSize = in.readVInt();
        ImmutableOpenMap.Builder<String, Settings> settingsMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < settingsSize; ++i) {
            String key = in.readString();
            settingsMapBuilder.put(key, Settings.readSettingsFromStream(in));
        }
        this.settings = settingsMapBuilder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeVInt(this.warmers.size());
        for (ObjectObjectCursor<String, List<IndexWarmersMetaData.Entry>> objectObjectCursor : this.warmers) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((List)objectObjectCursor.value).size());
            for (IndexWarmersMetaData.Entry warmerEntry : (List)objectObjectCursor.value) {
                out.writeString(warmerEntry.name());
                out.writeStringArray(warmerEntry.types());
                out.writeOptionalBoolean(warmerEntry.requestCache());
                out.writeBytesReference(warmerEntry.source());
            }
        }
        out.writeVInt(this.mappings.size());
        for (ObjectObjectCursor<String, Iterable<IndexWarmersMetaData.Entry>> objectObjectCursor : this.mappings) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((ImmutableOpenMap)objectObjectCursor.value).size());
            for (ObjectObjectCursor mappingEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                out.writeString((String)mappingEntry.key);
                ((MappingMetaData)mappingEntry.value).writeTo(out);
            }
        }
        out.writeVInt(this.aliases.size());
        for (ObjectObjectCursor<String, Iterable<IndexWarmersMetaData.Entry>> objectObjectCursor : this.aliases) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((List)objectObjectCursor.value).size());
            for (AliasMetaData aliasEntry : (List)objectObjectCursor.value) {
                aliasEntry.writeTo(out);
            }
        }
        out.writeVInt(this.settings.size());
        for (ObjectObjectCursor<String, Object> objectObjectCursor : this.settings) {
            out.writeString((String)objectObjectCursor.key);
            Settings.writeSettingsToStream((Settings)objectObjectCursor.value, out);
        }
    }
}

