/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.cursors.ObjectIntCursor;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.plugins.PluginInfo;

public class ClusterStatsNodes
implements ToXContent,
Streamable {
    private Counts counts;
    private Set<Version> versions;
    private OsStats os;
    private ProcessStats process;
    private JvmStats jvm;
    private FsInfo.Path fs;
    private Set<PluginInfo> plugins;

    private ClusterStatsNodes() {
    }

    public ClusterStatsNodes(ClusterStatsNodeResponse[] nodeResponses) {
        this.counts = new Counts();
        this.versions = new HashSet<Version>();
        this.os = new OsStats();
        this.jvm = new JvmStats();
        this.fs = new FsInfo.Path();
        this.plugins = new HashSet<PluginInfo>();
        this.process = new ProcessStats();
        HashSet<InetAddress> seenAddresses = new HashSet<InetAddress>(nodeResponses.length);
        for (ClusterStatsNodeResponse nodeResponse : nodeResponses) {
            this.counts.addNodeInfo(nodeResponse.nodeInfo());
            this.versions.add(nodeResponse.nodeInfo().getVersion());
            this.process.addNodeStats(nodeResponse.nodeStats());
            this.jvm.addNodeInfoStats(nodeResponse.nodeInfo(), nodeResponse.nodeStats());
            this.plugins.addAll(nodeResponse.nodeInfo().getPlugins().getPluginInfos());
            TransportAddress publishAddress = nodeResponse.nodeInfo().getTransport().address().publishAddress();
            InetAddress inetAddress = null;
            if (publishAddress.uniqueAddressTypeId() == 1) {
                inetAddress = ((InetSocketTransportAddress)publishAddress).address().getAddress();
            }
            if (!seenAddresses.add(inetAddress)) continue;
            this.os.addNodeInfoStats(nodeResponse.nodeInfo(), nodeResponse.nodeStats());
            if (nodeResponse.nodeStats().getFs() == null) continue;
            this.fs.add(nodeResponse.nodeStats().getFs().total());
        }
    }

    public Counts getCounts() {
        return this.counts;
    }

    public Set<Version> getVersions() {
        return this.versions;
    }

    public OsStats getOs() {
        return this.os;
    }

    public ProcessStats getProcess() {
        return this.process;
    }

    public JvmStats getJvm() {
        return this.jvm;
    }

    public FsInfo.Path getFs() {
        return this.fs;
    }

    public Set<PluginInfo> getPlugins() {
        return this.plugins;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size;
        this.counts = Counts.readCounts(in);
        this.versions = new HashSet<Version>(size);
        for (size = in.readVInt(); size > 0; --size) {
            this.versions.add(Version.readVersion(in));
        }
        this.os = OsStats.readOsStats(in);
        this.process = ProcessStats.readStats(in);
        this.jvm = JvmStats.readJvmStats(in);
        this.fs = FsInfo.Path.readInfoFrom(in);
        this.plugins = new HashSet<PluginInfo>(size);
        for (size = in.readVInt(); size > 0; --size) {
            this.plugins.add(PluginInfo.readFromStream(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.counts.writeTo(out);
        out.writeVInt(this.versions.size());
        for (Version v : this.versions) {
            Version.writeVersion(v, out);
        }
        this.os.writeTo(out);
        this.process.writeTo(out);
        this.jvm.writeTo(out);
        this.fs.writeTo(out);
        out.writeVInt(this.plugins.size());
        for (PluginInfo p : this.plugins) {
            p.writeTo(out);
        }
    }

    public static ClusterStatsNodes readNodeStats(StreamInput in) throws IOException {
        ClusterStatsNodes nodeStats = new ClusterStatsNodes();
        nodeStats.readFrom(in);
        return nodeStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.COUNT);
        this.counts.toXContent(builder, params);
        builder.endObject();
        builder.startArray(Fields.VERSIONS);
        for (Version v : this.versions) {
            builder.value(v.toString());
        }
        builder.endArray();
        builder.startObject(Fields.OS);
        this.os.toXContent(builder, params);
        builder.endObject();
        builder.startObject(Fields.PROCESS);
        this.process.toXContent(builder, params);
        builder.endObject();
        builder.startObject(Fields.JVM);
        this.jvm.toXContent(builder, params);
        builder.endObject();
        builder.field(Fields.FS);
        this.fs.toXContent(builder, params);
        builder.startArray(Fields.PLUGINS);
        for (PluginInfo pluginInfo : this.plugins) {
            pluginInfo.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static class JvmVersion
    implements Streamable {
        String version;
        String vmName;
        String vmVersion;
        String vmVendor;

        JvmVersion(JvmInfo jvmInfo) {
            this.version = jvmInfo.version();
            this.vmName = jvmInfo.getVmName();
            this.vmVersion = jvmInfo.getVmVersion();
            this.vmVendor = jvmInfo.getVmVendor();
        }

        JvmVersion() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JvmVersion jvm = (JvmVersion)o;
            return this.vmVersion.equals(jvm.vmVersion) && this.vmVendor.equals(jvm.vmVendor);
        }

        public int hashCode() {
            return this.vmVersion.hashCode();
        }

        public static JvmVersion readJvmVersion(StreamInput in) throws IOException {
            JvmVersion jvm = new JvmVersion();
            jvm.readFrom(in);
            return jvm;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.version = in.readString();
            this.vmName = in.readString();
            this.vmVersion = in.readString();
            this.vmVendor = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.version);
            out.writeString(this.vmName);
            out.writeString(this.vmVersion);
            out.writeString(this.vmVendor);
        }
    }

    public static class JvmStats
    implements Streamable,
    ToXContent {
        ObjectIntHashMap<JvmVersion> versions = new ObjectIntHashMap();
        long threads = 0L;
        long maxUptime = 0L;
        long heapUsed = 0L;
        long heapMax = 0L;

        JvmStats() {
        }

        public ObjectIntHashMap<JvmVersion> getVersions() {
            return this.versions;
        }

        public long getThreads() {
            return this.threads;
        }

        public TimeValue getMaxUpTime() {
            return new TimeValue(this.maxUptime);
        }

        public ByteSizeValue getHeapUsed() {
            return new ByteSizeValue(this.heapUsed);
        }

        public ByteSizeValue getHeapMax() {
            return new ByteSizeValue(this.heapMax);
        }

        public void addNodeInfoStats(NodeInfo nodeInfo, NodeStats nodeStats) {
            this.versions.addTo(new JvmVersion(nodeInfo.getJvm()), 1);
            org.elasticsearch.monitor.jvm.JvmStats js = nodeStats.getJvm();
            if (js == null) {
                return;
            }
            if (js.getThreads() != null) {
                this.threads += (long)js.getThreads().getCount();
            }
            this.maxUptime = Math.max(this.maxUptime, js.getUptime().millis());
            if (js.getMem() != null) {
                this.heapUsed += js.getMem().getHeapUsed().bytes();
                this.heapMax += js.getMem().getHeapMax().bytes();
            }
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int size;
            this.versions = new ObjectIntHashMap(size);
            for (size = in.readVInt(); size > 0; --size) {
                this.versions.addTo(JvmVersion.readJvmVersion(in), in.readVInt());
            }
            this.threads = in.readVLong();
            this.maxUptime = in.readVLong();
            this.heapUsed = in.readVLong();
            this.heapMax = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.versions.size());
            for (ObjectIntCursor<JvmVersion> objectIntCursor : this.versions) {
                ((JvmVersion)objectIntCursor.key).writeTo(out);
                out.writeVInt(objectIntCursor.value);
            }
            out.writeVLong(this.threads);
            out.writeVLong(this.maxUptime);
            out.writeVLong(this.heapUsed);
            out.writeVLong(this.heapMax);
        }

        public static JvmStats readJvmStats(StreamInput in) throws IOException {
            JvmStats jvmStats = new JvmStats();
            jvmStats.readFrom(in);
            return jvmStats;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.timeValueField(Fields.MAX_UPTIME_IN_MILLIS, Fields.MAX_UPTIME, this.maxUptime);
            builder.startArray(Fields.VERSIONS);
            for (ObjectIntCursor<JvmVersion> objectIntCursor : this.versions) {
                builder.startObject();
                builder.field(Fields.VERSION, ((JvmVersion)objectIntCursor.key).version);
                builder.field(Fields.VM_NAME, ((JvmVersion)objectIntCursor.key).vmName);
                builder.field(Fields.VM_VERSION, ((JvmVersion)objectIntCursor.key).vmVersion);
                builder.field(Fields.VM_VENDOR, ((JvmVersion)objectIntCursor.key).vmVendor);
                builder.field(Fields.COUNT, objectIntCursor.value);
                builder.endObject();
            }
            builder.endArray();
            builder.startObject(Fields.MEM);
            builder.byteSizeField(Fields.HEAP_USED_IN_BYTES, Fields.HEAP_USED, this.heapUsed);
            builder.byteSizeField(Fields.HEAP_MAX_IN_BYTES, Fields.HEAP_MAX, this.heapMax);
            builder.endObject();
            builder.field(Fields.THREADS, this.threads);
            return builder;
        }

        static final class Fields {
            static final XContentBuilderString VERSIONS = new XContentBuilderString("versions");
            static final XContentBuilderString VERSION = new XContentBuilderString("version");
            static final XContentBuilderString VM_NAME = new XContentBuilderString("vm_name");
            static final XContentBuilderString VM_VERSION = new XContentBuilderString("vm_version");
            static final XContentBuilderString VM_VENDOR = new XContentBuilderString("vm_vendor");
            static final XContentBuilderString COUNT = new XContentBuilderString("count");
            static final XContentBuilderString THREADS = new XContentBuilderString("threads");
            static final XContentBuilderString MAX_UPTIME = new XContentBuilderString("max_uptime");
            static final XContentBuilderString MAX_UPTIME_IN_MILLIS = new XContentBuilderString("max_uptime_in_millis");
            static final XContentBuilderString MEM = new XContentBuilderString("mem");
            static final XContentBuilderString HEAP_USED = new XContentBuilderString("heap_used");
            static final XContentBuilderString HEAP_USED_IN_BYTES = new XContentBuilderString("heap_used_in_bytes");
            static final XContentBuilderString HEAP_MAX = new XContentBuilderString("heap_max");
            static final XContentBuilderString HEAP_MAX_IN_BYTES = new XContentBuilderString("heap_max_in_bytes");

            Fields() {
            }
        }
    }

    public static class ProcessStats
    implements ToXContent,
    Streamable {
        int count;
        int cpuPercent;
        long totalOpenFileDescriptors;
        long minOpenFileDescriptors = Long.MAX_VALUE;
        long maxOpenFileDescriptors = Long.MIN_VALUE;

        public void addNodeStats(NodeStats nodeStats) {
            long fd;
            if (nodeStats.getProcess() == null) {
                return;
            }
            ++this.count;
            if (nodeStats.getProcess().getCpu() != null) {
                this.cpuPercent += nodeStats.getProcess().getCpu().getPercent();
            }
            if ((fd = nodeStats.getProcess().getOpenFileDescriptors()) > 0L) {
                this.totalOpenFileDescriptors += fd;
            }
            this.minOpenFileDescriptors = Math.min(this.minOpenFileDescriptors, fd);
            this.maxOpenFileDescriptors = Math.max(this.maxOpenFileDescriptors, fd);
        }

        public int getCpuPercent() {
            return this.cpuPercent;
        }

        public long getAvgOpenFileDescriptors() {
            if (this.count == 0) {
                return -1L;
            }
            return this.totalOpenFileDescriptors / (long)this.count;
        }

        public long getMaxOpenFileDescriptors() {
            if (this.count == 0) {
                return -1L;
            }
            return this.maxOpenFileDescriptors;
        }

        public long getMinOpenFileDescriptors() {
            if (this.count == 0) {
                return -1L;
            }
            return this.minOpenFileDescriptors;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.count = in.readVInt();
            this.cpuPercent = in.readVInt();
            this.totalOpenFileDescriptors = in.readVLong();
            this.minOpenFileDescriptors = in.readLong();
            this.maxOpenFileDescriptors = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.count);
            out.writeVInt(this.cpuPercent);
            out.writeVLong(this.totalOpenFileDescriptors);
            out.writeLong(this.minOpenFileDescriptors);
            out.writeLong(this.maxOpenFileDescriptors);
        }

        public static ProcessStats readStats(StreamInput in) throws IOException {
            ProcessStats cpu = new ProcessStats();
            cpu.readFrom(in);
            return cpu;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(Fields.CPU).field(Fields.PERCENT, this.cpuPercent).endObject();
            if (this.count > 0) {
                builder.startObject(Fields.OPEN_FILE_DESCRIPTORS);
                builder.field(Fields.MIN, this.getMinOpenFileDescriptors());
                builder.field(Fields.MAX, this.getMaxOpenFileDescriptors());
                builder.field(Fields.AVG, this.getAvgOpenFileDescriptors());
                builder.endObject();
            }
            return builder;
        }

        static final class Fields {
            static final XContentBuilderString CPU = new XContentBuilderString("cpu");
            static final XContentBuilderString PERCENT = new XContentBuilderString("percent");
            static final XContentBuilderString OPEN_FILE_DESCRIPTORS = new XContentBuilderString("open_file_descriptors");
            static final XContentBuilderString MIN = new XContentBuilderString("min");
            static final XContentBuilderString MAX = new XContentBuilderString("max");
            static final XContentBuilderString AVG = new XContentBuilderString("avg");

            Fields() {
            }
        }
    }

    public static class OsStats
    implements ToXContent,
    Streamable {
        int availableProcessors;
        int allocatedProcessors;
        long availableMemory;
        final ObjectIntHashMap<String> names = new ObjectIntHashMap();

        public void addNodeInfoStats(NodeInfo nodeInfo, NodeStats nodeStats) {
            this.availableProcessors += nodeInfo.getOs().getAvailableProcessors();
            this.allocatedProcessors += nodeInfo.getOs().getAllocatedProcessors();
            if (nodeInfo.getOs().getName() != null) {
                this.names.addTo(nodeInfo.getOs().getName(), 1);
            }
            if (nodeStats.getOs() != null && nodeStats.getOs().getMem() != null) {
                this.availableMemory += nodeStats.getOs().getMem().getFree().bytes();
            }
        }

        public int getAvailableProcessors() {
            return this.availableProcessors;
        }

        public int getAllocatedProcessors() {
            return this.allocatedProcessors;
        }

        public ByteSizeValue getAvailableMemory() {
            return new ByteSizeValue(this.availableMemory);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.availableProcessors = in.readVInt();
            if (in.getVersion().onOrAfter(Version.V_2_1_0)) {
                this.allocatedProcessors = in.readVInt();
            }
            this.availableMemory = in.readLong();
            int size = in.readVInt();
            this.names.clear();
            for (int i = 0; i < size; ++i) {
                this.names.addTo(in.readString(), in.readVInt());
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.availableProcessors);
            if (out.getVersion().onOrAfter(Version.V_2_1_0)) {
                out.writeVInt(this.allocatedProcessors);
            }
            out.writeLong(this.availableMemory);
            out.writeVInt(this.names.size());
            for (ObjectIntCursor<String> objectIntCursor : this.names) {
                out.writeString((String)objectIntCursor.key);
                out.writeVInt(objectIntCursor.value);
            }
        }

        public static OsStats readOsStats(StreamInput in) throws IOException {
            OsStats os = new OsStats();
            os.readFrom(in);
            return os;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(Fields.AVAILABLE_PROCESSORS, this.availableProcessors);
            builder.field(Fields.ALLOCATED_PROCESSORS, this.allocatedProcessors);
            builder.startObject(Fields.MEM);
            builder.byteSizeField(Fields.TOTAL_IN_BYTES, Fields.TOTAL, this.availableMemory);
            builder.endObject();
            builder.startArray(Fields.NAMES);
            for (ObjectIntCursor<String> objectIntCursor : this.names) {
                builder.startObject();
                builder.field(Fields.NAME, (String)objectIntCursor.key);
                builder.field(Fields.COUNT, objectIntCursor.value);
                builder.endObject();
            }
            builder.endArray();
            return builder;
        }

        static final class Fields {
            static final XContentBuilderString AVAILABLE_PROCESSORS = new XContentBuilderString("available_processors");
            static final XContentBuilderString ALLOCATED_PROCESSORS = new XContentBuilderString("allocated_processors");
            static final XContentBuilderString NAME = new XContentBuilderString("name");
            static final XContentBuilderString NAMES = new XContentBuilderString("names");
            static final XContentBuilderString MEM = new XContentBuilderString("mem");
            static final XContentBuilderString TOTAL = new XContentBuilderString("total");
            static final XContentBuilderString TOTAL_IN_BYTES = new XContentBuilderString("total_in_bytes");
            static final XContentBuilderString COUNT = new XContentBuilderString("count");

            Fields() {
            }
        }
    }

    public static class Counts
    implements Streamable,
    ToXContent {
        int total;
        int masterOnly;
        int dataOnly;
        int masterData;
        int client;

        public void addNodeInfo(NodeInfo nodeInfo) {
            ++this.total;
            DiscoveryNode node = nodeInfo.getNode();
            if (node.masterNode()) {
                if (node.dataNode()) {
                    ++this.masterData;
                } else {
                    ++this.masterOnly;
                }
            } else if (node.dataNode()) {
                ++this.dataOnly;
            } else if (node.clientNode()) {
                ++this.client;
            }
        }

        public int getTotal() {
            return this.total;
        }

        public int getMasterOnly() {
            return this.masterOnly;
        }

        public int getDataOnly() {
            return this.dataOnly;
        }

        public int getMasterData() {
            return this.masterData;
        }

        public int getClient() {
            return this.client;
        }

        public static Counts readCounts(StreamInput in) throws IOException {
            Counts c = new Counts();
            c.readFrom(in);
            return c;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.total = in.readVInt();
            this.masterOnly = in.readVInt();
            this.dataOnly = in.readVInt();
            this.masterData = in.readVInt();
            this.client = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.total);
            out.writeVInt(this.masterOnly);
            out.writeVInt(this.dataOnly);
            out.writeVInt(this.masterData);
            out.writeVInt(this.client);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(Fields.TOTAL, this.total);
            builder.field(Fields.MASTER_ONLY, this.masterOnly);
            builder.field(Fields.DATA_ONLY, this.dataOnly);
            builder.field(Fields.MASTER_DATA, this.masterData);
            builder.field(Fields.CLIENT, this.client);
            return builder;
        }

        static final class Fields {
            static final XContentBuilderString TOTAL = new XContentBuilderString("total");
            static final XContentBuilderString MASTER_ONLY = new XContentBuilderString("master_only");
            static final XContentBuilderString DATA_ONLY = new XContentBuilderString("data_only");
            static final XContentBuilderString MASTER_DATA = new XContentBuilderString("master_data");
            static final XContentBuilderString CLIENT = new XContentBuilderString("client");

            Fields() {
            }
        }
    }

    static final class Fields {
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString VERSIONS = new XContentBuilderString("versions");
        static final XContentBuilderString OS = new XContentBuilderString("os");
        static final XContentBuilderString PROCESS = new XContentBuilderString("process");
        static final XContentBuilderString JVM = new XContentBuilderString("jvm");
        static final XContentBuilderString FS = new XContentBuilderString("fs");
        static final XContentBuilderString PLUGINS = new XContentBuilderString("plugins");

        Fields() {
        }
    }
}

