/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public class PrefixAnalyzer
extends Analyzer {
    private final char separator;
    private final Iterable<? extends CharSequence> prefix;
    private final Analyzer analyzer;

    public PrefixAnalyzer(Analyzer analyzer, char separator, CharSequence prefix) {
        this(analyzer, separator, Collections.singleton(prefix));
    }

    public PrefixAnalyzer(Analyzer analyzer, char separator, Iterable<? extends CharSequence> prefix) {
        this.analyzer = analyzer;
        this.prefix = prefix;
        this.separator = separator;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Analyzer.TokenStreamComponents createComponents = this.analyzer.createComponents(fieldName);
        PrefixTokenFilter stream = new PrefixTokenFilter(createComponents.getTokenStream(), this.separator, this.prefix);
        Analyzer.TokenStreamComponents tsc = new Analyzer.TokenStreamComponents(createComponents.getTokenizer(), stream);
        return tsc;
    }

    public static final class PrefixTokenFilter
    extends TokenFilter {
        private final char separator;
        private final CharTermAttribute termAttr = this.addAttribute(CharTermAttribute.class);
        private final PositionIncrementAttribute posAttr = this.addAttribute(PositionIncrementAttribute.class);
        private final Iterable<? extends CharSequence> prefixes;
        private Iterator<? extends CharSequence> currentPrefix;

        public PrefixTokenFilter(TokenStream input, char separator, Iterable<? extends CharSequence> prefixes) {
            super(input);
            this.prefixes = prefixes;
            this.currentPrefix = null;
            this.separator = separator;
            if (prefixes == null || !prefixes.iterator().hasNext()) {
                throw new IllegalArgumentException("one or more prefixes needed");
            }
        }

        @Override
        public boolean incrementToken() throws IOException {
            if (this.currentPrefix != null) {
                if (!this.currentPrefix.hasNext()) {
                    return this.input.incrementToken();
                }
                this.posAttr.setPositionIncrement(0);
            } else {
                this.currentPrefix = this.prefixes.iterator();
                this.termAttr.setEmpty();
                this.posAttr.setPositionIncrement(1);
                assert (this.currentPrefix.hasNext()) : "one or more prefixes needed";
            }
            this.termAttr.setEmpty();
            this.termAttr.append(this.currentPrefix.next());
            this.termAttr.append(this.separator);
            return true;
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            this.currentPrefix = null;
        }
    }
}

