/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.tree;

import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.EscapeFilter;
import com.hubspot.jinjava.objects.SafeString;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.output.OutputNode;
import com.hubspot.jinjava.tree.output.RenderedOutputNode;
import com.hubspot.jinjava.tree.parse.ExpressionToken;
import com.hubspot.jinjava.util.Logging;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ExpressionNode
extends Node {
    private static final long serialVersionUID = -6063173739682221042L;
    private final ExpressionToken master;

    public ExpressionNode(ExpressionToken token) {
        super(token, token.getLineNumber(), token.getStartPosition());
        this.master = token;
    }

    @Override
    public OutputNode render(JinjavaInterpreter interpreter) {
        Object var;
        try {
            var = interpreter.resolveELExpression(this.master.getExpr(), this.getLineNumber());
        }
        catch (DeferredValueException e) {
            interpreter.getContext().addDeferredNode(this);
            var = this.master.getImage();
        }
        String result = Objects.toString(var, "");
        if (interpreter.getConfig().isNestedInterpretationEnabled() && !StringUtils.equals(result, this.master.getImage()) && (StringUtils.contains((CharSequence)result, this.getSymbols().getExpressionStart()) || StringUtils.contains((CharSequence)result, this.getSymbols().getExpressionStartWithTag()))) {
            try {
                result = interpreter.renderFlat(result);
            }
            catch (Exception e) {
                Logging.ENGINE_LOG.warn("Error rendering variable node result", e);
            }
        }
        if (interpreter.getContext().isAutoEscape() && !(var instanceof SafeString)) {
            result = EscapeFilter.escapeHtmlEntities(result);
        }
        return new RenderedOutputNode(result);
    }

    public String toString() {
        return this.master.toString();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

