/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.zeppelin.org.apache.http.impl.io;

import java.io.IOException;
import shaded.org.apache.zeppelin.org.apache.http.HttpException;
import shaded.org.apache.zeppelin.org.apache.http.HttpResponse;
import shaded.org.apache.zeppelin.org.apache.http.HttpResponseFactory;
import shaded.org.apache.zeppelin.org.apache.http.NoHttpResponseException;
import shaded.org.apache.zeppelin.org.apache.http.ParseException;
import shaded.org.apache.zeppelin.org.apache.http.StatusLine;
import shaded.org.apache.zeppelin.org.apache.http.annotation.NotThreadSafe;
import shaded.org.apache.zeppelin.org.apache.http.config.MessageConstraints;
import shaded.org.apache.zeppelin.org.apache.http.impl.DefaultHttpResponseFactory;
import shaded.org.apache.zeppelin.org.apache.http.impl.io.AbstractMessageParser;
import shaded.org.apache.zeppelin.org.apache.http.io.SessionInputBuffer;
import shaded.org.apache.zeppelin.org.apache.http.message.LineParser;
import shaded.org.apache.zeppelin.org.apache.http.message.ParserCursor;
import shaded.org.apache.zeppelin.org.apache.http.params.HttpParams;
import shaded.org.apache.zeppelin.org.apache.http.util.Args;
import shaded.org.apache.zeppelin.org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.responseFactory = Args.notNull(responseFactory, "Response factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

