/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.dep;

import java.util.LinkedList;
import java.util.List;

public class Dependency {
    private String groupArtifactVersion;
    private boolean local = false;
    private List<String> exclusions;

    public Dependency(String groupArtifactVersion) {
        this.groupArtifactVersion = groupArtifactVersion;
        this.exclusions = new LinkedList<String>();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Dependency)) {
            return false;
        }
        return ((Dependency)o).groupArtifactVersion.equals(this.groupArtifactVersion);
    }

    public Dependency local() {
        this.local = true;
        return this;
    }

    public Dependency excludeAll() {
        this.exclude("*");
        return this;
    }

    public Dependency exclude(String exclusions) {
        for (String item : exclusions.split(",|\n")) {
            this.exclusions.add(item);
        }
        return this;
    }

    public String getGroupArtifactVersion() {
        return this.groupArtifactVersion;
    }

    public boolean isDist() {
        return !this.local;
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }

    public boolean isLocalFsArtifact() {
        int numSplits = this.groupArtifactVersion.split(":").length;
        return numSplits < 3 || numSplits > 6;
    }
}

