/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.internal;

import com.influxdb.Arguments;
import com.influxdb.Cancellable;
import com.influxdb.query.FluxColumn;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import com.influxdb.query.exceptions.FluxCsvParserException;
import com.influxdb.query.exceptions.FluxQueryException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okio.BufferedSource;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class FluxCsvParser {
    private static final int ERROR_RECORD_INDEX = 4;

    public void parseFluxResponse(@Nonnull BufferedSource bufferedSource, @Nonnull Cancellable cancellable, @Nonnull FluxResponseConsumer consumer) throws IOException {
        Arguments.checkNotNull(bufferedSource, "bufferedSource");
        InputStreamReader reader = new InputStreamReader(bufferedSource.inputStream());
        ParsingState parsingState = ParsingState.NORMAL;
        try (CSVParser parser = new CSVParser(reader, CSVFormat.DEFAULT);){
            int tableIndex = 0;
            int tableId = -1;
            boolean startNewTable = false;
            FluxTable table = null;
            for (CSVRecord csvRecord : parser) {
                if (cancellable.isCancelled()) {
                    return;
                }
                long recordNumber = csvRecord.getRecordNumber();
                if (4L == recordNumber && csvRecord.get(1).equals("error") && csvRecord.get(2).equals("reference")) {
                    parsingState = ParsingState.IN_ERROR;
                    continue;
                }
                if (ParsingState.IN_ERROR.equals((Object)parsingState)) {
                    String error = csvRecord.get(1);
                    String referenceValue = csvRecord.get(2);
                    int reference = 0;
                    if (referenceValue != null && !referenceValue.isEmpty()) {
                        reference = Integer.valueOf(referenceValue);
                    }
                    throw new FluxQueryException(error, reference);
                }
                String token = csvRecord.get(0);
                if ("#datatype".equals(token)) {
                    startNewTable = true;
                    table = new FluxTable();
                    consumer.accept(tableIndex, cancellable, table);
                    ++tableIndex;
                    tableId = -1;
                } else if (table == null) {
                    String message = "Unable to parse CSV response. FluxTable definition was not found.";
                    throw new FluxCsvParserException(message);
                }
                if ("#datatype".equals(token)) {
                    this.addDataTypes(table, this.toList(csvRecord));
                    continue;
                }
                if ("#group".equals(token)) {
                    this.addGroups(table, this.toList(csvRecord));
                    continue;
                }
                if ("#default".equals(token)) {
                    this.addDefaultEmptyValues(table, this.toList(csvRecord));
                    continue;
                }
                if (startNewTable) {
                    this.addColumnNamesAndTags(table, this.toList(csvRecord));
                    startNewTable = false;
                    continue;
                }
                int currentId = Integer.parseInt(csvRecord.get(2));
                if (tableId == -1) {
                    tableId = currentId;
                }
                if (tableId != currentId) {
                    List<FluxColumn> fluxColumns = table.getColumns();
                    table = new FluxTable();
                    table.getColumns().addAll(fluxColumns);
                    consumer.accept(tableIndex, cancellable, table);
                    ++tableIndex;
                    tableId = currentId;
                }
                FluxRecord fluxRecord = this.parseRecord(tableIndex - 1, table, csvRecord);
                consumer.accept(tableIndex - 1, cancellable, fluxRecord);
            }
        }
    }

    private FluxRecord parseRecord(int tableIndex, FluxTable table, CSVRecord csvRecord) {
        FluxRecord record = new FluxRecord(tableIndex);
        for (FluxColumn fluxColumn : table.getColumns()) {
            String columnName = fluxColumn.getLabel();
            String strValue = csvRecord.get(fluxColumn.getIndex() + 1);
            record.getValues().put(columnName, this.toValue(strValue, fluxColumn));
        }
        return record;
    }

    @Nonnull
    private List<String> toList(CSVRecord csvRecord) {
        ArrayList<String> ret = new ArrayList<String>(csvRecord.size());
        int size = csvRecord.size();
        for (int i = 1; i < size; ++i) {
            String rec = csvRecord.get(i);
            ret.add(rec);
        }
        return ret;
    }

    @Nullable
    private Object toValue(@Nullable String strValue, @Nonnull FluxColumn column) {
        String dataType;
        Arguments.checkNotNull(column, "column");
        if (strValue == null || strValue.isEmpty()) {
            String defaultValue = column.getDefaultValue();
            if (defaultValue == null || defaultValue.isEmpty()) {
                return null;
            }
            return this.toValue(defaultValue, column);
        }
        switch (dataType = column.getDataType()) {
            case "boolean": {
                return Boolean.valueOf(strValue);
            }
            case "unsignedLong": {
                return Long.parseUnsignedLong(strValue);
            }
            case "long": {
                return Long.parseLong(strValue);
            }
            case "double": {
                return Double.parseDouble(strValue);
            }
            case "base64Binary": {
                return Base64.getDecoder().decode(strValue);
            }
            case "dateTime:RFC3339": 
            case "dateTime:RFC3339Nano": {
                return Instant.parse(strValue);
            }
            case "duration": {
                return Duration.ofNanos(Long.parseUnsignedLong(strValue));
            }
        }
        return strValue;
    }

    private void addDataTypes(@Nonnull FluxTable table, @Nonnull List<String> dataTypes) {
        Arguments.checkNotNull(table, "table");
        Arguments.checkNotNull(dataTypes, "dataTypes");
        for (int index = 0; index < dataTypes.size(); ++index) {
            String dataType = dataTypes.get(index);
            FluxColumn columnDef = new FluxColumn();
            columnDef.setDataType(dataType);
            columnDef.setIndex(index);
            table.getColumns().add(columnDef);
        }
    }

    private void addGroups(@Nonnull FluxTable table, @Nonnull List<String> groups) {
        Arguments.checkNotNull(table, "table");
        Arguments.checkNotNull(groups, "groups");
        for (int i = 0; i < groups.size(); ++i) {
            FluxColumn fluxColumn = this.getFluxColumn(i, table);
            String group = groups.get(i);
            fluxColumn.setGroup(Boolean.valueOf(group));
        }
    }

    private void addDefaultEmptyValues(@Nonnull FluxTable table, @Nonnull List<String> defaultEmptyValues) {
        Arguments.checkNotNull(table, "table");
        Arguments.checkNotNull(defaultEmptyValues, "defaultEmptyValues");
        for (int i = 0; i < defaultEmptyValues.size(); ++i) {
            FluxColumn fluxColumn = this.getFluxColumn(i, table);
            String defaultValue = defaultEmptyValues.get(i);
            fluxColumn.setDefaultValue(defaultValue);
        }
    }

    private void addColumnNamesAndTags(@Nonnull FluxTable table, @Nonnull List<String> columnNames) {
        Arguments.checkNotNull(table, "table");
        Arguments.checkNotNull(columnNames, "columnNames");
        int size = columnNames.size();
        for (int i = 0; i < size; ++i) {
            FluxColumn fluxColumn = this.getFluxColumn(i, table);
            String columnName = columnNames.get(i);
            fluxColumn.setLabel(columnName);
        }
    }

    @Nonnull
    private FluxColumn getFluxColumn(int columnIndex, @Nonnull FluxTable table) {
        Arguments.checkNotNull(table, "table");
        return table.getColumns().get(columnIndex);
    }

    public class FluxResponseConsumerTable
    implements FluxResponseConsumer {
        private List<FluxTable> tables = new ArrayList<FluxTable>();

        @Override
        public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxTable table) {
            this.tables.add(index, table);
        }

        @Override
        public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxRecord record) {
            this.tables.get(index).getRecords().add(record);
        }

        @Nonnull
        public List<FluxTable> getTables() {
            return this.tables;
        }
    }

    public static interface FluxResponseConsumer {
        public void accept(int var1, @Nonnull Cancellable var2, @Nonnull FluxTable var3);

        public void accept(int var1, @Nonnull Cancellable var2, @Nonnull FluxRecord var3);
    }

    private static enum ParsingState {
        NORMAL,
        IN_ERROR;

    }
}

