/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.Axes;
import com.influxdb.client.domain.DashboardColor;
import com.influxdb.client.domain.DashboardQuery;
import com.influxdb.client.domain.Legend;
import com.influxdb.client.domain.ViewProperties;
import com.influxdb.client.domain.XYGeom;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class XYViewProperties
extends ViewProperties {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.XY;
    public static final String SERIALIZED_NAME_QUERIES = "queries";
    @SerializedName(value="queries")
    private List<DashboardQuery> queries = new ArrayList<DashboardQuery>();
    public static final String SERIALIZED_NAME_COLORS = "colors";
    @SerializedName(value="colors")
    private List<DashboardColor> colors = new ArrayList<DashboardColor>();
    public static final String SERIALIZED_NAME_SHAPE = "shape";
    @SerializedName(value="shape")
    private ShapeEnum shape = ShapeEnum.CHRONOGRAF_V2;
    public static final String SERIALIZED_NAME_NOTE = "note";
    @SerializedName(value="note")
    private String note;
    public static final String SERIALIZED_NAME_SHOW_NOTE_WHEN_EMPTY = "showNoteWhenEmpty";
    @SerializedName(value="showNoteWhenEmpty")
    private Boolean showNoteWhenEmpty;
    public static final String SERIALIZED_NAME_AXES = "axes";
    @SerializedName(value="axes")
    private Axes axes = null;
    public static final String SERIALIZED_NAME_LEGEND = "legend";
    @SerializedName(value="legend")
    private Legend legend = null;
    public static final String SERIALIZED_NAME_X_COLUMN = "xColumn";
    @SerializedName(value="xColumn")
    private String xColumn;
    public static final String SERIALIZED_NAME_Y_COLUMN = "yColumn";
    @SerializedName(value="yColumn")
    private String yColumn;
    public static final String SERIALIZED_NAME_SHADE_BELOW = "shadeBelow";
    @SerializedName(value="shadeBelow")
    private Boolean shadeBelow;
    public static final String SERIALIZED_NAME_GEOM = "geom";
    @SerializedName(value="geom")
    private XYGeom geom = null;

    @ApiModelProperty(required=true, value="")
    public TypeEnum getType() {
        return this.type;
    }

    public XYViewProperties queries(List<DashboardQuery> queries) {
        this.queries = queries;
        return this;
    }

    public XYViewProperties addQueriesItem(DashboardQuery queriesItem) {
        this.queries.add(queriesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<DashboardQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<DashboardQuery> queries) {
        this.queries = queries;
    }

    public XYViewProperties colors(List<DashboardColor> colors) {
        this.colors = colors;
        return this;
    }

    public XYViewProperties addColorsItem(DashboardColor colorsItem) {
        this.colors.add(colorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Colors define color encoding of data into a visualization")
    public List<DashboardColor> getColors() {
        return this.colors;
    }

    public void setColors(List<DashboardColor> colors) {
        this.colors = colors;
    }

    @ApiModelProperty(required=true, value="")
    public ShapeEnum getShape() {
        return this.shape;
    }

    public XYViewProperties note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public XYViewProperties showNoteWhenEmpty(Boolean showNoteWhenEmpty) {
        this.showNoteWhenEmpty = showNoteWhenEmpty;
        return this;
    }

    @ApiModelProperty(required=true, value="If true, will display note when empty")
    public Boolean getShowNoteWhenEmpty() {
        return this.showNoteWhenEmpty;
    }

    public void setShowNoteWhenEmpty(Boolean showNoteWhenEmpty) {
        this.showNoteWhenEmpty = showNoteWhenEmpty;
    }

    public XYViewProperties axes(Axes axes) {
        this.axes = axes;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Axes getAxes() {
        return this.axes;
    }

    public void setAxes(Axes axes) {
        this.axes = axes;
    }

    public XYViewProperties legend(Legend legend) {
        this.legend = legend;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend legend) {
        this.legend = legend;
    }

    public XYViewProperties xColumn(String xColumn) {
        this.xColumn = xColumn;
        return this;
    }

    @ApiModelProperty(value="")
    public String getXColumn() {
        return this.xColumn;
    }

    public void setXColumn(String xColumn) {
        this.xColumn = xColumn;
    }

    public XYViewProperties yColumn(String yColumn) {
        this.yColumn = yColumn;
        return this;
    }

    @ApiModelProperty(value="")
    public String getYColumn() {
        return this.yColumn;
    }

    public void setYColumn(String yColumn) {
        this.yColumn = yColumn;
    }

    public XYViewProperties shadeBelow(Boolean shadeBelow) {
        this.shadeBelow = shadeBelow;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getShadeBelow() {
        return this.shadeBelow;
    }

    public void setShadeBelow(Boolean shadeBelow) {
        this.shadeBelow = shadeBelow;
    }

    public XYViewProperties geom(XYGeom geom) {
        this.geom = geom;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public XYGeom getGeom() {
        return this.geom;
    }

    public void setGeom(XYGeom geom) {
        this.geom = geom;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XYViewProperties xyViewProperties = (XYViewProperties)o;
        return Objects.equals((Object)this.type, (Object)xyViewProperties.type) && Objects.equals(this.queries, xyViewProperties.queries) && Objects.equals(this.colors, xyViewProperties.colors) && Objects.equals((Object)this.shape, (Object)xyViewProperties.shape) && Objects.equals(this.note, xyViewProperties.note) && Objects.equals(this.showNoteWhenEmpty, xyViewProperties.showNoteWhenEmpty) && Objects.equals(this.axes, xyViewProperties.axes) && Objects.equals(this.legend, xyViewProperties.legend) && Objects.equals(this.xColumn, xyViewProperties.xColumn) && Objects.equals(this.yColumn, xyViewProperties.yColumn) && Objects.equals(this.shadeBelow, xyViewProperties.shadeBelow) && Objects.equals((Object)this.geom, (Object)xyViewProperties.geom) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.queries, this.colors, this.shape, this.note, this.showNoteWhenEmpty, this.axes, this.legend, this.xColumn, this.yColumn, this.shadeBelow, this.geom, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class XYViewProperties {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    colors: ").append(this.toIndentedString(this.colors)).append("\n");
        sb.append("    shape: ").append(this.toIndentedString((Object)this.shape)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    showNoteWhenEmpty: ").append(this.toIndentedString(this.showNoteWhenEmpty)).append("\n");
        sb.append("    axes: ").append(this.toIndentedString(this.axes)).append("\n");
        sb.append("    legend: ").append(this.toIndentedString(this.legend)).append("\n");
        sb.append("    xColumn: ").append(this.toIndentedString(this.xColumn)).append("\n");
        sb.append("    yColumn: ").append(this.toIndentedString(this.yColumn)).append("\n");
        sb.append("    shadeBelow: ").append(this.toIndentedString(this.shadeBelow)).append("\n");
        sb.append("    geom: ").append(this.toIndentedString((Object)this.geom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShapeEnum {
        CHRONOGRAF_V2("chronograf-v2");

        private String value;

        private ShapeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShapeEnum fromValue(String text) {
            for (ShapeEnum b : ShapeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShapeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, ShapeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public ShapeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShapeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        XY("xy");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

