/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.filter;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.scalate.CompilerException;
import org.fusesource.scalate.RenderContext;
import org.fusesource.scalate.filter.CoffeeScriptCompiler$;
import org.fusesource.scalate.filter.CompilationError;
import org.fusesource.scalate.filter.Filter;
import org.fusesource.scalate.support.RenderHelper$;
import org.fusesource.scalate.util.Log;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.Nothing$;

public final class CoffeeScriptFilter$
implements Filter,
Log {
    public static CoffeeScriptFilter$ MODULE$;
    private final boolean serverSideCompile;
    private final AtomicBoolean warnedMissingRhino;
    private Logger log;
    private volatile boolean bitmap$0;

    static {
        new CoffeeScriptFilter$();
    }

    @Override
    public void error(Function0<String> m, Seq<Object> args) {
        Log.error$(this, m, args);
    }

    @Override
    public void error(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.error$(this, e, m, args);
    }

    @Override
    public void error(Throwable e) {
        Log.error$(this, e);
    }

    @Override
    public void warn(Function0<String> m, Seq<Object> args) {
        Log.warn$(this, m, args);
    }

    @Override
    public void warn(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.warn$(this, e, m, args);
    }

    @Override
    public void warn(Throwable e) {
        Log.warn$(this, e);
    }

    @Override
    public void info(Function0<String> m, Seq<Object> args) {
        Log.info$(this, m, args);
    }

    @Override
    public void info(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.info$(this, e, m, args);
    }

    @Override
    public void info(Throwable e) {
        Log.info$(this, e);
    }

    @Override
    public void debug(Function0<String> m, Seq<Object> args) {
        Log.debug$(this, m, args);
    }

    @Override
    public void debug(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.debug$(this, e, m, args);
    }

    @Override
    public void debug(Throwable e) {
        Log.debug$(this, e);
    }

    @Override
    public void trace(Function0<String> m, Seq<Object> args) {
        Log.trace$(this, m, args);
    }

    @Override
    public void trace(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.trace$(this, e, m, args);
    }

    @Override
    public void trace(Throwable e) {
        Log.trace$(this, e);
    }

    private Logger log$lzycompute() {
        CoffeeScriptFilter$ coffeeScriptFilter$ = this;
        synchronized (coffeeScriptFilter$) {
            if (!this.bitmap$0) {
                this.log = Log.log$(this);
                this.bitmap$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$0 ? this.log$lzycompute() : this.log;
    }

    public boolean serverSideCompile() {
        return this.serverSideCompile;
    }

    public AtomicBoolean warnedMissingRhino() {
        return this.warnedMissingRhino;
    }

    @Override
    public String filter(RenderContext context, String content) {
        String string;
        if (this.serverSideCompile()) {
            try {
                string = (String)CoffeeScriptCompiler$.MODULE$.compile(content, new Some<String>(context.currentTemplate())).fold((Function1<CompilationError, Nothing$> & Serializable & scala.Serializable)error -> {
                    MODULE$.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Could not compile coffeescript: ").append(error).toString(), Predef$.MODULE$.genericWrapArray(new Object[]{error}));
                    throw new CompilerException(error.message(), Nil$.MODULE$);
                }, (Function1<String, String> & Serializable & scala.Serializable)coffee -> new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("<script type='text/javascript'>\n            |  //<![CDATA[\n            |    ")).stripMargin()).append(RenderHelper$.MODULE$.indent("    ", coffee)).append(new StringOps(Predef$.MODULE$.augmentString("\n            |  //]]>\n            |</script>")).stripMargin()).toString());
            }
            catch (NoClassDefFoundError e) {
                string = this.missingRhino$1(e, context, content);
            }
            catch (ClassNotFoundException e) {
                string = this.missingRhino$1(e, context, content);
            }
        } else {
            string = CoffeeScriptFilter$.clientSideCompile$1(context, content);
        }
        return string;
    }

    private static final String clientSideCompile$1(RenderContext context$1, String content$1) {
        context$1.attributes().update("REQUIRES_COFFEE_SCRIPT_JS", "true");
        return new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("<script type='text/coffeescript'>\n         |  //<![CDATA[\n         |    ")).stripMargin()).append(RenderHelper$.MODULE$.indent("    ", content$1)).append(new StringOps(Predef$.MODULE$.augmentString("\n         |  //]]>\n         |</script>")).stripMargin()).toString();
    }

    private final String missingRhino$1(Throwable e, RenderContext context$1, String content$1) {
        block0: {
            if (!this.warnedMissingRhino().compareAndSet(false, true)) break block0;
            this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(67).append("No Rhino on the classpath: ").append(e).append(". Using client side CoffeeScript compile").toString(), Predef$.MODULE$.genericWrapArray(new Object[]{e}));
        }
        return CoffeeScriptFilter$.clientSideCompile$1(context$1, content$1);
    }

    private CoffeeScriptFilter$() {
        MODULE$ = this;
        Log.$init$(this);
        this.serverSideCompile = true;
        this.warnedMissingRhino = new AtomicBoolean();
    }
}

