/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.shaded.guava.common.net.InetAddresses;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.cassandra.InterpreterLogic;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraInterpreter
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraInterpreter.class);
    public static final String CASSANDRA_INTERPRETER_PARALLELISM = "cassandra.interpreter.parallelism";
    public static final String CASSANDRA_HOSTS = "cassandra.hosts";
    public static final String CASSANDRA_PORT = "cassandra.native.port";
    public static final String CASSANDRA_PROTOCOL_VERSION = "cassandra.protocol.version";
    public static final String CASSANDRA_CLUSTER_NAME = "cassandra.cluster";
    public static final String CASSANDRA_KEYSPACE_NAME = "cassandra.keyspace";
    public static final String CASSANDRA_COMPRESSION_PROTOCOL = "cassandra.compression.protocol";
    public static final String CASSANDRA_CREDENTIALS_USERNAME = "cassandra.credentials.username";
    public static final String CASSANDRA_CREDENTIALS_PASSWORD = "cassandra.credentials.password";
    public static final String CASSANDRA_LOAD_BALANCING_POLICY = "cassandra.load.balancing.policy";
    public static final String CASSANDRA_RETRY_POLICY = "cassandra.retry.policy";
    public static final String CASSANDRA_RECONNECTION_POLICY = "cassandra.reconnection.policy";
    public static final String CASSANDRA_SPECULATIVE_EXECUTION_POLICY = "cassandra.speculative.execution.policy";
    public static final String CASSANDRA_MAX_SCHEMA_AGREEMENT_WAIT_SECONDS = "cassandra.max.schema.agreement.wait.second";
    public static final String CASSANDRA_POOLING_CONNECTION_PER_HOST_LOCAL = "cassandra.pooling.connection.per.host.local";
    public static final String CASSANDRA_POOLING_CONNECTION_PER_HOST_REMOTE = "cassandra.pooling.connection.per.host.remote";
    public static final String CASSANDRA_POOLING_MAX_REQUESTS_PER_CONNECTION = "cassandra.pooling.max.request.per.connection";
    public static final String CASSANDRA_POOLING_POOL_TIMEOUT_MILLIS = "cassandra.pooling.pool.timeout.millisecs";
    public static final String CASSANDRA_POOLING_HEARTBEAT_INTERVAL_SECONDS = "cassandra.pooling.heartbeat.interval.seconds";
    public static final String CASSANDRA_QUERY_DEFAULT_CONSISTENCY = "cassandra.query.default.consistency";
    public static final String CASSANDRA_QUERY_DEFAULT_SERIAL_CONSISTENCY = "cassandra.query.default.serial.consistency";
    public static final String CASSANDRA_QUERY_DEFAULT_FETCH_SIZE = "cassandra.query.default.fetchSize";
    public static final String CASSANDRA_QUERY_DEFAULT_IDEMPOTENCE = "cassandra.query.default.idempotence";
    public static final String CASSANDRA_SOCKET_CONNECTION_TIMEOUT_MILLIS = "cassandra.socket.connection.timeout.millisecs";
    public static final String CASSANDRA_SOCKET_KEEP_ALIVE = "cassandra.socket.keep.alive";
    public static final String CASSANDRA_SOCKET_READ_TIMEOUT_MILLIS = "cassandra.socket.read.timeout.millisecs";
    public static final String CASSANDRA_SOCKET_RECEIVED_BUFFER_SIZE_BYTES = "cassandra.socket.received.buffer.size.bytes";
    public static final String CASSANDRA_SOCKET_REUSE_ADDRESS = "cassandra.socket.reuse.address";
    public static final String CASSANDRA_SOCKET_SEND_BUFFER_SIZE_BYTES = "cassandra.socket.send.buffer.size.bytes";
    public static final String CASSANDRA_SOCKET_SO_LINGER = "cassandra.socket.soLinger";
    public static final String CASSANDRA_SOCKET_TCP_NO_DELAY = "cassandra.socket.tcp.no_delay";
    public static final String CASSANDRA_WITH_SSL = "cassandra.ssl.enabled";
    public static final String CASSANDRA_TRUSTSTORE_PATH = "cassandra.ssl.truststore.path";
    public static final String CASSANDRA_TRUSTSTORE_PASSWORD = "cassandra.ssl.truststore.password";
    public static final String CASSANDRA_FORMAT_FLOAT_PRECISION = "cassandra.format.float_precision";
    public static final String CASSANDRA_FORMAT_DOUBLE_PRECISION = "cassandra.format.double_precision";
    public static final String CASSANDRA_FORMAT_DECIMAL_PRECISION = "cassandra.format.decimal_precision";
    public static final String CASSANDRA_FORMAT_TIMESTAMP = "cassandra.format.timestamp";
    public static final String CASSANDRA_FORMAT_TIME = "cassandra.format.time";
    public static final String CASSANDRA_FORMAT_DATE = "cassandra.format.date";
    public static final String CASSANDRA_FORMAT_TYPE = "cassandra.format.output";
    public static final String CASSANDRA_FORMAT_TIMEZONE = "cassandra.format.timezone";
    public static final String CASSANDRA_FORMAT_LOCALE = "cassandra.format.locale";
    public static final String NONE_VALUE = "none";
    public static final String DEFAULT_VALUE = "DEFAULT";
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final String DEFAULT_PORT = "9042";
    public static final String DEFAULT_KEYSPACE = "system";
    public static final String DEFAULT_PROTOCOL_VERSION = "DEFAULT";
    public static final String DEFAULT_COMPRESSION = "none";
    public static final String DEFAULT_CONNECTIONS_PER_HOST = "1";
    public static final String DEFAULT_MAX_REQUEST_PER_CONNECTION = "1024";
    public static final String DEFAULT_POLICY = "DEFAULT";
    public static final String DEFAULT_PARALLELISM = "10";
    public static final String DEFAULT_POOL_TIMEOUT = "5000";
    public static final String DEFAULT_HEARTBEAT_INTERVAL = "30";
    public static final String DEFAULT_CONSISTENCY = "ONE";
    public static final String DEFAULT_SERIAL_CONSISTENCY = "SERIAL";
    public static final String DEFAULT_FETCH_SIZE = "5000";
    public static final String DEFAULT_CONNECTION_TIMEOUT = "5000";
    public static final String DEFAULT_READ_TIMEOUT = "12000";
    public static final String DEFAULT_TCP_NO_DELAY = "true";
    public static final String DEFAULT_MAX_SCHEMA_AGREEMENT_WAIT_SECONDS = "12";
    static final List<InterpreterCompletion> NO_COMPLETION = new ArrayList<InterpreterCompletion>();
    public static final String DATASTAX_JAVA_DRIVER_PREFIX = "datastax-java-driver.";
    public static final String MILLISECONDS_STR = " milliseconds";
    public static final String SECONDS_STR = " seconds";
    InterpreterLogic helper;
    CqlSession session;
    private static final Map<String, DriverOption> optionMap = new HashMap<String, DriverOption>();

    public CassandraInterpreter(Properties properties) {
        super(properties);
    }

    public void open() {
        String runWithSSL;
        String keyspace;
        String[] addresses = this.getProperty(CASSANDRA_HOSTS, DEFAULT_HOST).trim().split(",");
        int port = Integer.parseInt(this.getProperty(CASSANDRA_PORT, DEFAULT_PORT));
        ArrayList<InetSocketAddress> hosts = new ArrayList<InetSocketAddress>();
        for (String address : addresses) {
            if (StringUtils.isBlank(address)) continue;
            LOGGER.debug("Adding contact point: {}", (Object)address);
            if (InetAddresses.isInetAddress(address)) {
                hosts.add(new InetSocketAddress(address, port));
                continue;
            }
            hosts.add(InetSocketAddress.createUnresolved(address, port));
        }
        LOGGER.info("Bootstrapping Cassandra Java Driver to connect to {} on port {}", (Object)this.getProperty(CASSANDRA_HOSTS), (Object)port);
        DriverConfigLoader loader = this.createLoader();
        LOGGER.debug("Creating cluster builder");
        CqlSessionBuilder clusterBuilder = (CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().withApplicationName("Zeppelin")).withApplicationVersion("");
        if (!hosts.isEmpty()) {
            LOGGER.debug("Adding contact points");
            clusterBuilder.addContactPoints(hosts);
        }
        String username = this.getProperty(CASSANDRA_CREDENTIALS_USERNAME, "none").trim();
        String password = this.getProperty(CASSANDRA_CREDENTIALS_PASSWORD, "none").trim();
        if (StringUtils.isNotBlank(username) && StringUtils.isNotBlank(password) && !"none".equalsIgnoreCase(username) && !"none".equalsIgnoreCase(password)) {
            LOGGER.debug("Adding credentials. Username = {}", (Object)username);
            clusterBuilder.withAuthCredentials(username, password);
        }
        if (StringUtils.isNotBlank(keyspace = this.getProperty(CASSANDRA_KEYSPACE_NAME, DEFAULT_KEYSPACE)) && !DEFAULT_KEYSPACE.equalsIgnoreCase(keyspace)) {
            LOGGER.debug("Set default keyspace");
            clusterBuilder.withKeyspace(keyspace);
        }
        if (DEFAULT_TCP_NO_DELAY.equalsIgnoreCase(runWithSSL = this.getProperty(CASSANDRA_WITH_SSL, "false"))) {
            LOGGER.debug("Using SSL");
            try {
                KeyStore keyStore = KeyStore.getInstance("JKS");
                InputStream stream = Files.newInputStream(Paths.get(this.getProperty(CASSANDRA_TRUSTSTORE_PATH), new String[0]), new OpenOption[0]);
                keyStore.load(stream, this.getProperty(CASSANDRA_TRUSTSTORE_PASSWORD).toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
                clusterBuilder = (CqlSessionBuilder)clusterBuilder.withSslContext(sslContext);
            }
            catch (Exception e) {
                LOGGER.error("Exception initializing SSL {}", (Object)e.toString());
            }
        } else {
            LOGGER.debug("Not using SSL");
        }
        LOGGER.debug("Creating CqlSession");
        this.session = (CqlSession)((CqlSessionBuilder)clusterBuilder.withConfigLoader(loader)).build();
        LOGGER.debug("Session configuration");
        for (Map.Entry entry : this.session.getContext().getConfig().getDefaultProfile().entrySet()) {
            LOGGER.debug("{} = {}", entry.getKey(), (Object)entry.getValue().toString());
        }
        LOGGER.debug("Creating helper");
        this.helper = new InterpreterLogic(this.session, this.properties);
    }

    private DriverConfigLoader createLoader() {
        LOGGER.debug("Creating programmatic config loader");
        ProgrammaticDriverConfigLoaderBuilder configBuilder = DriverConfigLoader.programmaticBuilder();
        HashMap<DriverOption, String> allOptions = new HashMap<DriverOption, String>();
        Object ts = this.getProperty(CASSANDRA_SOCKET_CONNECTION_TIMEOUT_MILLIS, "5000") + MILLISECONDS_STR;
        allOptions.put(DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT, (String)ts);
        allOptions.put(DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT, (String)ts);
        allOptions.put(DefaultDriverOption.REQUEST_TIMEOUT, this.getProperty(CASSANDRA_SOCKET_READ_TIMEOUT_MILLIS, DEFAULT_READ_TIMEOUT) + MILLISECONDS_STR);
        CassandraInterpreter.addIfNotBlank(allOptions, this.getProperty(CASSANDRA_SOCKET_TCP_NO_DELAY, DEFAULT_TCP_NO_DELAY), DefaultDriverOption.SOCKET_TCP_NODELAY);
        CassandraInterpreter.addIfNotBlank(allOptions, this.getProperty(CASSANDRA_SOCKET_KEEP_ALIVE), DefaultDriverOption.SOCKET_KEEP_ALIVE);
        CassandraInterpreter.addIfNotBlank(allOptions, this.getProperty(CASSANDRA_SOCKET_RECEIVED_BUFFER_SIZE_BYTES), DefaultDriverOption.SOCKET_RECEIVE_BUFFER_SIZE);
        CassandraInterpreter.addIfNotBlank(allOptions, this.getProperty(CASSANDRA_SOCKET_SEND_BUFFER_SIZE_BYTES), DefaultDriverOption.SOCKET_SEND_BUFFER_SIZE);
        CassandraInterpreter.addIfNotBlank(allOptions, this.getProperty(CASSANDRA_SOCKET_REUSE_ADDRESS), DefaultDriverOption.SOCKET_REUSE_ADDRESS);
        CassandraInterpreter.addIfNotBlank(allOptions, this.getProperty(CASSANDRA_SOCKET_SO_LINGER), DefaultDriverOption.SOCKET_LINGER_INTERVAL);
        CassandraInterpreter.addIfNotBlank(allOptions, this.getProperty(CASSANDRA_QUERY_DEFAULT_IDEMPOTENCE), DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE);
        allOptions.put(DefaultDriverOption.REQUEST_CONSISTENCY, this.getProperty(CASSANDRA_QUERY_DEFAULT_CONSISTENCY, DEFAULT_CONSISTENCY));
        allOptions.put(DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY, this.getProperty(CASSANDRA_QUERY_DEFAULT_SERIAL_CONSISTENCY, DEFAULT_SERIAL_CONSISTENCY));
        allOptions.put(DefaultDriverOption.REQUEST_PAGE_SIZE, this.getProperty(CASSANDRA_QUERY_DEFAULT_FETCH_SIZE, "5000"));
        ts = this.getProperty(CASSANDRA_PROTOCOL_VERSION, "DEFAULT");
        if (!"DEFAULT".equalsIgnoreCase((String)ts)) {
            if (((String)ts).equals("4") || ((String)ts).equals("3")) {
                ts = "V" + (String)ts;
            }
            allOptions.put(DefaultDriverOption.PROTOCOL_VERSION, (String)ts);
        }
        CassandraInterpreter.addIfNotBlank(allOptions, this.getProperty(CASSANDRA_COMPRESSION_PROTOCOL, "none").toLowerCase(), DefaultDriverOption.PROTOCOL_COMPRESSION);
        CassandraInterpreter.addIfNotBlankOrDefault(allOptions, this.getProperty(CASSANDRA_RETRY_POLICY, "DEFAULT"), DefaultDriverOption.RETRY_POLICY_CLASS);
        CassandraInterpreter.addIfNotBlankOrDefault(allOptions, this.getProperty(CASSANDRA_RECONNECTION_POLICY, "DEFAULT"), DefaultDriverOption.RECONNECTION_POLICY_CLASS);
        CassandraInterpreter.addIfNotBlankOrDefault(allOptions, this.getProperty(CASSANDRA_SPECULATIVE_EXECUTION_POLICY, "DEFAULT"), DefaultDriverOption.SPECULATIVE_EXECUTION_POLICY_CLASS);
        allOptions.put(DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE, this.getProperty(CASSANDRA_POOLING_CONNECTION_PER_HOST_LOCAL, DEFAULT_CONNECTIONS_PER_HOST));
        allOptions.put(DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE, this.getProperty(CASSANDRA_POOLING_CONNECTION_PER_HOST_REMOTE, DEFAULT_CONNECTIONS_PER_HOST));
        allOptions.put(DefaultDriverOption.CONNECTION_MAX_REQUESTS, this.getProperty(CASSANDRA_POOLING_MAX_REQUESTS_PER_CONNECTION, DEFAULT_MAX_REQUEST_PER_CONNECTION));
        allOptions.put(DefaultDriverOption.HEARTBEAT_INTERVAL, this.getProperty(CASSANDRA_POOLING_HEARTBEAT_INTERVAL_SECONDS, DEFAULT_HEARTBEAT_INTERVAL) + SECONDS_STR);
        ts = this.getProperty(CASSANDRA_POOLING_POOL_TIMEOUT_MILLIS, "5000") + MILLISECONDS_STR;
        allOptions.put(DefaultDriverOption.HEARTBEAT_TIMEOUT, (String)ts);
        allOptions.put(DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT, (String)ts);
        allOptions.put(DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS, "DcInferringLoadBalancingPolicy");
        allOptions.put(DefaultDriverOption.RESOLVE_CONTACT_POINTS, "false");
        allOptions.put(DefaultDriverOption.CONTROL_CONNECTION_AGREEMENT_TIMEOUT, this.getProperty(CASSANDRA_MAX_SCHEMA_AGREEMENT_WAIT_SECONDS, DEFAULT_MAX_SCHEMA_AGREEMENT_WAIT_SECONDS) + SECONDS_STR);
        for (String string : this.properties.stringPropertyNames()) {
            if (!string.startsWith(DATASTAX_JAVA_DRIVER_PREFIX)) continue;
            String pvalue = this.properties.getProperty(string);
            LOGGER.info("Custom config values: {} = {}", (Object)string, (Object)pvalue);
            String shortName = string.substring(DATASTAX_JAVA_DRIVER_PREFIX.length());
            if (optionMap.containsKey(shortName)) {
                allOptions.put(optionMap.get(shortName), pvalue);
                continue;
            }
            LOGGER.warn("Incorrect option name: {}", (Object)string);
        }
        for (Map.Entry entry : allOptions.entrySet()) {
            configBuilder.withString((DriverOption)entry.getKey(), (String)entry.getValue());
        }
        DriverConfigLoader loader = configBuilder.endProfile().build();
        LOGGER.debug("Config loader is created");
        return loader;
    }

    private static void addIfNotBlank(Map<DriverOption, String> allOptions, String value, DefaultDriverOption option) {
        if (!StringUtils.isBlank(value)) {
            allOptions.put(option, value);
        }
    }

    private static void addIfNotBlankOrDefault(Map<DriverOption, String> allOptions, String value, DefaultDriverOption option) {
        if (!StringUtils.isBlank(value) && !"DEFAULT".equalsIgnoreCase(value)) {
            allOptions.put(option, value);
        }
    }

    public void close() {
        if (this.session != null) {
            this.session.close();
        }
    }

    public InterpreterResult interpret(String st, InterpreterContext context) {
        return this.helper.interpret(this.session, st, context);
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return NO_COMPLETION;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetParallelScheduler(CassandraInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), Integer.parseInt(this.getProperty(CASSANDRA_INTERPRETER_PARALLELISM, DEFAULT_PARALLELISM)));
    }

    static {
        for (DefaultDriverOption opt : DefaultDriverOption.values()) {
            optionMap.put(opt.getPath(), opt);
        }
    }
}

