/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.internal.core.util.Dependency;
import com.datastax.oss.driver.internal.core.util.Reflection;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDependencyChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDependencyChecker.class);
    private static final ConcurrentHashMap<Dependency, Boolean> CACHE = new ConcurrentHashMap();

    public static boolean isPresent(Dependency dependency) {
        try {
            return CACHE.computeIfAbsent(dependency, dep -> {
                for (String classNameToTest : dependency.classes()) {
                    if (Reflection.loadClass(null, classNameToTest) != null) continue;
                    return false;
                }
                return true;
            });
        }
        catch (Exception e) {
            LOG.warn("Unexpected exception when checking for dependency " + (Object)((Object)dependency), e);
            return false;
        }
    }
}

