/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.registry;

import com.datastax.oss.driver.api.core.DriverExecutionException;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.registry.CachingCodecRegistry;
import com.datastax.oss.driver.internal.core.type.codec.registry.CodecRegistryConstants;
import com.datastax.oss.driver.shaded.guava.common.base.Throwables;
import com.datastax.oss.driver.shaded.guava.common.cache.CacheBuilder;
import com.datastax.oss.driver.shaded.guava.common.cache.CacheLoader;
import com.datastax.oss.driver.shaded.guava.common.cache.LoadingCache;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.ExecutionError;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultCodecRegistry
extends CachingCodecRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCodecRegistry.class);
    private final LoadingCache<CacheKey, TypeCodec<?>> cache;

    public DefaultCodecRegistry(@NonNull String logPrefix) {
        this(logPrefix, CodecRegistryConstants.PRIMITIVE_CODECS);
    }

    public DefaultCodecRegistry(@NonNull String logPrefix, TypeCodec<?> ... primitiveCodecs) {
        this(logPrefix, 0, null, 0, null, primitiveCodecs);
    }

    public DefaultCodecRegistry(@NonNull String logPrefix, int initialCacheCapacity, @Nullable BiFunction<CacheKey, TypeCodec<?>, Integer> cacheWeigher, int maximumCacheWeight, @Nullable BiConsumer<CacheKey, TypeCodec<?>> cacheRemovalListener, TypeCodec<?> ... primitiveCodecs) {
        super(logPrefix, primitiveCodecs);
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        if (initialCacheCapacity > 0) {
            cacheBuilder.initialCapacity(initialCacheCapacity);
        }
        if (cacheWeigher != null) {
            cacheBuilder.weigher(cacheWeigher::apply).maximumWeight(maximumCacheWeight);
        }
        CacheLoader cacheLoader = new CacheLoader<CacheKey, TypeCodec<?>>(){

            @Override
            public TypeCodec<?> load(@NonNull CacheKey key) throws Exception {
                return DefaultCodecRegistry.this.createCodec(key.cqlType, key.javaType, key.isJavaCovariant);
            }
        };
        this.cache = cacheRemovalListener != null ? cacheBuilder.removalListener(notification -> cacheRemovalListener.accept((CacheKey)notification.getKey(), (TypeCodec)notification.getValue())).build(cacheLoader) : cacheBuilder.build(cacheLoader);
    }

    @Override
    protected TypeCodec<?> getCachedCodec(@Nullable DataType cqlType, @Nullable GenericType<?> javaType, boolean isJavaCovariant) {
        LOG.trace("[{}] Checking cache", (Object)this.logPrefix);
        try {
            return this.cache.getUnchecked(new CacheKey(cqlType, javaType, isJavaCovariant));
        }
        catch (ExecutionError | UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                Throwables.throwIfUnchecked(cause);
                throw new DriverExecutionException(cause);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public static final class CacheKey {
        public final DataType cqlType;
        public final GenericType<?> javaType;
        public final boolean isJavaCovariant;

        public CacheKey(@Nullable DataType cqlType, @Nullable GenericType<?> javaType, boolean isJavaCovariant) {
            this.javaType = javaType;
            this.cqlType = cqlType;
            this.isJavaCovariant = isJavaCovariant;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof CacheKey) {
                CacheKey that = (CacheKey)other;
                return Objects.equals(this.cqlType, that.cqlType) && Objects.equals(this.javaType, that.javaType) && this.isJavaCovariant == that.isJavaCovariant;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.cqlType, this.javaType, this.isJavaCovariant);
        }
    }
}

