/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.internal.core.metadata.token.CanonicalNodeSetBuilder;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationFactor;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategy;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class NetworkTopologyReplicationStrategy
implements ReplicationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkTopologyReplicationStrategy.class);
    private final Map<String, String> replicationConfig;
    private final Map<String, ReplicationFactor> replicationFactors;
    private final String logPrefix;

    NetworkTopologyReplicationStrategy(Map<String, String> replicationConfig, String logPrefix) {
        this.replicationConfig = replicationConfig;
        ImmutableMap.Builder<String, ReplicationFactor> factorsBuilder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : replicationConfig.entrySet()) {
            if (entry.getKey().equals("class")) continue;
            factorsBuilder.put(entry.getKey(), ReplicationFactor.fromString(entry.getValue()));
        }
        this.replicationFactors = factorsBuilder.build();
        this.logPrefix = logPrefix;
    }

    @Override
    public Map<Token, Set<Node>> computeReplicasByToken(Map<Token, Node> tokenToPrimary, List<Token> ring) {
        ImmutableMap.Builder<Token, Set<Node>> result2 = ImmutableMap.builder();
        Map<String, Set<String>> racks = this.getRacksInDcs(tokenToPrimary.values());
        HashMap<String, Integer> dcNodeCount = Maps.newHashMapWithExpectedSize(this.replicationFactors.size());
        HashSet<String> warnedDcs = Sets.newHashSetWithExpectedSize(this.replicationFactors.size());
        CanonicalNodeSetBuilder replicasBuilder = new CanonicalNodeSetBuilder();
        for (Node node : Sets.newHashSet(tokenToPrimary.values())) {
            String dc = node.getDatacenter();
            dcNodeCount.merge(dc, 1, Integer::sum);
        }
        for (int i = 0; i < ring.size(); ++i) {
            replicasBuilder.clear();
            HashMap<String, Set<Node>> allDcReplicas = new HashMap<String, Set<Node>>();
            HashMap seenRacks = new HashMap();
            HashMap skippedDcEndpoints = new HashMap();
            for (String string : this.replicationFactors.keySet()) {
                allDcReplicas.put(string, new HashSet());
                seenRacks.put(string, new HashSet());
                skippedDcEndpoints.put(string, new LinkedHashSet());
            }
            for (int j = 0; j < ring.size() && !this.allDone(allDcReplicas, dcNodeCount); ++j) {
                Node node = tokenToPrimary.get(NetworkTopologyReplicationStrategy.getTokenWrapping(i + j, ring));
                String dc = node.getDatacenter();
                if (dc == null || !allDcReplicas.containsKey(dc)) continue;
                ReplicationFactor dcConfig = this.replicationFactors.get(dc);
                assert (dcConfig != null);
                int rf = dcConfig.fullReplicas();
                Set dcReplicas = (Set)allDcReplicas.get(dc);
                if (dcReplicas.size() >= rf) continue;
                String rack = node.getRack();
                if (rack == null || ((Set)seenRacks.get(dc)).size() == racks.get(dc).size()) {
                    replicasBuilder.add(node);
                    dcReplicas.add(node);
                    continue;
                }
                if (((Set)seenRacks.get(dc)).contains(rack)) {
                    ((Set)skippedDcEndpoints.get(dc)).add(node);
                    continue;
                }
                replicasBuilder.add(node);
                dcReplicas.add(node);
                ((Set)seenRacks.get(dc)).add(rack);
                if (((Set)seenRacks.get(dc)).size() != racks.get(dc).size()) continue;
                Iterator skippedIt = ((Set)skippedDcEndpoints.get(dc)).iterator();
                while (skippedIt.hasNext() && dcReplicas.size() < rf) {
                    Node nextSkipped = (Node)skippedIt.next();
                    replicasBuilder.add(nextSkipped);
                    dcReplicas.add(nextSkipped);
                }
            }
            for (Map.Entry entry : allDcReplicas.entrySet()) {
                String dcName = (String)entry.getKey();
                int expectedFactor = this.replicationFactors.get(dcName).fullReplicas();
                int achievedFactor = ((Set)entry.getValue()).size();
                if (achievedFactor >= expectedFactor || warnedDcs.contains(dcName)) continue;
                LOG.warn("[{}] Error while computing token map for replication settings {}: could not achieve replication factor {} for datacenter {} (found only {} replicas).", this.logPrefix, this.replicationConfig, expectedFactor, dcName, achievedFactor);
                warnedDcs.add(dcName);
            }
            result2.put(ring.get(i), replicasBuilder.build());
        }
        return result2.build();
    }

    private boolean allDone(Map<String, Set<Node>> map, Map<String, Integer> dcNodeCount) {
        for (Map.Entry<String, Set<Node>> entry : map.entrySet()) {
            int dcCount;
            String dc = entry.getKey();
            int n = dcCount = dcNodeCount.get(dc) == null ? 0 : dcNodeCount.get(dc);
            if (entry.getValue().size() >= Math.min(this.replicationFactors.get(dc).fullReplicas(), dcCount)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Set<String>> getRacksInDcs(Iterable<Node> nodes) {
        HashMap<String, Set<String>> result2 = new HashMap<String, Set<String>>();
        for (Node node : nodes) {
            Set racks = result2.computeIfAbsent(node.getDatacenter(), k -> new HashSet());
            racks.add(node.getRack());
        }
        return result2;
    }

    private static Token getTokenWrapping(int i, List<Token> ring) {
        return ring.get(i % ring.size());
    }
}

