/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSortedSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.BiFunction;

public class DerivedExecutionProfile
implements DriverExecutionProfile {
    private static final Object NO_VALUE = new Object();
    private final DriverExecutionProfile baseProfile;
    private final Map<DriverOption, Object> overrides;

    public static DerivedExecutionProfile with(DriverExecutionProfile baseProfile, DriverOption option, Object value) {
        if (baseProfile instanceof DerivedExecutionProfile) {
            DerivedExecutionProfile previousDerived = (DerivedExecutionProfile)baseProfile;
            ImmutableMap.Builder<DriverOption, Object> newOverrides = ImmutableMap.builder();
            for (Map.Entry<DriverOption, Object> override : previousDerived.overrides.entrySet()) {
                if (override.getKey().equals(option)) continue;
                newOverrides.put(override.getKey(), override.getValue());
            }
            newOverrides.put(option, value);
            return new DerivedExecutionProfile(previousDerived.baseProfile, newOverrides.build());
        }
        return new DerivedExecutionProfile(baseProfile, ImmutableMap.of(option, value));
    }

    public static DerivedExecutionProfile without(DriverExecutionProfile baseProfile, DriverOption option) {
        return DerivedExecutionProfile.with(baseProfile, option, NO_VALUE);
    }

    public DerivedExecutionProfile(DriverExecutionProfile baseProfile, Map<DriverOption, Object> overrides) {
        this.baseProfile = baseProfile;
        this.overrides = overrides;
    }

    @Override
    @NonNull
    public String getName() {
        return this.baseProfile.getName();
    }

    @Override
    public boolean isDefined(@NonNull DriverOption option) {
        if (this.overrides.containsKey(option)) {
            return this.overrides.get(option) != NO_VALUE;
        }
        return this.baseProfile.isDefined(option);
    }

    @Override
    public boolean getBoolean(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getBoolean);
    }

    @Override
    @NonNull
    public List<Boolean> getBooleanList(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getBooleanList);
    }

    @Override
    public int getInt(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getInt);
    }

    @Override
    @NonNull
    public List<Integer> getIntList(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getIntList);
    }

    @Override
    public long getLong(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getLong);
    }

    @Override
    @NonNull
    public List<Long> getLongList(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getLongList);
    }

    @Override
    public double getDouble(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getDouble);
    }

    @Override
    @NonNull
    public List<Double> getDoubleList(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getDoubleList);
    }

    @Override
    @NonNull
    public String getString(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getString);
    }

    @Override
    @NonNull
    public List<String> getStringList(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getStringList);
    }

    @Override
    @NonNull
    public Map<String, String> getStringMap(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getStringMap);
    }

    @Override
    public long getBytes(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getBytes);
    }

    @Override
    @NonNull
    public List<Long> getBytesList(DriverOption option) {
        return this.get(option, DriverExecutionProfile::getBytesList);
    }

    @Override
    @NonNull
    public Duration getDuration(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getDuration);
    }

    @Override
    @NonNull
    public List<Duration> getDurationList(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getDurationList);
    }

    @NonNull
    private <ValueT> ValueT get(@NonNull DriverOption option, BiFunction<DriverExecutionProfile, DriverOption, ValueT> getter2) {
        Object value = this.overrides.get(option);
        if (value == null) {
            value = getter2.apply(this.baseProfile, option);
        }
        if (value == null || value == NO_VALUE) {
            throw new IllegalArgumentException("Missing configuration option " + option.getPath());
        }
        return (ValueT)value;
    }

    @Override
    @NonNull
    public SortedSet<Map.Entry<String, Object>> entrySet() {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(Map.Entry.comparingByKey());
        for (Map.Entry<DriverOption, Object> entry : this.overrides.entrySet()) {
            if (entry.getValue() == NO_VALUE) continue;
            builder.add(new AbstractMap.SimpleEntry<String, Object>(entry.getKey().getPath(), entry.getValue()));
        }
        builder.addAll(this.baseProfile.entrySet());
        return builder.build();
    }
}

