/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.types.StructType;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.ResultMessages;
import org.apache.zeppelin.interpreter.SingleRowInterpreterResult;
import org.apache.zeppelin.tabledata.TableDataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkUtils {
    private static final String HADOOP_VERSION_2_6_6 = "2.6.6";
    private static final String HADOOP_VERSION_2_7_0 = "2.7.0";
    private static final String HADOOP_VERSION_2_7_4 = "2.7.4";
    private static final String HADOOP_VERSION_2_8_0 = "2.8.0";
    private static final String HADOOP_VERSION_2_8_2 = "2.8.2";
    private static final String HADOOP_VERSION_2_9_0 = "2.9.0";
    private static final String HADOOP_VERSION_3_0_0 = "3.0.0";
    private static final String HADOOP_VERSION_3_0_0_ALPHA4 = "3.0.0-alpha4";
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkUtils.class);
    protected SparkSession sparkSession;
    protected Properties properties;

    public SparkUtils(Properties properties, SparkSession sparkSession) {
        this.properties = properties;
        this.sparkSession = sparkSession;
    }

    public void setupSparkListener(final String master, final String sparkWebUrl, final InterpreterContext context) {
        final SparkContext sc = SparkContext.getOrCreate();
        sc.addSparkListener((SparkListenerInterface)new SparkListener(){

            public void onJobStart(SparkListenerJobStart jobStart) {
                if (sc.getConf().getBoolean("spark.ui.enabled", true) && !Boolean.parseBoolean(SparkUtils.this.properties.getProperty("zeppelin.spark.ui.hidden", "false"))) {
                    SparkUtils.this.buildSparkJobUrl(master, sparkWebUrl, jobStart.jobId(), jobStart.properties(), context);
                }
            }
        });
    }

    public String showDataFrame(Object obj, int maxResult, InterpreterContext context) {
        if (obj instanceof Dataset) {
            boolean isLargerThanMaxResult;
            Dataset df = ((Dataset)obj).toDF();
            Object[] columns = df.columns();
            if (columns.length == 0) {
                return "";
            }
            List rows = df.takeAsList(maxResult + 1);
            String template = (String)context.getLocalProperties().get("template");
            if (!StringUtils.isBlank(template)) {
                if (rows.size() >= 1) {
                    return new SingleRowInterpreterResult(this.sparkRowToList((Row)rows.get(0)), template, context).toHtml();
                }
                return "";
            }
            StringBuilder msg = new StringBuilder();
            msg.append("%table ");
            msg.append(StringUtils.join(TableDataUtils.normalizeColumns((Object[])columns), "\t"));
            msg.append("\n");
            boolean bl = isLargerThanMaxResult = rows.size() > maxResult;
            if (isLargerThanMaxResult) {
                rows = rows.subList(0, maxResult);
            }
            for (Row row : rows) {
                for (int i = 0; i < row.size(); ++i) {
                    msg.append(TableDataUtils.normalizeColumn((Object)row.get(i)));
                    if (i == row.size() - 1) continue;
                    msg.append("\t");
                }
                msg.append("\n");
            }
            if (isLargerThanMaxResult) {
                msg.append("\n");
                msg.append(ResultMessages.getExceedsLimitRowsMessage((int)maxResult, (String)"zeppelin.spark.maxResult"));
            }
            msg.append("\n%text ");
            return msg.toString();
        }
        return obj.toString();
    }

    private List sparkRowToList(Row row) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < row.size(); ++i) {
            list.add(row.get(i));
        }
        return list;
    }

    public Dataset<Row> getAsDataFrame(String value) {
        String[] lines = value.split("\\n");
        String head = lines[0];
        String[] columns = head.split("\t");
        StructType schema = new StructType();
        for (String column : columns) {
            schema = schema.add(column, "String");
        }
        ArrayList<GenericRow> rows = new ArrayList<GenericRow>();
        for (int i = 1; i < lines.length; ++i) {
            Object[] tokens = lines[i].split("\t");
            GenericRow row = new GenericRow(tokens);
            rows.add(row);
        }
        return this.sparkSession.createDataFrame(rows, schema);
    }

    protected void buildSparkJobUrl(String master, String sparkWebUrl, int jobId, Properties jobProperties, InterpreterContext context) {
        Object jobUrl = null;
        if (sparkWebUrl.contains("{jobId}")) {
            jobUrl = sparkWebUrl.replace("{jobId}", "" + jobId);
        } else {
            jobUrl = sparkWebUrl + "/jobs/job?id=" + jobId;
            String version = VersionInfo.getVersion();
            if (master.toLowerCase().contains("yarn") && !SparkUtils.supportYarn6615(version)) {
                jobUrl = sparkWebUrl + "/jobs";
            }
        }
        String jobGroupId = jobProperties.getProperty("spark.jobGroup.id");
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("jobUrl", jobUrl);
        infos.put("label", "SPARK JOB");
        infos.put("tooltip", "View in Spark web UI");
        infos.put("noteId", SparkUtils.getNoteId(jobGroupId));
        infos.put("paraId", SparkUtils.getParagraphId(jobGroupId));
        LOGGER.debug("Send spark job url: {}", (Object)infos);
        context.getIntpEventClient().onParaInfosReceived(infos);
    }

    public static String getNoteId(String jobGroupId) {
        String[] tokens = jobGroupId.split("\\|");
        if (tokens.length != 4) {
            throw new RuntimeException("Invalid jobGroupId: " + jobGroupId);
        }
        return tokens[2];
    }

    public static String getParagraphId(String jobGroupId) {
        String[] tokens = jobGroupId.split("\\|");
        if (tokens.length != 4) {
            throw new RuntimeException("Invalid jobGroupId: " + jobGroupId);
        }
        return tokens[3];
    }

    protected static boolean supportYarn6615(String version) {
        return VersionUtil.compareVersions((String)HADOOP_VERSION_2_6_6, (String)version) <= 0 && VersionUtil.compareVersions((String)HADOOP_VERSION_2_7_0, (String)version) > 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_2_7_4, (String)version) <= 0 && VersionUtil.compareVersions((String)HADOOP_VERSION_2_8_0, (String)version) > 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_2_8_2, (String)version) <= 0 && VersionUtil.compareVersions((String)HADOOP_VERSION_2_9_0, (String)version) > 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_2_9_0, (String)version) <= 0 && VersionUtil.compareVersions((String)HADOOP_VERSION_3_0_0, (String)version) > 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_3_0_0_ALPHA4, (String)version) <= 0 || VersionUtil.compareVersions((String)HADOOP_VERSION_3_0_0, (String)version) <= 0;
    }
}

