/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.util.Arrays;
import java.util.Properties;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.r.RInterpreter;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.spark.SparkInterpreter;
import org.apache.zeppelin.spark.SparkVersion;
import org.apache.zeppelin.spark.Utils;
import org.apache.zeppelin.spark.ZeppelinRContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkRInterpreter
extends RInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkRInterpreter.class);
    private SparkInterpreter sparkInterpreter;
    private SparkVersion sparkVersion;
    private SparkContext sc;
    private JavaSparkContext jsc;

    public SparkRInterpreter(Properties property) {
        super(property);
    }

    @Override
    protected boolean isSparkSupported() {
        return true;
    }

    @Override
    protected int sparkVersion() {
        return new SparkVersion(this.sc.version()).toNumber();
    }

    @Override
    public void open() throws InterpreterException {
        this.sparkInterpreter = (SparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class));
        this.sc = this.sparkInterpreter.getSparkContext();
        this.jsc = this.sparkInterpreter.getJavaSparkContext();
        this.sparkVersion = new SparkVersion(this.sc.version());
        LOGGER.info("SparkRInterpreter: SPARK_HOME={}", (Object)this.sc.getConf().getenv("SPARK_HOME"));
        Arrays.stream(this.sc.getConf().getAll()).forEach(x -> LOGGER.info("SparkRInterpreter: conf, {}={}", x._1, x._2));
        this.properties.entrySet().stream().forEach(x -> LOGGER.info("SparkRInterpreter: prop, {}={}", x.getKey(), x.getValue()));
        ZeppelinRContext.setSparkContext(this.sc);
        ZeppelinRContext.setJavaSparkContext(this.jsc);
        ZeppelinRContext.setSparkSession(this.sparkInterpreter.getSparkSession());
        ZeppelinRContext.setSqlContext(this.sparkInterpreter.getSQLContext());
        ZeppelinRContext.setZeppelinContext(this.sparkInterpreter.getZeppelinContext());
        super.open();
    }

    @Override
    public InterpreterResult internalInterpret(String lines, InterpreterContext interpreterContext) throws InterpreterException {
        Utils.printDeprecateMessage(this.sparkInterpreter.getSparkVersion(), interpreterContext, this.properties);
        String jobGroup = Utils.buildJobGroupId(interpreterContext);
        String jobDesc = Utils.buildJobDesc(interpreterContext);
        this.sparkInterpreter.getSparkContext().setJobGroup(jobGroup, jobDesc, false);
        Object setJobGroup = "";
        setJobGroup = "dummy__ <- setJobGroup(\"" + jobGroup + "\", \" +" + jobDesc + "\", TRUE)";
        lines = (String)setJobGroup + "\n" + (String)lines;
        Object setPoolStmt = "setLocalProperty('spark.scheduler.pool', NULL)";
        if (interpreterContext.getLocalProperties().containsKey("pool")) {
            setPoolStmt = "setLocalProperty('spark.scheduler.pool', '" + (String)interpreterContext.getLocalProperties().get("pool") + "')";
        }
        lines = (String)setPoolStmt + "\n" + (String)lines;
        return super.internalInterpret((String)lines, interpreterContext);
    }

    @Override
    public void close() throws InterpreterException {
        super.close();
    }

    @Override
    public void cancel(InterpreterContext context) {
        if (this.sc != null) {
            this.sc.cancelJobGroup(Utils.buildJobGroupId(context));
        }
    }

    @Override
    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    @Override
    public int getProgress(InterpreterContext context) throws InterpreterException {
        if (this.sparkInterpreter != null) {
            return this.sparkInterpreter.getProgress(context);
        }
        return 0;
    }

    @Override
    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(SparkRInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }

    @Override
    public ZeppelinContext getZeppelinContext() {
        return this.sparkInterpreter.getZeppelinContext();
    }
}

