/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.apache.zeppelin.spark.PySparkInterpreter;
import org.apache.zeppelin.spark.PythonUtils;
import org.apache.zeppelin.spark.SparkInterpreter;
import org.apache.zeppelin.spark.SparkVersion;
import org.apache.zeppelin.spark.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPySparkInterpreter
extends IPythonInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPySparkInterpreter.class);
    private SparkInterpreter sparkInterpreter;
    private boolean opened = false;
    private InterpreterContext curIntpContext;

    public IPySparkInterpreter(Properties property) {
        super(property);
    }

    @Override
    public synchronized void open() throws InterpreterException {
        if (this.opened) {
            return;
        }
        this.sparkInterpreter = (SparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class));
        PySparkInterpreter pySparkInterpreter = (PySparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(PySparkInterpreter.class, false));
        this.setProperty("zeppelin.python", pySparkInterpreter.getPythonExec(this.sparkInterpreter.getSparkContext().conf()));
        SparkConf conf = this.sparkInterpreter.getSparkContext().getConf();
        if (!conf.contains("spark.submit.deployMode") || !conf.get("spark.submit.deployMode").equals("cluster")) {
            this.setAdditionalPythonPath(PythonUtils.sparkPythonPath());
        }
        this.setUseBuiltinPy4j(false);
        this.setAdditionalPythonInitFile("python/zeppelin_ipyspark.py");
        super.open();
        this.opened = true;
    }

    @Override
    protected Map<String, String> setupKernelEnv() throws IOException {
        Map<String, String> env = super.setupKernelEnv();
        SparkConf conf = this.sparkInterpreter.getSparkContext().getConf();
        if (conf.contains("spark.pyspark.python")) {
            env.put("PYSPARK_PYTHON", conf.get("spark.pyspark.python"));
        }
        return env;
    }

    @Override
    public ZeppelinContext buildZeppelinContext() {
        return this.sparkInterpreter.getZeppelinContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        PrintStream originalStdout = System.out;
        PrintStream originalStderr = System.err;
        try {
            String setPoolStmt;
            System.setOut(new PrintStream((OutputStream)context.out));
            System.setErr(new PrintStream((OutputStream)context.out));
            Utils.printDeprecateMessage(this.sparkInterpreter.getSparkVersion(), context, this.properties);
            InterpreterContext.set((InterpreterContext)context);
            String jobGroupId = Utils.buildJobGroupId(context);
            String jobDesc = Utils.buildJobDesc(context);
            String setJobGroupStmt = "sc.setJobGroup('" + jobGroupId + "', '" + jobDesc + "')";
            InterpreterResult result = super.interpret(setJobGroupStmt, context);
            if (result.code().equals((Object)InterpreterResult.Code.ERROR)) {
                InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, "Fail to setJobGroup");
                return interpreterResult;
            }
            Object pool = "None";
            if (context.getLocalProperties().containsKey("pool")) {
                pool = "'" + (String)context.getLocalProperties().get("pool") + "'";
            }
            if ((result = super.interpret(setPoolStmt = "sc.setLocalProperty('spark.scheduler.pool', " + (String)pool + ")", context)).code().equals((Object)InterpreterResult.Code.ERROR)) {
                InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, "Fail to setPool");
                return interpreterResult;
            }
            this.curIntpContext = context;
            String setInptContextStmt = "intp.setInterpreterContextInPython()";
            result = super.interpret(setInptContextStmt, context);
            if (result.code().equals((Object)InterpreterResult.Code.ERROR)) {
                InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, "Fail to setCurIntpContext");
                return interpreterResult;
            }
            InterpreterResult interpreterResult = super.interpret(st, context);
            return interpreterResult;
        }
        finally {
            System.setOut(originalStdout);
            System.setErr(originalStderr);
        }
    }

    public void setInterpreterContextInPython() {
        InterpreterContext.set((InterpreterContext)this.curIntpContext);
    }

    @Override
    public void cancel(InterpreterContext context) throws InterpreterException {
        super.cancel(context);
        this.sparkInterpreter.cancel(context);
    }

    @Override
    public void close() throws InterpreterException {
        LOGGER.info("Close IPySparkInterpreter");
        super.close();
    }

    @Override
    public int getProgress(InterpreterContext context) throws InterpreterException {
        return this.sparkInterpreter.getProgress(context);
    }

    public boolean isSpark3() {
        return this.sparkInterpreter.getSparkVersion().getMajorVersion() == 3;
    }

    public boolean isAfterSpark33() {
        return this.sparkInterpreter.getSparkVersion().newerThanEquals(SparkVersion.SPARK_3_3_0);
    }

    public JavaSparkContext getJavaSparkContext() {
        return this.sparkInterpreter.getJavaSparkContext();
    }

    public Object getSQLContext() {
        return this.sparkInterpreter.getSQLContext();
    }

    public Object getSparkSession() {
        return this.sparkInterpreter.getSparkSession();
    }
}

