/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.zeppelin.com.google.common.collect.Lists;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.spark.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSparkScalaInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSparkScalaInterpreter.class);
    private static final AtomicInteger SESSION_NUM = new AtomicInteger(0);
    protected SparkConf conf;
    protected SparkContext sc;
    protected SparkSession sparkSession;
    protected SQLContext sqlContext;
    protected String sparkUrl;
    protected ZeppelinContext z;
    protected Properties properties;
    protected List<String> depFiles;

    public AbstractSparkScalaInterpreter(SparkConf conf, Properties properties, List<String> depFiles) {
        this.conf = conf;
        this.properties = properties;
        this.depFiles = depFiles;
    }

    public SparkContext getSparkContext() {
        return this.sc;
    }

    public SQLContext getSqlContext() {
        return this.sqlContext;
    }

    public SparkSession getSparkSession() {
        return this.sparkSession;
    }

    public String getSparkUrl() {
        return this.sparkUrl;
    }

    public ZeppelinContext getZeppelinContext() {
        return this.z;
    }

    public AbstractSparkScalaInterpreter() {
    }

    public void open() throws InterpreterException {
        System.setProperty("scala.repl.name.line", ("$line" + this.hashCode()).replace('-', '0'));
        SESSION_NUM.incrementAndGet();
        this.createSparkILoop();
        this.createSparkContext();
        this.createZeppelinContext();
    }

    public void close() throws InterpreterException {
        if (this.getSparkMaster().startsWith("yarn")) {
            YarnConfiguration hadoopConf = new YarnConfiguration();
            Path appStagingBaseDir = null;
            if (this.conf.contains("spark.yarn.stagingDir")) {
                appStagingBaseDir = new Path(this.conf.get("spark.yarn.stagingDir"));
            } else {
                try {
                    appStagingBaseDir = FileSystem.get((Configuration)hadoopConf).getHomeDirectory();
                }
                catch (IOException e) {
                    LOGGER.error("Fail to get stagingBaseDir", e);
                }
            }
            if (appStagingBaseDir != null) {
                Path stagingDirPath = new Path(appStagingBaseDir, ".sparkStaging/" + this.sc.applicationId());
                this.cleanupStagingDirInternal(stagingDirPath, (Configuration)hadoopConf);
            }
        }
        if (this.sc != null) {
            this.sc.stop();
            this.sc = null;
        }
        if (this.sparkSession != null) {
            this.sparkSession.stop();
            this.sparkSession = null;
        }
        this.sqlContext = null;
        this.z = null;
    }

    public abstract void createSparkILoop() throws InterpreterException;

    public abstract void createZeppelinContext() throws InterpreterException;

    public void cancel(InterpreterContext context) throws InterpreterException {
        this.getSparkContext().cancelJobGroup(Utils.buildJobGroupId(context));
    }

    public abstract InterpreterResult interpret(String var1, InterpreterContext var2) throws InterpreterException;

    public abstract List<InterpreterCompletion> completion(String var1, int var2, InterpreterContext var3) throws InterpreterException;

    public abstract void bind(String var1, String var2, Object var3, List<String> var4);

    public abstract void scalaInterpretQuietly(String var1) throws InterpreterException;

    public abstract ClassLoader getScalaShellClassLoader();

    private List<String> getUserFiles() {
        return this.depFiles.stream().filter(f -> f.endsWith(".jar")).collect(Collectors.toList());
    }

    private void createSparkContext() throws InterpreterException {
        SparkSession.Builder builder = SparkSession.builder().config(this.conf);
        if (this.conf.get("spark.sql.catalogImplementation", "in-memory").equalsIgnoreCase("hive") || this.conf.get("zeppelin.spark.useHiveContext", "false").equalsIgnoreCase("true")) {
            boolean hiveSiteExisted;
            boolean bl = hiveSiteExisted = Thread.currentThread().getContextClassLoader().getResource("hive-site.xml") != null;
            if (hiveSiteExisted && this.hiveClassesArePresent()) {
                this.sparkSession = builder.enableHiveSupport().getOrCreate();
                LOGGER.info("Created Spark session (with Hive support)");
            } else {
                if (!this.hiveClassesArePresent()) {
                    LOGGER.warn("Hive support can not be enabled because spark is not built with hive");
                }
                if (!hiveSiteExisted) {
                    LOGGER.warn("Hive support can not be enabled because no hive-site.xml found");
                }
                this.sparkSession = builder.getOrCreate();
                LOGGER.info("Created Spark session (without Hive support)");
            }
        } else {
            this.sparkSession = builder.getOrCreate();
            LOGGER.info("Created Spark session (without Hive support)");
        }
        this.sc = this.sparkSession.sparkContext();
        this.getUserFiles().forEach(file -> this.sc.addFile(file));
        if (this.sc.uiWebUrl().isDefined()) {
            this.sparkUrl = (String)this.sc.uiWebUrl().get();
        }
        this.sqlContext = this.sparkSession.sqlContext();
        this.initAndSendSparkWebUrl();
        this.bind("spark", this.sparkSession.getClass().getCanonicalName(), this.sparkSession, Lists.newArrayList("@transient"));
        this.bind("sc", "org.apache.spark.SparkContext", this.sc, Lists.newArrayList("@transient"));
        this.bind("sqlContext", "org.apache.spark.sql.SQLContext", this.sqlContext, Lists.newArrayList("@transient"));
        this.scalaInterpretQuietly("import org.apache.spark.SparkContext._");
        this.scalaInterpretQuietly("import spark.implicits._");
        this.scalaInterpretQuietly("import sqlContext.implicits._");
        this.scalaInterpretQuietly("import spark.sql");
        this.scalaInterpretQuietly("import org.apache.spark.sql.functions._");
        this.scalaInterpretQuietly("print(\"\")");
    }

    private boolean hiveClassesArePresent() {
        try {
            Class.forName("org.apache.spark.sql.hive.HiveSessionStateBuilder");
            Class.forName("org.apache.hadoop.hive.conf.HiveConf");
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    private void initAndSendSparkWebUrl() {
        String webUiUrl = this.properties.getProperty("zeppelin.spark.uiWebUrl");
        if (!StringUtils.isBlank(webUiUrl)) {
            this.sparkUrl = webUiUrl.replace("{{applicationId}}", this.sc.applicationId());
        } else {
            this.useYarnProxyURLIfNeeded();
        }
        InterpreterContext.get().getIntpEventClient().sendWebUrlInfo(this.sparkUrl);
    }

    private String getSparkMaster() {
        if (this.conf == null) {
            return "";
        }
        return this.conf.get("spark.master", "local[*]");
    }

    private void cleanupStagingDirInternal(Path stagingDirPath, Configuration hadoopConf) {
        try {
            FileSystem fs = stagingDirPath.getFileSystem(hadoopConf);
            if (fs.delete(stagingDirPath, true)) {
                LOGGER.info("Deleted staging directory " + stagingDirPath);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to cleanup staging dir " + stagingDirPath, e);
        }
    }

    private void useYarnProxyURLIfNeeded() {
        if (Boolean.parseBoolean(this.properties.getProperty("spark.webui.yarn.useProxy", "false")) && this.getSparkMaster().startsWith("yarn")) {
            String appId = this.sc.applicationId();
            YarnClient yarnClient = YarnClient.createYarnClient();
            YarnConfiguration yarnConf = new YarnConfiguration();
            yarnConf.set("yarn.timeline-service.enabled", "false");
            yarnClient.init((Configuration)yarnConf);
            yarnClient.start();
            ApplicationReport appReport = null;
            try {
                appReport = yarnClient.getApplicationReport(ConverterUtils.toApplicationId((String)appId));
                this.sparkUrl = appReport.getTrackingUrl();
            }
            catch (IOException | YarnException e) {
                LOGGER.error("Fail to get yarn app report", e);
            }
        }
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        String jobGroup = Utils.buildJobGroupId(context);
        Optional<SparkJobInfo> jobInfoOptional = Arrays.stream(this.sc.statusTracker().getJobIdsForGroup(jobGroup)).mapToObj(jobId -> this.sc.statusTracker().getJobInfo(jobId)).filter(jobInfo -> jobInfo.isDefined()).map(jobInfo -> (SparkJobInfo)jobInfo.get()).findFirst();
        if (jobInfoOptional.isPresent()) {
            List stageInfoList = Arrays.stream(jobInfoOptional.get().stageIds()).mapToObj(stageId -> this.sc.statusTracker().getStageInfo(stageId)).filter(stageInfo -> stageInfo.isDefined()).map(stageInfo -> (SparkStageInfo)stageInfo.get()).collect(Collectors.toList());
            int taskCount = stageInfoList.stream().map(stageInfo -> stageInfo.numTasks()).collect(Collectors.summingInt(Integer::intValue));
            int completedTaskCount = stageInfoList.stream().map(stageInfo -> stageInfo.numCompletedTasks()).collect(Collectors.summingInt(Integer::intValue));
            LOGGER.debug("Total TaskCount: " + taskCount);
            LOGGER.debug("Completed TaskCount: " + completedTaskCount);
            if (taskCount == 0) {
                return 0;
            }
            return 100 * completedTaskCount / taskCount;
        }
        return 0;
    }
}

