/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.StandardInterpreterLauncher;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkInterpreterLauncher
extends StandardInterpreterLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlinkInterpreterLauncher.class);
    private static final Set<String> FLINK_EXECUTION_MODES = Sets.newHashSet((Object[])new String[]{"local", "remote", "yarn", "yarn-application", "kubernetes-application"});

    public FlinkInterpreterLauncher(ZeppelinConfiguration zConf, RecoveryStorage recoveryStorage) {
        super(zConf, recoveryStorage);
    }

    public Map<String, String> buildEnvFromProperties(InterpreterLaunchContext context) throws IOException {
        String flinkAppJar;
        Map envs = super.buildEnvFromProperties(context);
        String flinkHome = this.getFlinkHome(context);
        if (!envs.containsKey("FLINK_CONF_DIR")) {
            envs.put("FLINK_CONF_DIR", flinkHome + "/conf");
        }
        envs.put("FLINK_LIB_DIR", flinkHome + "/lib");
        envs.put("FLINK_PLUGINS_DIR", flinkHome + "/plugins");
        this.normalizeConfiguration(context);
        String flinkExecutionMode = context.getProperties().getProperty("flink.execution.mode");
        if (!FLINK_EXECUTION_MODES.contains(flinkExecutionMode)) {
            throw new IOException("Not valid flink.execution.mode: " + flinkExecutionMode + ", valid modes ares: " + FLINK_EXECUTION_MODES.stream().collect(Collectors.joining(", ")));
        }
        if (this.isApplicationMode(flinkExecutionMode)) {
            this.updateEnvsForApplicationMode(flinkExecutionMode, envs, context);
        }
        if (this.isK8sApplicationMode(flinkExecutionMode)) {
            flinkAppJar = context.getProperties().getProperty("flink.app.jar");
            if (StringUtils.isBlank((CharSequence)flinkAppJar)) {
                throw new IOException("flink.app.jar is not specified for kubernetes-application mode");
            }
            envs.put("FLINK_APP_JAR", flinkAppJar);
            LOGGER.info("K8s application's FLINK_APP_JAR : {}", (Object)flinkAppJar);
            context.getProperties().put("zeppelin.interpreter.forceShutdown", "false");
        } else {
            flinkAppJar = this.chooseFlinkAppJar(flinkHome);
            LOGGER.info("Choose FLINK_APP_JAR for non k8s-application mode: {}", (Object)flinkAppJar);
            envs.put("FLINK_APP_JAR", flinkAppJar);
        }
        if ("yarn".equalsIgnoreCase(flinkExecutionMode) || "yarn-application".equalsIgnoreCase(flinkExecutionMode)) {
            boolean runAsLoginUser = Boolean.parseBoolean(context.getProperties().getProperty("zeppelin.flink.run.asLoginUser", "true"));
            String userName = context.getUserName();
            if (runAsLoginUser && !"anonymous".equals(userName)) {
                envs.put("HADOOP_USER_NAME", userName);
            }
        }
        return envs;
    }

    private void normalizeConfiguration(InterpreterLaunchContext context) {
        Properties intpProperties = context.getProperties();
        this.setNewProperty(intpProperties, "flink.jm.memory", "jobmanager.memory.process.size", true);
        this.setNewProperty(intpProperties, "flink.tm.memory", "taskmanager.memory.process.size", true);
        this.setNewProperty(intpProperties, "flink.tm.slot", "taskmanager.numberOfTaskSlots", false);
        this.setNewProperty(intpProperties, "flink.yarn.appName", "yarn.application.name", false);
        this.setNewProperty(intpProperties, "flink.yarn.queue", "yarn.application.queue", false);
    }

    private void setNewProperty(Properties properties, String oldKey, String newKey, boolean isMemoryProperty) {
        String value = properties.getProperty(oldKey);
        if (StringUtils.isNotBlank((CharSequence)value) && !properties.containsKey(newKey)) {
            if (isMemoryProperty) {
                properties.put(newKey, value + "mb");
            } else {
                properties.put(newKey, value);
            }
        }
    }

    private String chooseFlinkAppJar(String flinkHome) throws IOException {
        File flinkLibFolder = new File(flinkHome, "lib");
        List flinkDistFiles = Arrays.stream(flinkLibFolder.listFiles(file -> file.getName().contains("flink-dist"))).collect(Collectors.toList());
        if (flinkDistFiles.size() > 1) {
            throw new IOException("More than 1 flink-dist files: " + flinkDistFiles.stream().map(file -> file.getAbsolutePath()).collect(Collectors.joining(",")));
        }
        if (flinkDistFiles.isEmpty()) {
            throw new IOException(String.format("No flink-dist jar found under {0}", flinkHome + "/lib"));
        }
        String scalaVersion = "2.12";
        if (((File)flinkDistFiles.get(0)).getName().contains("2.11")) {
            scalaVersion = "2.11";
        }
        String flinkScalaVersion = scalaVersion;
        File flinkInterpreterFolder = new File(this.zConf.getInterpreterDir(), "flink");
        List flinkScalaJars = Arrays.stream(flinkInterpreterFolder.listFiles(file -> file.getName().endsWith(".jar"))).filter(file -> file.getName().contains(flinkScalaVersion)).collect(Collectors.toList());
        if (flinkScalaJars.isEmpty()) {
            throw new IOException("No flink scala jar file is found");
        }
        if (flinkScalaJars.size() > 1) {
            throw new IOException("More than 1 flink scala jar files: " + flinkScalaJars.stream().map(file -> file.getAbsolutePath()).collect(Collectors.joining(",")));
        }
        return ((File)flinkScalaJars.get(0)).getAbsolutePath();
    }

    private boolean isApplicationMode(String mode) {
        return this.isYarnApplicationMode(mode) || this.isK8sApplicationMode(mode);
    }

    private boolean isYarnApplicationMode(String mode) {
        return "yarn-application".equals(mode);
    }

    private boolean isK8sApplicationMode(String mode) {
        return "kubernetes-application".equals(mode);
    }

    private String getFlinkHome(InterpreterLaunchContext context) throws IOException {
        String flinkHome = context.getProperties().getProperty("FLINK_HOME");
        if (StringUtils.isBlank((CharSequence)flinkHome)) {
            flinkHome = System.getenv("FLINK_HOME");
        }
        if (StringUtils.isBlank((CharSequence)flinkHome)) {
            throw new IOException("FLINK_HOME is not specified");
        }
        File flinkHomeFile = new File(flinkHome);
        if (!flinkHomeFile.exists()) {
            throw new IOException(String.format("FLINK_HOME '%s' doesn't exist", flinkHome));
        }
        if (!flinkHomeFile.isDirectory()) {
            throw new IOException(String.format("FLINK_HOME '%s' is a file, but should be directory", flinkHome));
        }
        return flinkHome;
    }

    private void updateEnvsForApplicationMode(String mode, Map<String, String> envs, InterpreterLaunchContext context) throws IOException {
        String yarnAppName;
        envs.put("ZEPPELIN_FLINK_APPLICATION_MODE", mode);
        StringJoiner flinkConfStringJoiner = new StringJoiner("|");
        List<String> yarnShipFiles = this.getYarnShipFiles(context);
        if (!yarnShipFiles.isEmpty()) {
            flinkConfStringJoiner.add("-D");
            flinkConfStringJoiner.add("yarn.ship-files=" + yarnShipFiles.stream().collect(Collectors.joining(";")));
        }
        if (StringUtils.isNotBlank((CharSequence)(yarnAppName = context.getProperties().getProperty("flink.yarn.appName")))) {
            flinkConfStringJoiner.add("-D");
            flinkConfStringJoiner.add("yarn.application.name=" + yarnAppName);
        }
        for (Map.Entry<Object, Object> entry : context.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key.equalsIgnoreCase("yarn.ship-files") || key.equalsIgnoreCase("flink.yarn.appName")) continue;
            if (CharMatcher.whitespace().matchesAnyOf((CharSequence)value)) {
                LOGGER.warn("flink configuration key {} is skipped because it contains white space", (Object)key);
                continue;
            }
            flinkConfStringJoiner.add("-D");
            flinkConfStringJoiner.add(key + "=" + value);
        }
        envs.put("ZEPPELIN_FLINK_APPLICATION_MODE_CONF", flinkConfStringJoiner.toString());
    }

    private List<String> getYarnShipFiles(InterpreterLaunchContext context) throws IOException {
        ArrayList<String> yarnShipFiles = new ArrayList<String>();
        String hiveConfDirProperty = context.getProperties().getProperty("HIVE_CONF_DIR");
        if (StringUtils.isNotBlank((CharSequence)hiveConfDirProperty) && Boolean.parseBoolean(context.getProperties().getProperty("zeppelin.flink.enableHive", "false"))) {
            File hiveSiteFile = new File(hiveConfDirProperty, "hive-site.xml");
            if (hiveSiteFile.isFile() && hiveSiteFile.exists()) {
                yarnShipFiles.add(hiveSiteFile.getAbsolutePath());
            } else {
                LOGGER.warn("Hive site file: {} doesn't exist or is not a directory", (Object)hiveSiteFile);
            }
        }
        if (context.getProperties().containsKey("yarn.ship-files")) {
            yarnShipFiles.add(context.getProperties().getProperty("yarn.ship-files"));
        }
        return yarnShipFiles;
    }
}

