/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.zeppelin.interpreter.launcher.utils.TarFileEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TarUtils.class);

    private TarUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void compress(String name, List<TarFileEntry> files) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(name);
             TarArchiveOutputStream out = TarUtils.getTarArchiveOutputStream(fileOutputStream);){
            for (TarFileEntry tarFileEntry : files) {
                TarUtils.addToArchiveCompression(out, tarFileEntry.getFile(), tarFileEntry.getArchivePath());
            }
        }
    }

    public static void decompress(String in, File out) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(in);){
            GzipCompressorInputStream gzipInputStream = new GzipCompressorInputStream((InputStream)fileInputStream);
            try (TarArchiveInputStream fin = new TarArchiveInputStream((InputStream)gzipInputStream);){
                TarArchiveEntry entry;
                while ((entry = fin.getNextTarEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    File curfile = new File(out, entry.getName());
                    File parent = curfile.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    IOUtils.copy((InputStream)fin, (OutputStream)new FileOutputStream(curfile));
                }
            }
        }
    }

    private static TarArchiveOutputStream getTarArchiveOutputStream(FileOutputStream fileOutputStream) throws IOException {
        GzipCompressorOutputStream gzipOutputStream = new GzipCompressorOutputStream((OutputStream)fileOutputStream);
        TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)gzipOutputStream);
        taos.setBigNumberMode(1);
        taos.setLongFileMode(2);
        taos.setAddPaxHeadersForNonAsciiNames(true);
        return taos;
    }

    private static void addToArchiveCompression(TarArchiveOutputStream out, File file, String dir) throws IOException {
        if (file.isFile()) {
            String archivePath = "." + dir;
            LOGGER.info("archivePath = {}", (Object)archivePath);
            out.putArchiveEntry(new TarArchiveEntry(file, archivePath));
            try (FileInputStream in = new FileInputStream(file);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            out.closeArchiveEntry();
        } else if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    String appendDir = child.getAbsolutePath().replace(file.getAbsolutePath(), "");
                    TarUtils.addToArchiveCompression(out, child, dir + appendDir);
                }
            }
        } else {
            LOGGER.error("{} is not supported", (Object)file.getName());
        }
    }
}

