/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.SourceProducer;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.reactivestreams.Subscription;

final class MonoRunnable<T>
extends Mono<T>
implements Callable<Void>,
SourceProducer<T> {
    final Runnable run;

    MonoRunnable(Runnable run) {
        this.run = Objects.requireNonNull(run, "run");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        MonoRunnableEagerSubscription s = new MonoRunnableEagerSubscription();
        actual.onSubscribe(s);
        if (s.isCancelled()) {
            return;
        }
        try {
            this.run.run();
            actual.onComplete();
        }
        catch (Throwable ex) {
            actual.onError(Operators.onOperatorError(ex, actual.currentContext()));
        }
    }

    @Override
    @Nullable
    public T block(Duration m) {
        this.run.run();
        return null;
    }

    @Override
    @Nullable
    public T block() {
        this.run.run();
        return null;
    }

    @Override
    @Nullable
    public Void call() throws Exception {
        this.run.run();
        return null;
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }

    static final class MonoRunnableEagerSubscription
    extends AtomicBoolean
    implements Subscription {
        MonoRunnableEagerSubscription() {
        }

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
            this.set(true);
        }

        public boolean isCancelled() {
            return this.get();
        }
    }
}

