/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc.hive;

import java.io.OutputStream;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbcp2.DelegatingStatement;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.hive.jdbc.HiveStatement;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.jdbc.JDBCInterpreter;
import org.apache.zeppelin.jdbc.hive.ProgressBar;
import org.apache.zeppelin.jdbc.hive.YarnUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveUtils.class);
    private static final int DEFAULT_QUERY_PROGRESS_INTERVAL = 1000;
    private static final Pattern JOBURL_PATTERN = Pattern.compile(".*Tracking URL = (\\S*).*", 32);
    private static final Pattern APPID_PATTERN = Pattern.compile(".*with App id (\\S*)\\).*", 32);

    public static void startHiveMonitorThread(Statement stmt, InterpreterContext context, boolean displayLog, JDBCInterpreter jdbcInterpreter) {
        HiveStatement hiveStmt = (HiveStatement)((DelegatingStatement)((DelegatingStatement)stmt).getDelegate()).getDelegate();
        String hiveVersion = HiveVersionInfo.getVersion();
        ProgressBar progressBarTemp = null;
        if (HiveUtils.isProgressBarSupported(hiveVersion)) {
            LOGGER.debug("ProgressBar is supported for hive version: {}", (Object)hiveVersion);
            progressBarTemp = new ProgressBar();
        } else {
            LOGGER.debug("ProgressBar is not supported for hive version: {}", (Object)hiveVersion);
        }
        ProgressBar progressBar = progressBarTemp;
        long queryInterval = Long.parseLong(jdbcInterpreter.getProperty("zeppelin.jdbc.hive.monitor.query_interval", "1000"));
        Thread thread = new Thread(() -> {
            String jobUrlTemplate = jdbcInterpreter.getProperty("zeppelin.jdbc.hive.jobUrl.template");
            boolean jobUrlExtracted = false;
            try {
                while (hiveStmt.hasMoreLogs() && !hiveStmt.isClosed() && !Thread.interrupted()) {
                    Thread.sleep(queryInterval);
                    List logs = hiveStmt.getQueryLog();
                    String logsOutput = StringUtils.join(logs, System.lineSeparator());
                    LOGGER.debug("Hive job output: {}", (Object)logsOutput);
                    boolean displayLogProperty = context.getBooleanLocalProperty("displayLog", displayLog);
                    if (!StringUtils.isBlank(logsOutput) && displayLogProperty) {
                        context.out.write(logsOutput + "\n");
                        context.out.flush();
                    }
                    if (!StringUtils.isBlank(logsOutput) && progressBar != null && displayLogProperty) {
                        progressBar.operationLogShowedToUser();
                    }
                    if (jobUrlExtracted) continue;
                    jobUrlExtracted = HiveUtils.extractJobURL(logsOutput, jobUrlTemplate, context);
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Hive monitor thread is interrupted", e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.warn("Fail to monitor hive statement", e);
            }
            LOGGER.info("HiveMonitor-Thread is finished");
        });
        thread.setName("HiveMonitor-Thread");
        thread.setDaemon(true);
        thread.start();
        LOGGER.info("Start HiveMonitor-Thread for sql: {}", (Object)hiveStmt);
        if (progressBar != null) {
            progressBar.setInPlaceUpdateStream(hiveStmt, (OutputStream)context.out);
        }
    }

    private static boolean extractJobURL(String logsOutput, String jobUrlTemplate, InterpreterContext context) {
        Object yarnAppId;
        Object jobUrl = null;
        Optional<String> mrJobURLOption = HiveUtils.extractMRJobURL(logsOutput);
        Optional<String> tezAppIdOption = HiveUtils.extractTezAppId(logsOutput);
        if (mrJobURLOption.isPresent()) {
            jobUrl = mrJobURLOption.get();
            LOGGER.info("Extract MR jobUrl: {} from logs", (Object)mrJobURLOption.get());
            if (StringUtils.isNotBlank(jobUrlTemplate)) {
                yarnAppId = HiveUtils.extractYarnAppId((String)jobUrl);
                if (((Optional)yarnAppId).isPresent()) {
                    LOGGER.info("Extract yarn app id: {} from MR jobUrl", yarnAppId);
                    jobUrl = jobUrlTemplate.replace("{{applicationId}}", (CharSequence)((Optional)yarnAppId).get());
                } else {
                    LOGGER.warn("Unable to extract yarn App Id from jobURL: {}", jobUrl);
                }
            }
        } else if (tezAppIdOption.isPresent()) {
            yarnAppId = tezAppIdOption.get();
            LOGGER.info("Extract Tez job yarn appId: {} from logs", yarnAppId);
            if (StringUtils.isNotBlank(jobUrlTemplate)) {
                jobUrl = jobUrlTemplate.replace("{{applicationId}}", (CharSequence)yarnAppId);
            } else {
                LOGGER.warn("Unable to set JobUrl because zeppelin.jdbc.hive.jobUrl.template is not set");
                jobUrl = yarnAppId;
            }
        } else if (HiveUtils.isHadoopJarAvailable()) {
            yarnAppId = YarnUtil.getYarnAppIdByTag(context.getParagraphId());
            if (StringUtils.isNotBlank((CharSequence)yarnAppId)) {
                LOGGER.info("Extract yarn appId: {} by tag", yarnAppId);
                jobUrl = StringUtils.isNotBlank(jobUrlTemplate) ? jobUrlTemplate.replace("{{applicationId}}", (CharSequence)yarnAppId) : yarnAppId;
            }
        } else {
            LOGGER.warn("Hadoop jar is not available, unable to use tags to fetch yarn app url");
        }
        if (jobUrl != null) {
            LOGGER.info("Detected hive jobUrl: {}", jobUrl);
            HashMap<String, Object> infos = new HashMap<String, Object>();
            infos.put("jobUrl", jobUrl);
            infos.put("label", "HIVE JOB");
            infos.put("tooltip", "View in YARN WEB UI");
            infos.put("noteId", context.getNoteId());
            infos.put("paraId", context.getParagraphId());
            context.getIntpEventClient().onParaInfosReceived(infos);
            return true;
        }
        return false;
    }

    private static boolean isHadoopJarAvailable() {
        try {
            Class.forName("org.apache.hadoop.conf.Configuration");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isProgressBarSupported(String hiveVersion) {
        String[] tokens = hiveVersion.split("\\.");
        int majorVersion = Integer.parseInt(tokens[0]);
        int minorVersion = Integer.parseInt(tokens[1]);
        return majorVersion > 2 || majorVersion == 2 && minorVersion >= 3;
    }

    static Optional<String> extractMRJobURL(String log) {
        Matcher matcher = JOBURL_PATTERN.matcher(log);
        if (matcher.matches()) {
            String jobURL = matcher.group(1);
            return Optional.of(jobURL);
        }
        return Optional.empty();
    }

    static Optional<String> extractTezAppId(String log) {
        Matcher matcher = APPID_PATTERN.matcher(log);
        if (matcher.matches()) {
            String appId = matcher.group(1);
            return Optional.of(appId);
        }
        return Optional.empty();
    }

    static Optional<String> extractYarnAppId(String jobURL) {
        int pos = jobURL.indexOf("application_");
        if (pos != -1) {
            return Optional.of(jobURL.substring(pos));
        }
        return Optional.empty();
    }
}

