/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.zeppelin.user.UsernamePassword;

public class JDBCUserConfigurations {
    private final Map<String, Statement> paragraphIdStatementMap = new HashMap<String, Statement>();
    private PoolingDriver poolingDriver;
    private Properties properties;
    private Boolean isSuccessful;

    public void initStatementMap() throws SQLException {
        for (Statement statement : this.paragraphIdStatementMap.values()) {
            statement.close();
        }
        this.paragraphIdStatementMap.clear();
    }

    public void initConnectionPoolMap() throws SQLException {
        this.poolingDriver = null;
        this.isSuccessful = null;
    }

    public void setProperty(Properties properties) {
        this.properties = (Properties)properties.clone();
    }

    public Properties getProperty() {
        return this.properties;
    }

    public void cleanUserProperty() {
        this.properties.remove("user");
        this.properties.remove("password");
    }

    public void setUserProperty(UsernamePassword usernamePassword) {
        this.properties.setProperty("user", usernamePassword.getUsername());
        this.properties.setProperty("password", usernamePassword.getPassword());
    }

    public void saveStatement(String paragraphId, Statement statement) throws SQLException {
        this.paragraphIdStatementMap.put(paragraphId, statement);
    }

    public void cancelStatement(String paragraphId) throws SQLException {
        this.paragraphIdStatementMap.get(paragraphId).cancel();
    }

    public void removeStatement(String paragraphId) {
        this.paragraphIdStatementMap.remove(paragraphId);
    }

    public void saveDBDriverPool(PoolingDriver driver) throws SQLException {
        this.poolingDriver = driver;
        this.isSuccessful = false;
    }

    public PoolingDriver removeDBDriverPool() throws SQLException {
        this.isSuccessful = null;
        PoolingDriver tmp = this.poolingDriver;
        this.poolingDriver = null;
        return tmp;
    }

    public boolean isConnectionInDBDriverPool() {
        return this.poolingDriver != null;
    }

    public void setConnectionInDBDriverPoolSuccessful() {
        this.isSuccessful = true;
    }
}

