/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.file;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.completer.CompletionType;
import org.apache.zeppelin.file.FileInterpreter;
import org.apache.zeppelin.file.HDFSCommand;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSFileInterpreter
extends FileInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HDFSFileInterpreter.class);
    static final String HDFS_URL = "hdfs.url";
    static final String HDFS_USER = "hdfs.user";
    static final String HDFS_MAXLENGTH = "hdfs.maxlength";
    Exception exceptionOnConnect = null;
    HDFSCommand cmd = null;
    Gson gson = null;

    public void prepare() {
        String userName = this.getProperty(HDFS_USER);
        String hdfsUrl = this.getProperty(HDFS_URL);
        int i = Integer.parseInt(this.getProperty(HDFS_MAXLENGTH));
        this.cmd = new HDFSCommand(hdfsUrl, userName, LOGGER, i);
        this.gson = new Gson();
    }

    public HDFSFileInterpreter(Properties property) {
        super(property);
        this.prepare();
    }

    private void testConnection() {
        try {
            if (this.isDirectory("/")) {
                LOGGER.info("Successfully created WebHDFS connection");
            }
        }
        catch (Exception e) {
            LOGGER.error("testConnection: Cannot open WebHDFS connection. Bad URL: /", e);
            this.exceptionOnConnect = e;
        }
    }

    public void open() {
        this.testConnection();
    }

    public void close() {
    }

    private String listDir(String path) throws Exception {
        return this.cmd.runCommand(this.cmd.listStatus, path, null);
    }

    private String listPermission(OneFileStatus fs) {
        StringBuilder sb = new StringBuilder();
        sb.append(fs.type.equalsIgnoreCase("Directory") ? (char)'d' : '-');
        int p = Integer.parseInt(fs.permission, 16);
        sb.append((p & 0x400) == 0 ? (char)'-' : 'r');
        sb.append((p & 0x200) == 0 ? (char)'-' : 'w');
        sb.append((p & 0x100) == 0 ? (char)'-' : 'x');
        sb.append((p & 0x40) == 0 ? (char)'-' : 'r');
        sb.append((p & 0x20) == 0 ? (char)'-' : 'w');
        sb.append((p & 0x10) == 0 ? (char)'-' : 'x');
        sb.append((p & 4) == 0 ? (char)'-' : 'r');
        sb.append((p & 2) == 0 ? (char)'-' : 'w');
        sb.append((p & 1) == 0 ? (char)'-' : 'x');
        return sb.toString();
    }

    private String listDate(OneFileStatus fs) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(fs.modificationTime));
    }

    private String listOne(String path, OneFileStatus fs) {
        if (this.args.flags.contains(new Character('l'))) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.listPermission(fs) + "\t");
            sb.append((Serializable)(fs.replication == 0 ? "-" : Integer.valueOf(fs.replication)) + "\t ");
            sb.append(fs.owner + "\t");
            sb.append(fs.group + "\t");
            if (this.args.flags.contains(new Character('h'))) {
                sb.append(this.humanReadableByteCount(fs.length) + "\t\t");
            } else {
                sb.append(fs.length + "\t");
            }
            sb.append(this.listDate(fs) + "GMT\t");
            sb.append(path.length() == 1 ? path + fs.pathSuffix : path + "/" + fs.pathSuffix);
            return sb.toString();
        }
        return fs.pathSuffix;
    }

    private String humanReadableByteCount(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "" + "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public String listFile(String filePath) {
        try {
            String str = this.cmd.runCommand(this.cmd.getFileStatus, filePath, null);
            SingleFileStatus sfs = this.gson.fromJson(str, SingleFileStatus.class);
            if (sfs != null) {
                return this.listOne(filePath, sfs.fileStatus);
            }
        }
        catch (Exception e) {
            LOGGER.error("listFile: " + filePath, e);
        }
        return "No such File or directory";
    }

    @Override
    public String listAll(String path) throws InterpreterException {
        Object all = "";
        if (this.exceptionOnConnect != null) {
            return "Error connecting to provided endpoint.";
        }
        try {
            if (this.isDirectory(path)) {
                AllFileStatus allFiles;
                String sfs = this.listDir(path);
                if (sfs != null && (allFiles = this.gson.fromJson(sfs, AllFileStatus.class)) != null && allFiles.fileStatuses != null && allFiles.fileStatuses.fileStatus != null) {
                    int length = this.cmd.maxLength < allFiles.fileStatuses.fileStatus.length ? this.cmd.maxLength : allFiles.fileStatuses.fileStatus.length;
                    for (int index = 0; index < length; ++index) {
                        OneFileStatus fs = allFiles.fileStatuses.fileStatus[index];
                        all = (String)all + this.listOne(path, fs) + "\n";
                    }
                }
                return all;
            }
            return this.listFile(path);
        }
        catch (Exception e) {
            LOGGER.error("listall: listDir " + path, e);
            throw new InterpreterException("Could not find file or directory:\t" + path);
        }
    }

    @Override
    public boolean isDirectory(String path) {
        boolean ret = false;
        if (this.exceptionOnConnect != null) {
            return ret;
        }
        try {
            String str = this.cmd.runCommand(this.cmd.getFileStatus, path, null);
            SingleFileStatus sfs = this.gson.fromJson(str, SingleFileStatus.class);
            if (sfs != null) {
                return sfs.fileStatus.type.equals("DIRECTORY");
            }
        }
        catch (Exception e) {
            LOGGER.error("IsDirectory: " + path, e);
            return false;
        }
        return ret;
    }

    @Override
    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        block12: {
            String globalPath;
            LOGGER.info("Completion request at position\t" + cursor + " in string " + buf);
            ArrayList<InterpreterCompletion> suggestions = new ArrayList<InterpreterCompletion>();
            if (StringUtils.isEmpty(buf)) {
                suggestions.add(new InterpreterCompletion("ls", "ls", CompletionType.command.name()));
                suggestions.add(new InterpreterCompletion("cd", "cd", CompletionType.command.name()));
                suggestions.add(new InterpreterCompletion("pwd", "pwd", CompletionType.command.name()));
                return suggestions;
            }
            if (buf.split(" ").length == 1) {
                if ("cd".contains(buf)) {
                    suggestions.add(new InterpreterCompletion("cd", "cd", CompletionType.command.name()));
                }
                if ("ls".contains(buf)) {
                    suggestions.add(new InterpreterCompletion("ls", "ls", CompletionType.command.name()));
                }
                if ("pwd".contains(buf)) {
                    suggestions.add(new InterpreterCompletion("pwd", "pwd", CompletionType.command.name()));
                }
                return suggestions;
            }
            String lastToken = buf.substring(buf.lastIndexOf(" ") + 1);
            if (lastToken.startsWith("-")) {
                return null;
            }
            String localPath = "";
            String unfinished = lastToken;
            if (lastToken.contains("/")) {
                localPath = lastToken.substring(0, lastToken.lastIndexOf(47) + 1);
                unfinished = lastToken.substring(lastToken.lastIndexOf(47) + 1);
            }
            if (this.isDirectory(globalPath = this.getNewPath(localPath))) {
                try {
                    AllFileStatus allFiles;
                    String fileStatusString = this.listDir(globalPath);
                    if (fileStatusString != null && (allFiles = this.gson.fromJson(fileStatusString, AllFileStatus.class)) != null && allFiles.fileStatuses != null && allFiles.fileStatuses.fileStatus != null) {
                        for (OneFileStatus fs : allFiles.fileStatuses.fileStatus) {
                            if (!fs.pathSuffix.contains(unfinished)) continue;
                            String beforeLastPeriod = unfinished.substring(0, unfinished.lastIndexOf(46) + 1);
                            String suggestedFinish = fs.pathSuffix.substring(beforeLastPeriod.length());
                            suggestions.add(new InterpreterCompletion(suggestedFinish, suggestedFinish, CompletionType.path.name()));
                        }
                        return suggestions;
                    }
                    break block12;
                }
                catch (Exception e) {
                    LOGGER.error("listall: listDir " + globalPath, e);
                    return null;
                }
            }
            LOGGER.info("path is not a directory.  No values suggested.");
        }
        return null;
    }

    public class AllFileStatus {
        @SerializedName(value="FileStatuses")
        public MultiFileStatus fileStatuses;
    }

    public class MultiFileStatus {
        @SerializedName(value="FileStatus")
        public OneFileStatus[] fileStatus;
    }

    public class SingleFileStatus {
        @SerializedName(value="FileStatus")
        public OneFileStatus fileStatus;
    }

    public class OneFileStatus {
        public long accessTime;
        public long blockSize;
        public int childrenNum;
        public long fileId;
        public String group;
        public long length;
        public long modificationTime;
        public String owner;
        public String pathSuffix;
        public String permission;
        public int replication;
        public int storagePolicy;
        public String type;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\nAccessTime = ").append(this.accessTime);
            sb.append("\nBlockSize = ").append(this.blockSize);
            sb.append("\nChildrenNum = ").append(this.childrenNum);
            sb.append("\nFileId = ").append(this.fileId);
            sb.append("\nGroup = ").append(this.group);
            sb.append("\nLength = ").append(this.length);
            sb.append("\nModificationTime = ").append(this.modificationTime);
            sb.append("\nOwner = ").append(this.owner);
            sb.append("\nPathSuffix = ").append(this.pathSuffix);
            sb.append("\nPermission = ").append(this.permission);
            sb.append("\nReplication = ").append(this.replication);
            sb.append("\nStoragePolicy = ").append(this.storagePolicy);
            sb.append("\nType = ").append(this.type);
            return sb.toString();
        }
    }
}

