/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.thrift.TException;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.dep.DependencyResolver;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.helium.Application;
import org.apache.zeppelin.helium.ApplicationContext;
import org.apache.zeppelin.helium.ApplicationException;
import org.apache.zeppelin.helium.ApplicationLoader;
import org.apache.zeppelin.helium.HeliumAppAngularObjectRegistry;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterHookListener;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterOutputListener;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutput;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.LifecycleManager;
import org.apache.zeppelin.interpreter.remote.InvokeResourceMethodEventMessage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventClient;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.interpreter.remote.YarnUtils;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.thrift.InterpreterRPCException;
import org.apache.zeppelin.interpreter.thrift.RegisterInfo;
import org.apache.zeppelin.interpreter.thrift.RemoteApplicationResult;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterContext;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterResult;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterResultMessage;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.apache.zeppelin.resource.DistributedResourcePool;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.apache.zeppelin.scheduler.ExecutorFactory;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.JobListener;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterServer
extends Thread
implements RemoteInterpreterService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInterpreterServer.class);
    public static final int DEFAULT_SHUTDOWN_TIMEOUT = 2000;
    private String interpreterGroupId;
    private InterpreterGroup interpreterGroup;
    private AngularObjectRegistry angularObjectRegistry;
    private InterpreterHookRegistry hookRegistry;
    private DistributedResourcePool resourcePool;
    private ApplicationLoader appLoader;
    private Gson gson = new Gson();
    private String launcherEnv = System.getenv("ZEPPELIN_INTERPRETER_LAUNCHER");
    private String intpEventServerHost;
    private int intpEventServerPort;
    private String host;
    private int port;
    private TThreadPoolServer server;
    RemoteInterpreterEventClient intpEventClient;
    private DependencyResolver depLoader;
    private LifecycleManager lifecycleManager;
    private final Map<String, RunningApplication> runningApplications = Collections.synchronizedMap(new HashMap());
    private ConcurrentMap<String, Integer> progressMap = new ConcurrentHashMap<String, Integer>();
    private ConcurrentMap<String, InterpretJob> runningJobs = new ConcurrentHashMap<String, InterpretJob>();
    private int resultCacheInSeconds;
    private ScheduledExecutorService resultCleanService = Executors.newSingleThreadScheduledExecutor();
    private boolean isTest;
    private boolean isForceShutdown = true;
    private ZeppelinConfiguration zConf;
    private static Thread shutdownThread;

    public RemoteInterpreterServer(String intpEventServerHost, int intpEventServerPort, String interpreterGroupId, String portRange) throws Exception {
        this(intpEventServerHost, intpEventServerPort, portRange, interpreterGroupId, false);
    }

    public RemoteInterpreterServer(String intpEventServerHost, int intpEventServerPort, String portRange, String interpreterGroupId, boolean isTest) throws Exception {
        super("RemoteInterpreterServer-Thread");
        if (null != intpEventServerHost) {
            this.intpEventServerHost = intpEventServerHost;
            this.intpEventServerPort = intpEventServerPort;
            this.port = RemoteInterpreterUtils.findAvailablePort(portRange);
            this.host = RemoteInterpreterUtils.findAvailableHostAddress();
        } else {
            this.port = intpEventServerPort;
        }
        this.isTest = isTest;
        this.interpreterGroupId = interpreterGroupId;
    }

    @Override
    public void run() {
        RemoteInterpreterService.Processor<RemoteInterpreterServer> processor = new RemoteInterpreterService.Processor<RemoteInterpreterServer>(this);
        try (TServerSocket tSocket = new TServerSocket(this.port);){
            this.server = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)tSocket).stopTimeoutVal(2000).stopTimeoutUnit(TimeUnit.MILLISECONDS).processor(processor));
            if (null != this.intpEventServerHost && !this.isTest) {
                Thread registerThread = new Thread(new RegisterRunnable());
                registerThread.setName("RegisterThread");
                registerThread.start();
            }
            LOGGER.info("Launching ThriftServer at {}:{}", (Object)this.host, (Object)this.port);
            this.server.serve();
        }
        catch (TTransportException e) {
            LOGGER.error("Failure in TTransport", (Throwable)e);
        }
        LOGGER.info("RemoteInterpreterServer-Thread finished");
    }

    @Override
    public void init(Map<String, String> properties) throws InterpreterRPCException, TException {
        this.zConf = ZeppelinConfiguration.load();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.zConf.setProperty(entry.getKey(), entry.getValue());
        }
        try {
            this.lifecycleManager = this.createLifecycleManager();
            this.lifecycleManager.onInterpreterProcessStarted(this.interpreterGroupId);
        }
        catch (Exception e) {
            throw new InterpreterRPCException("Fail to create LifecycleManager, cause: " + e.toString());
        }
        if (!this.isTest) {
            int connectionPoolSize = this.zConf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECTION_POOL_SIZE);
            LOGGER.info("Creating RemoteInterpreterEventClient with connection pool size: {}", (Object)connectionPoolSize);
            this.intpEventClient = new RemoteInterpreterEventClient(this.intpEventServerHost, this.intpEventServerPort, connectionPoolSize);
        }
    }

    @Override
    public void shutdown() throws InterpreterRPCException, TException {
        if (this.intpEventClient != null) {
            try {
                LOGGER.info("Unregister interpreter process");
                this.intpEventClient.unRegisterInterpreterProcess();
            }
            catch (Exception e) {
                LOGGER.error("Fail to unregister remote interpreter process", (Throwable)e);
            }
        }
        if (shutdownThread != null) {
            if (Runtime.getRuntime().removeShutdownHook(shutdownThread)) {
                LOGGER.debug("ShutdownHook removed, because of a regular shutdown");
            } else {
                LOGGER.warn("The ShutdownHook could not be removed");
            }
        }
        ShutdownThread shutDownThread = new ShutdownThread("ShutdownCall");
        shutDownThread.start();
    }

    public ZeppelinConfiguration getConf() {
        return this.zConf;
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        if (this.server == null) {
            return false;
        }
        return this.server.isServing();
    }

    private LifecycleManager createLifecycleManager() throws Exception {
        String lifecycleManagerClass = this.zConf.getLifecycleManagerClass();
        Class<?> clazz = Class.forName(lifecycleManagerClass);
        LOGGER.info("Creating interpreter lifecycle manager: {}", (Object)lifecycleManagerClass);
        return (LifecycleManager)clazz.getConstructor(ZeppelinConfiguration.class, RemoteInterpreterServer.class).newInstance(this.zConf, this);
    }

    public static void main(String[] args) throws Exception {
        String zeppelinServerHost = null;
        int port = 29914;
        String portRange = ":";
        String interpreterGroupId = null;
        if (args.length > 0) {
            zeppelinServerHost = args[0];
            port = Integer.parseInt(args[1]);
            interpreterGroupId = args[2];
            if (args.length > 3) {
                portRange = args[3];
            }
        }
        RemoteInterpreterServer remoteInterpreterServer = new RemoteInterpreterServer(zeppelinServerHost, port, interpreterGroupId, portRange);
        remoteInterpreterServer.start();
        RemoteInterpreterServer remoteInterpreterServer2 = remoteInterpreterServer;
        Objects.requireNonNull(remoteInterpreterServer2);
        shutdownThread = remoteInterpreterServer2.new ShutdownThread("ShutdownHook");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        remoteInterpreterServer.join();
        LOGGER.info("RemoteInterpreterServer thread is finished");
        if (remoteInterpreterServer.isForceShutdown) {
            LOGGER.info("Force shutting down");
            System.exit(0);
        }
    }

    @Override
    public void createInterpreter(String interpreterGroupId, String sessionId, String className, Map<String, String> properties, String userName) throws InterpreterRPCException, TException {
        try {
            boolean isPresent;
            if (this.interpreterGroup == null) {
                this.interpreterGroup = new InterpreterGroup(interpreterGroupId);
                this.angularObjectRegistry = new AngularObjectRegistry(this.interpreterGroup.getId(), this.intpEventClient);
                this.hookRegistry = new InterpreterHookRegistry();
                this.resourcePool = new DistributedResourcePool(this.interpreterGroup.getId(), this.intpEventClient);
                this.interpreterGroup.setInterpreterHookRegistry(this.hookRegistry);
                this.interpreterGroup.setAngularObjectRegistry(this.angularObjectRegistry);
                this.interpreterGroup.setResourcePool(this.resourcePool);
                this.intpEventClient.setIntpGroupId(interpreterGroupId);
                String localRepoPath = properties.get("zeppelin.interpreter.localRepo");
                if (properties.containsKey("zeppelin.interpreter.output.limit")) {
                    InterpreterOutput.LIMIT = Integer.parseInt(properties.get("zeppelin.interpreter.output.limit"));
                }
                this.depLoader = new DependencyResolver(localRepoPath, this.zConf);
                this.appLoader = new ApplicationLoader(this.resourcePool, this.depLoader);
                this.resultCacheInSeconds = Integer.parseInt(properties.getOrDefault("zeppelin.interpreter.result.cache", "0"));
            }
            if (isPresent = ((List)Optional.ofNullable(this.interpreterGroup.get(sessionId)).orElse(new ArrayList())).stream().filter(m -> m.getClassName().equals(className)).findAny().isPresent()) {
                LOGGER.info("interpreter {} is existing", (Object)className);
                return;
            }
            Class<?> replClass = Class.forName(className);
            Properties p = new Properties();
            p.putAll(properties);
            this.setSystemProperty(p);
            Constructor<?> constructor = replClass.getConstructor(Properties.class);
            Interpreter interpreter = (Interpreter)constructor.newInstance(p);
            interpreter.setClassloaderUrls(new URL[0]);
            interpreter.setInterpreterGroup(this.interpreterGroup);
            interpreter.setUserName(userName);
            interpreter.setZeppelinConfiguration(this.zConf);
            this.interpreterGroup.addInterpreterToSession(new LazyOpenInterpreter(interpreter), sessionId);
            this.isForceShutdown = Boolean.parseBoolean(properties.getOrDefault("zeppelin.interpreter.forceShutdown", "true"));
            LOGGER.info("Instantiate interpreter {}, isForceShutdown: {}", (Object)className, (Object)this.isForceShutdown);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new InterpreterRPCException("Fail to create interpreter, cause: " + e.toString());
        }
    }

    protected InterpreterGroup getInterpreterGroup() {
        return this.interpreterGroup;
    }

    protected ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    protected RemoteInterpreterEventClient getIntpEventClient() {
        return this.intpEventClient;
    }

    private void setSystemProperty(Properties properties) {
        for (Object key : properties.keySet()) {
            String value;
            if (RemoteInterpreterUtils.isEnvString((String)key) || StringUtils.isBlank((CharSequence)(value = properties.getProperty((String)key)))) continue;
            System.setProperty((String)key, properties.getProperty((String)key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Interpreter getInterpreter(String sessionId, String className) throws InterpreterRPCException, TException {
        if (this.interpreterGroup == null) {
            throw new InterpreterRPCException("Interpreter instance " + className + " not created");
        }
        InterpreterGroup interpreterGroup = this.interpreterGroup;
        synchronized (interpreterGroup) {
            List<Interpreter> interpreters = this.interpreterGroup.get(sessionId);
            if (interpreters == null) {
                throw new InterpreterRPCException("Interpreter " + className + " not initialized");
            }
            for (Interpreter inp : interpreters) {
                if (!inp.getClassName().equals(className)) continue;
                return inp;
            }
        }
        throw new InterpreterRPCException("Interpreter instance " + className + " not found");
    }

    @Override
    public void open(String sessionId, String className) throws InterpreterRPCException, TException {
        LOGGER.info("Open Interpreter {} for session {}", (Object)className, (Object)sessionId);
        Interpreter intp = this.getInterpreter(sessionId, className);
        try {
            intp.open();
        }
        catch (InterpreterException e) {
            throw new InterpreterRPCException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(String sessionId, String className) throws InterpreterRPCException, TException {
        for (String appId : this.runningApplications.keySet()) {
            RunningApplication appInfo = this.runningApplications.get(appId);
            if (!appInfo.noteId.equals(sessionId) && !sessionId.equals("shared_session")) continue;
            try {
                LOGGER.info("Unload App {} ", (Object)appInfo.pkg.getName());
                appInfo.app.unload();
                this.intpEventClient.onAppStatusUpdate(appInfo.noteId, appInfo.paragraphId, appId, "UNLOADED");
            }
            catch (ApplicationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.interpreterGroup != null) {
            InterpreterGroup interpreterGroup = this.interpreterGroup;
            synchronized (interpreterGroup) {
                List<Interpreter> interpreters = this.interpreterGroup.get(sessionId);
                if (interpreters != null) {
                    Iterator<Interpreter> it = interpreters.iterator();
                    while (it.hasNext()) {
                        Interpreter inp = it.next();
                        boolean isOpen = true;
                        if (inp instanceof LazyOpenInterpreter) {
                            LazyOpenInterpreter lazy = (LazyOpenInterpreter)inp;
                            isOpen = lazy.isOpen();
                        }
                        if (!inp.getClassName().equals(className) || !isOpen) continue;
                        try {
                            LOGGER.debug("Trying to close interpreter {} with scheduler thread{}", (Object)inp.getClassName(), (Object)inp.getScheduler().getName());
                            inp.close();
                            inp.getScheduler().stop();
                        }
                        catch (InterpreterException e) {
                            LOGGER.warn("Fail to close interpreter", (Throwable)e);
                        }
                        it.remove();
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void reconnect(String host, int port) throws InterpreterRPCException, TException {
        try {
            LOGGER.info("Reconnect to this interpreter process from {}:{}", (Object)host, (Object)port);
            this.intpEventServerHost = host;
            this.intpEventServerPort = port;
            this.intpEventClient = new RemoteInterpreterEventClient(this.intpEventServerHost, this.intpEventServerPort, this.zConf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECTION_POOL_SIZE));
            this.intpEventClient.setIntpGroupId(this.interpreterGroupId);
            this.angularObjectRegistry = new AngularObjectRegistry(this.interpreterGroup.getId(), this.intpEventClient);
            this.resourcePool = new DistributedResourcePool(this.interpreterGroup.getId(), this.intpEventClient);
            for (InterpreterContext context : InterpreterContext.getAllContexts().values()) {
                context.setIntpEventClient(this.intpEventClient);
                context.setAngularObjectRegistry(this.angularObjectRegistry);
                context.setResourcePool(this.resourcePool);
            }
        }
        catch (Exception e) {
            throw new InterpreterRPCException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteInterpreterResult interpret(String sessionId, String className, String st, RemoteInterpreterContext interpreterContext) throws InterpreterRPCException, TException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("st:\n{}", (Object)st);
            }
            this.lifecycleManager.onInterpreterUse(this.interpreterGroupId);
            Interpreter intp = this.getInterpreter(sessionId, className);
            InterpreterContext context = this.convert(interpreterContext);
            context.setInterpreterClassName(intp.getClassName());
            InterpretJob interpretJob = null;
            boolean isRecover = Boolean.parseBoolean(context.getLocalProperties().getOrDefault("isRecover", "false"));
            if (isRecover) {
                LOGGER.info("Recovering paragraph: {} of note: {}", (Object)context.getParagraphId(), (Object)context.getNoteId());
                interpretJob = (InterpretJob)this.runningJobs.get(context.getParagraphId());
                if (interpretJob == null) {
                    InterpreterResult result = new InterpreterResult(InterpreterResult.Code.ERROR, "Job is finished, unable to recover it");
                    return this.convert(result, context.getConfig(), context.getGui(), context.getNoteGui());
                }
            } else {
                Scheduler scheduler = intp.getScheduler();
                InterpretJobListener jobListener = new InterpretJobListener();
                interpretJob = new InterpretJob(context.getParagraphId(), "RemoteInterpretJob_" + System.currentTimeMillis(), jobListener, intp, st, context);
                this.runningJobs.put(context.getParagraphId(), interpretJob);
                scheduler.submit(interpretJob);
            }
            while (!interpretJob.isTerminated()) {
                JobListener jobListener;
                JobListener jobListener2 = jobListener = interpretJob.getListener();
                synchronized (jobListener2) {
                    try {
                        jobListener.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.info("Exception in RemoteInterpreterServer while interpret, jobListener.wait", (Throwable)e);
                    }
                }
            }
            this.progressMap.remove(context.getParagraphId());
            this.resultCleanService.schedule(() -> this.runningJobs.remove(context.getParagraphId()), (long)this.resultCacheInSeconds, TimeUnit.SECONDS);
            InterpreterResult result = interpretJob.getReturn();
            if (result == null) {
                result = new InterpreterResult(InterpreterResult.Code.KEEP_PREVIOUS_RESULT);
            }
            return this.convert(result, context.getConfig(), context.getGui(), context.getNoteGui());
        }
        catch (Exception e) {
            LOGGER.error("Internal error when interpret code", (Throwable)e);
            throw new InterpreterRPCException(e.toString());
        }
    }

    @Override
    public void cancel(String sessionId, String className, RemoteInterpreterContext interpreterContext) throws InterpreterRPCException, TException {
        LOGGER.info("cancel {} {}", (Object)className, (Object)interpreterContext.getParagraphId());
        Interpreter intp = this.getInterpreter(sessionId, className);
        String jobId = interpreterContext.getParagraphId();
        Job<?> job = intp.getScheduler().getJob(jobId);
        if (job != null && job.getStatus() == Job.Status.PENDING) {
            job.setStatus(Job.Status.ABORT);
        } else {
            Thread thread = new Thread(() -> {
                try {
                    intp.cancel(this.convert(interpreterContext, null));
                }
                catch (InterpreterException e) {
                    LOGGER.error("Fail to cancel paragraph: {}", (Object)interpreterContext.getParagraphId());
                }
            });
            thread.start();
        }
    }

    @Override
    public int getProgress(String sessionId, String className, RemoteInterpreterContext interpreterContext) throws InterpreterRPCException, TException {
        this.lifecycleManager.onInterpreterUse(this.interpreterGroupId);
        Integer manuallyProvidedProgress = (Integer)this.progressMap.get(interpreterContext.getParagraphId());
        if (manuallyProvidedProgress != null) {
            return manuallyProvidedProgress;
        }
        Interpreter intp = this.getInterpreter(sessionId, className);
        if (intp == null) {
            throw new InterpreterRPCException("No interpreter " + className + " existed for session " + sessionId);
        }
        try {
            return intp.getProgress(this.convert(interpreterContext, null));
        }
        catch (InterpreterException e) {
            throw new InterpreterRPCException(e.toString());
        }
    }

    @Override
    public String getFormType(String sessionId, String className) throws InterpreterRPCException, TException {
        Interpreter intp = this.getInterpreter(sessionId, className);
        try {
            return intp.getFormType().toString();
        }
        catch (InterpreterException e) {
            throw new InterpreterRPCException(e.toString());
        }
    }

    @Override
    public List<InterpreterCompletion> completion(String sessionId, String className, String buf, int cursor, RemoteInterpreterContext remoteInterpreterContext) throws InterpreterRPCException, TException {
        Interpreter intp = this.getInterpreter(sessionId, className);
        try {
            return intp.completion(buf, cursor, this.convert(remoteInterpreterContext, null));
        }
        catch (InterpreterException e) {
            throw new InterpreterRPCException("Fail to get completion, cause: " + e.getMessage());
        }
    }

    private InterpreterContext convert(RemoteInterpreterContext ric) {
        return this.convert(ric, this.createInterpreterOutput(ric.getNoteId(), ric.getParagraphId()));
    }

    private InterpreterContext convert(RemoteInterpreterContext ric, InterpreterOutput output) {
        return InterpreterContext.builder().setNoteId(ric.getNoteId()).setNoteName(ric.getNoteName()).setParagraphId(ric.getParagraphId()).setReplName(ric.getReplName()).setParagraphTitle(ric.getParagraphTitle()).setParagraphText(ric.getParagraphText()).setLocalProperties(ric.getLocalProperties()).setAuthenticationInfo(AuthenticationInfo.fromJson(ric.getAuthenticationInfo())).setGUI(GUI.fromJson(ric.getGui())).setConfig((Map)this.gson.fromJson(ric.getConfig(), new TypeToken<Map<String, Object>>(){}.getType())).setNoteGUI(GUI.fromJson(ric.getNoteGui())).setAngularObjectRegistry(this.interpreterGroup.getAngularObjectRegistry()).setResourcePool(this.interpreterGroup.getResourcePool()).setInterpreterOut(output).setIntpEventClient(this.intpEventClient).setProgressMap(this.progressMap).build();
    }

    protected InterpreterOutput createInterpreterOutput(final String noteId, final String paragraphId) {
        return new InterpreterOutput(new InterpreterOutputListener(){

            @Override
            public void onUpdateAll(InterpreterOutput out) {
                try {
                    RemoteInterpreterServer.this.intpEventClient.onInterpreterOutputUpdateAll(noteId, paragraphId, out.toInterpreterResultMessage());
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }

            @Override
            public void onAppend(int index, InterpreterResultMessageOutput out, byte[] line) {
                String output = new String(line);
                LOGGER.debug("Output Append: {}", (Object)output);
                RemoteInterpreterServer.this.intpEventClient.onInterpreterOutputAppend(noteId, paragraphId, index, output);
            }

            @Override
            public void onUpdate(int index, InterpreterResultMessageOutput out) {
                try {
                    String output = new String(out.toByteArray());
                    LOGGER.debug("Output Update for index {}: {}", (Object)index, (Object)output);
                    RemoteInterpreterServer.this.intpEventClient.onInterpreterOutputUpdate(noteId, paragraphId, index, out.getType(), output);
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private RemoteInterpreterResult convert(InterpreterResult result, Map<String, Object> config, GUI gui, GUI noteGui) {
        LinkedList<RemoteInterpreterResultMessage> msg = new LinkedList<RemoteInterpreterResultMessage>();
        for (InterpreterResultMessage m : result.message()) {
            msg.add(new RemoteInterpreterResultMessage(m.getType().name(), m.getData()));
        }
        return new RemoteInterpreterResult(result.code().name(), msg, this.gson.toJson(config), gui.toJson(), noteGui.toJson());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus(String sessionId, String jobId) throws InterpreterRPCException, TException {
        this.lifecycleManager.onInterpreterUse(this.interpreterGroupId);
        if (this.interpreterGroup == null) {
            return Job.Status.UNKNOWN.name();
        }
        InterpreterGroup interpreterGroup = this.interpreterGroup;
        synchronized (interpreterGroup) {
            List<Interpreter> interpreters = this.interpreterGroup.get(sessionId);
            if (interpreters == null) {
                return Job.Status.UNKNOWN.name();
            }
            for (Interpreter intp : interpreters) {
                Job<?> job;
                Scheduler scheduler = intp.getScheduler();
                if (scheduler == null || (job = scheduler.getJob(jobId)) == null) continue;
                return job.getStatus().name();
            }
        }
        return Job.Status.UNKNOWN.name();
    }

    @Override
    public void angularObjectUpdate(String name, String noteId, String paragraphId, String object) throws InterpreterRPCException, TException {
        AngularObjectRegistry registry = this.interpreterGroup.getAngularObjectRegistry();
        AngularObject ao = registry.get(name, noteId, paragraphId);
        if (ao == null) {
            LOGGER.debug("Angular object {} not exists", (Object)name);
            return;
        }
        if (object == null) {
            ao.set(null, false);
            return;
        }
        Object oldObject = ao.get();
        Object value = null;
        if (oldObject != null) {
            try {
                value = this.gson.fromJson(object, oldObject.getClass());
                ao.set(value, false);
                return;
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (value == null) {
            try {
                value = this.gson.fromJson(object, new TypeToken<Map<String, Object>>(){}.getType());
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (value == null) {
            value = this.gson.fromJson(object, String.class);
        }
        ao.set(value, false);
    }

    @Override
    public void angularObjectAdd(String name, String noteId, String paragraphId, String object) throws InterpreterRPCException, TException {
        AngularObjectRegistry registry = this.interpreterGroup.getAngularObjectRegistry();
        AngularObject ao = registry.get(name, noteId, paragraphId);
        if (ao != null) {
            this.angularObjectUpdate(name, noteId, paragraphId, object);
            return;
        }
        Object value = null;
        try {
            value = this.gson.fromJson(object, new TypeToken<Map<String, Object>>(){}.getType());
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        if (value == null) {
            value = this.gson.fromJson(object, String.class);
        }
        registry.add(name, value, noteId, paragraphId, false);
    }

    @Override
    public void angularObjectRemove(String name, String noteId, String paragraphId) throws InterpreterRPCException, TException {
        AngularObjectRegistry registry = this.interpreterGroup.getAngularObjectRegistry();
        registry.remove(name, noteId, paragraphId, false);
    }

    @Override
    public List<String> resourcePoolGetAll() throws InterpreterRPCException, TException {
        LOGGER.debug("Request resourcePoolGetAll from ZeppelinServer");
        LinkedList<String> result = new LinkedList<String>();
        if (this.resourcePool == null) {
            return result;
        }
        ResourceSet resourceSet = this.resourcePool.getAll(false);
        for (Resource r : resourceSet) {
            result.add(r.toJson());
        }
        return result;
    }

    @Override
    public boolean resourceRemove(String noteId, String paragraphId, String resourceName) throws InterpreterRPCException, TException {
        Resource resource = this.resourcePool.remove(noteId, paragraphId, resourceName);
        return resource != null;
    }

    @Override
    public ByteBuffer resourceGet(String noteId, String paragraphId, String resourceName) throws InterpreterRPCException, TException {
        LOGGER.debug("Request resourceGet {} from ZeppelinServer", (Object)resourceName);
        Resource resource = this.resourcePool.get(noteId, paragraphId, resourceName, false);
        if (resource == null || resource.get() == null || !resource.isSerializable()) {
            return ByteBuffer.allocate(0);
        }
        try {
            return Resource.serializeObject(resource.get());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ByteBuffer.allocate(0);
        }
    }

    @Override
    public ByteBuffer resourceInvokeMethod(String noteId, String paragraphId, String resourceName, String invokeMessage) {
        InvokeResourceMethodEventMessage message = InvokeResourceMethodEventMessage.fromJson(invokeMessage);
        Resource resource = this.resourcePool.get(noteId, paragraphId, resourceName, false);
        if (resource == null || resource.get() == null) {
            return ByteBuffer.allocate(0);
        }
        try {
            Object o = resource.get();
            Method method = o.getClass().getMethod(message.methodName, message.getParamTypes());
            Object ret = method.invoke(o, message.params);
            if (message.shouldPutResultIntoResourcePool()) {
                this.resourcePool.put(noteId, paragraphId, message.returnResourceName, ret);
                Resource returnValResource = this.resourcePool.get(noteId, paragraphId, message.returnResourceName);
                ByteBuffer serialized = Resource.serializeObject(returnValResource);
                if (serialized == null) {
                    return ByteBuffer.allocate(0);
                }
                return serialized;
            }
            ByteBuffer serialized = Resource.serializeObject(ret);
            if (serialized == null) {
                return ByteBuffer.allocate(0);
            }
            return serialized;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ByteBuffer.allocate(0);
        }
    }

    @Override
    public void angularRegistryPush(String registryAsString) throws InterpreterRPCException, TException {
        try {
            Map deserializedRegistry = (Map)this.gson.fromJson(registryAsString, new TypeToken<Map<String, Map<String, AngularObject>>>(){}.getType());
            this.interpreterGroup.getAngularObjectRegistry().setRegistry(deserializedRegistry);
        }
        catch (Exception e) {
            LOGGER.info("Exception in RemoteInterpreterServer while angularRegistryPush, nolock", (Throwable)e);
        }
    }

    protected InterpreterOutput createAppOutput(final String noteId, final String paragraphId, final String appId) {
        return new InterpreterOutput(new InterpreterOutputListener(){

            @Override
            public void onUpdateAll(InterpreterOutput out) {
            }

            @Override
            public void onAppend(int index, InterpreterResultMessageOutput out, byte[] line) {
                RemoteInterpreterServer.this.intpEventClient.onAppOutputAppend(noteId, paragraphId, index, appId, new String(line));
            }

            @Override
            public void onUpdate(int index, InterpreterResultMessageOutput out) {
                try {
                    RemoteInterpreterServer.this.intpEventClient.onAppOutputUpdate(noteId, paragraphId, index, appId, out.getType(), new String(out.toByteArray()));
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private ApplicationContext getApplicationContext(HeliumPackage packageInfo, String noteId, String paragraphId, String applicationInstanceId) {
        InterpreterOutput out = this.createAppOutput(noteId, paragraphId, applicationInstanceId);
        return new ApplicationContext(noteId, paragraphId, applicationInstanceId, new HeliumAppAngularObjectRegistry(this.angularObjectRegistry, noteId, applicationInstanceId), out);
    }

    @Override
    public RemoteApplicationResult loadApplication(String applicationInstanceId, String packageInfo, String noteId, String paragraphId) throws InterpreterRPCException, TException {
        if (this.runningApplications.containsKey(applicationInstanceId)) {
            LOGGER.warn("Application instance {} is already running", (Object)applicationInstanceId);
            return new RemoteApplicationResult(true, "");
        }
        HeliumPackage pkgInfo = HeliumPackage.fromJson(packageInfo);
        ApplicationContext context = this.getApplicationContext(pkgInfo, noteId, paragraphId, applicationInstanceId);
        try {
            Application app = null;
            LOGGER.info("Loading application {}({}), artifact={}, className={} into note={}, paragraph={}", new Object[]{pkgInfo.getName(), applicationInstanceId, pkgInfo.getArtifact(), pkgInfo.getClassName(), noteId, paragraphId});
            app = this.appLoader.load(pkgInfo, context);
            this.runningApplications.put(applicationInstanceId, new RunningApplication(pkgInfo, app, noteId, paragraphId));
            return new RemoteApplicationResult(true, "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new RemoteApplicationResult(false, e.getMessage());
        }
    }

    @Override
    public RemoteApplicationResult unloadApplication(String applicationInstanceId) throws InterpreterRPCException, TException {
        RunningApplication runningApplication = this.runningApplications.remove(applicationInstanceId);
        if (runningApplication != null) {
            try {
                LOGGER.info("Unloading application {}", (Object)applicationInstanceId);
                runningApplication.app.unload();
            }
            catch (ApplicationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return new RemoteApplicationResult(false, e.getMessage());
            }
        }
        return new RemoteApplicationResult(true, "");
    }

    @Override
    public RemoteApplicationResult runApplication(String applicationInstanceId) throws InterpreterRPCException, TException {
        LOGGER.info("run application {}", (Object)applicationInstanceId);
        RunningApplication runningApp = this.runningApplications.get(applicationInstanceId);
        if (runningApp == null) {
            LOGGER.error("Application instance {} not exists", (Object)applicationInstanceId);
            return new RemoteApplicationResult(false, "Application instance does not exists");
        }
        ApplicationContext context = runningApp.app.context();
        try {
            context.out.clear();
            context.out.setType(InterpreterResult.Type.ANGULAR);
            ResourceSet resource = this.appLoader.findRequiredResourceSet(runningApp.pkg.getResources(), context.getNoteId(), context.getParagraphId());
            for (Resource res : resource) {
                System.err.println("Resource " + res.get());
            }
            runningApp.app.run(resource);
            context.out.flush();
            InterpreterResultMessageOutput out = context.out.getOutputAt(0);
            this.intpEventClient.onAppOutputUpdate(context.getNoteId(), context.getParagraphId(), 0, applicationInstanceId, out.getType(), new String(out.toByteArray()));
            return new RemoteApplicationResult(true, "");
        }
        catch (IOException | ApplicationException e) {
            return new RemoteApplicationResult(false, e.getMessage());
        }
    }

    private static class RunningApplication {
        public final Application app;
        public final HeliumPackage pkg;
        public final String noteId;
        public final String paragraphId;

        RunningApplication(HeliumPackage pkg, Application app, String noteId, String paragraphId) {
            this.app = app;
            this.pkg = pkg;
            this.noteId = noteId;
            this.paragraphId = paragraphId;
        }
    }

    public static class InterpretJob
    extends Job<InterpreterResult> {
        private Interpreter interpreter;
        private String script;
        private InterpreterContext context;
        private Map<String, Object> infos;
        private InterpreterResult results;

        public InterpretJob(String jobId, String jobName, JobListener listener, Interpreter interpreter, String script, InterpreterContext context) {
            super(jobId, jobName, listener);
            this.interpreter = interpreter;
            this.script = script;
            this.context = context;
        }

        @Override
        public InterpreterResult getReturn() {
            return this.results;
        }

        @Override
        public int progress() {
            return 0;
        }

        @Override
        public Map<String, Object> info() {
            if (this.infos == null) {
                this.infos = new HashMap<String, Object>();
            }
            return this.infos;
        }

        private void processInterpreterHooks(final String noteId) {
            InterpreterHookListener hookListener = new InterpreterHookListener(){

                @Override
                public void onPreExecute(String script) {
                    String cmdDev = interpreter.getHook(noteId, InterpreterHookRegistry.HookType.PRE_EXEC_DEV.getName());
                    String cmdUser = interpreter.getHook(noteId, InterpreterHookRegistry.HookType.PRE_EXEC.getName());
                    List<String> cmds = Arrays.asList(cmdDev, cmdUser);
                    for (String cmd : cmds) {
                        if (cmd == null) continue;
                        script = cmd + "\n" + (String)script;
                    }
                    script = script;
                }

                @Override
                public void onPostExecute(String script) {
                    String cmdDev = interpreter.getHook(noteId, InterpreterHookRegistry.HookType.POST_EXEC_DEV.getName());
                    String cmdUser = interpreter.getHook(noteId, InterpreterHookRegistry.HookType.POST_EXEC.getName());
                    List<String> cmds = Arrays.asList(cmdUser, cmdDev);
                    for (String cmd : cmds) {
                        if (cmd == null) continue;
                        script = (String)script + "\n" + cmd;
                    }
                    script = script;
                }
            };
            hookListener.onPreExecute(this.script);
            hookListener.onPostExecute(this.script);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InterpreterResult jobRun() throws Throwable {
            ClassLoader currentThreadContextClassloader = Thread.currentThread().getContextClassLoader();
            try {
                InterpreterContext.set(this.context);
                this.context.out.clear();
                InterpreterResult result = null;
                LazyOpenInterpreter lazy = (LazyOpenInterpreter)this.interpreter;
                if (!lazy.isOpen()) {
                    lazy.open();
                    result = lazy.executePrecode(this.context);
                }
                if (result == null || result.code() == InterpreterResult.Code.SUCCESS) {
                    this.processInterpreterHooks(this.context.getNoteId());
                    this.processInterpreterHooks(null);
                    LOGGER.debug("Script after hooks: {}", (Object)this.script);
                    result = this.interpreter.interpret(this.script, this.context);
                }
                this.context.out.flush();
                List<InterpreterResultMessage> resultMessages = this.context.out.toInterpreterResultMessage();
                for (InterpreterResultMessage resultMessage : result.message()) {
                    if (StringUtils.isBlank((CharSequence)resultMessage.getData())) continue;
                    resultMessages.add(resultMessage);
                }
                ArrayList<String> stringResult = new ArrayList<String>();
                for (InterpreterResultMessage msg : resultMessages) {
                    if (msg.getType() == InterpreterResult.Type.IMG) {
                        LOGGER.debug("InterpreterResultMessage: IMAGE_DATA");
                    } else {
                        LOGGER.debug("InterpreterResultMessage: {}", (Object)msg);
                    }
                    stringResult.add(msg.getData());
                }
                if (this.context.getLocalProperties().containsKey("saveAs")) {
                    if (stringResult.size() == 1) {
                        LOGGER.info("Saving result into ResourcePool as single string: " + this.context.getLocalProperties().get("saveAs"));
                        this.context.getResourcePool().put(this.context.getLocalProperties().get("saveAs"), stringResult.get(0));
                    } else {
                        LOGGER.info("Saving result into ResourcePool as string list: " + this.context.getLocalProperties().get("saveAs"));
                        this.context.getResourcePool().put(this.context.getLocalProperties().get("saveAs"), stringResult);
                    }
                }
                InterpreterResult interpreterResult = new InterpreterResult(result.code(), resultMessages);
                return interpreterResult;
            }
            catch (Throwable e) {
                InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, ExceptionUtils.getStackTrace((Throwable)e));
                return interpreterResult;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentThreadContextClassloader);
                InterpreterContext.remove();
            }
        }

        @Override
        protected boolean jobAbort() {
            return false;
        }

        @Override
        public void setResult(InterpreterResult result) {
            this.results = result;
        }
    }

    class InterpretJobListener
    implements JobListener {
        InterpretJobListener() {
        }

        @Override
        public void onProgressUpdate(Job<?> job, int progress) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStatusChange(Job<?> job, Job.Status before, Job.Status after) {
            InterpretJobListener interpretJobListener = this;
            synchronized (interpretJobListener) {
                this.notifyAll();
            }
        }
    }

    class ShutdownThread
    extends Thread {
        private final String cause;
        public static final String CAUSE_SHUTDOWN_HOOK = "ShutdownHook";
        public static final String CAUSE_SHUTDOWN_CALL = "ShutdownCall";

        public ShutdownThread(String cause) {
            super("ShutdownThread");
            this.cause = cause;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.info("Shutting down...");
            LOGGER.info("Shutdown initialized by {}", (Object)this.cause);
            if (RemoteInterpreterServer.this.interpreterGroup != null) {
                InterpreterGroup interpreterGroup = RemoteInterpreterServer.this.interpreterGroup;
                synchronized (interpreterGroup) {
                    for (List<Interpreter> session : RemoteInterpreterServer.this.interpreterGroup.values()) {
                        for (Interpreter interpreter : session) {
                            try {
                                interpreter.close();
                            }
                            catch (InterpreterException e) {
                                LOGGER.warn("Fail to close interpreter", (Throwable)e);
                            }
                        }
                    }
                }
            }
            if (!RemoteInterpreterServer.this.isTest) {
                SchedulerFactory.singleton().destroy();
                ExecutorFactory.singleton().shutdownAll();
            }
            if ("yarn".equals(RemoteInterpreterServer.this.launcherEnv)) {
                try {
                    YarnUtils.unregister(true, "");
                }
                catch (Exception e) {
                    LOGGER.error("Fail to unregister yarn app", (Throwable)e);
                }
            }
            if (RemoteInterpreterServer.this.intpEventClient != null && CAUSE_SHUTDOWN_HOOK.equals(this.cause)) {
                try {
                    LOGGER.info("Unregister interpreter process");
                    RemoteInterpreterServer.this.intpEventClient.unRegisterInterpreterProcess();
                }
                catch (Exception e) {
                    LOGGER.error("Fail to unregister remote interpreter process", (Throwable)e);
                }
            }
            RemoteInterpreterServer.this.server.stop();
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < 2100L && RemoteInterpreterServer.this.server.isServing()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    LOGGER.info("Exception in RemoteInterpreterServer while shutdown, Thread.sleep", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if (RemoteInterpreterServer.this.server.isServing() && RemoteInterpreterServer.this.isForceShutdown) {
                LOGGER.info("Force shutting down");
                System.exit(1);
            }
            LOGGER.info("Shutting down");
        }
    }

    class RegisterRunnable
    implements Runnable {
        RegisterRunnable() {
        }

        @Override
        public void run() {
            LOGGER.info("Start registration");
            while (!Thread.currentThread().isInterrupted() && RemoteInterpreterServer.this.server != null && !RemoteInterpreterServer.this.server.isServing()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.info("InterruptedException received", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if (!Thread.currentThread().isInterrupted()) {
                RegisterInfo registerInfo = new RegisterInfo(RemoteInterpreterServer.this.host, RemoteInterpreterServer.this.port, RemoteInterpreterServer.this.interpreterGroupId);
                try {
                    RemoteInterpreterServer.this.intpEventClient = new RemoteInterpreterEventClient(RemoteInterpreterServer.this.intpEventServerHost, RemoteInterpreterServer.this.intpEventServerPort, 10);
                    LOGGER.info("Registering interpreter process");
                    RemoteInterpreterServer.this.intpEventClient.registerInterpreterProcess(registerInfo);
                    LOGGER.info("Registered interpreter process");
                }
                catch (Exception e) {
                    LOGGER.error("Error while registering interpreter: {}, cause: {}", (Object)registerInfo, (Object)e);
                    try {
                        RemoteInterpreterServer.this.shutdown();
                    }
                    catch (Exception e1) {
                        LOGGER.warn("Exception occurs while shutting down", (Throwable)e1);
                    }
                }
            }
            if (RemoteInterpreterServer.this.launcherEnv != null && "yarn".endsWith(RemoteInterpreterServer.this.launcherEnv)) {
                try {
                    YarnUtils.register(RemoteInterpreterServer.this.host, RemoteInterpreterServer.this.port);
                    ScheduledExecutorService yarnHeartbeat = ExecutorFactory.singleton().createOrGetScheduled("RM-Heartbeat", 1);
                    yarnHeartbeat.scheduleAtFixedRate(YarnUtils::heartbeat, 0L, 1L, TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    LOGGER.error("Fail to register yarn app", (Throwable)e);
                }
            }
            LOGGER.info("Registration finished");
        }
    }
}

