/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InvalidHookException;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;

public class LazyOpenInterpreter
extends Interpreter
implements WrappedInterpreter {
    private Interpreter intp;
    volatile boolean opened = false;

    public LazyOpenInterpreter(Interpreter intp) {
        super(new Properties());
        this.intp = intp;
    }

    @Override
    public Interpreter getInnerInterpreter() {
        return this.intp;
    }

    @Override
    public void setProperties(Properties properties) {
        this.intp.setProperties(properties);
    }

    @Override
    public Properties getProperties() {
        return this.intp.getProperties();
    }

    @Override
    public String getProperty(String key) {
        return this.intp.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws InterpreterException {
        if (this.opened) {
            return;
        }
        Interpreter interpreter = this.intp;
        synchronized (interpreter) {
            if (!this.opened) {
                try {
                    this.intp.open();
                    this.opened = true;
                }
                catch (Throwable e) {
                    this.intp.close();
                    throw new InterpreterException(e);
                }
            }
        }
    }

    @Override
    public InterpreterResult executePrecode(InterpreterContext interpreterContext) throws InterpreterException {
        return this.intp.executePrecode(interpreterContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws InterpreterException {
        Interpreter interpreter = this.intp;
        synchronized (interpreter) {
            if (this.opened) {
                this.intp.close();
                this.opened = false;
            }
        }
    }

    public boolean isOpen() {
        return this.opened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        this.open();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            InterpreterResult interpreterResult = this.intp.interpret(st, context);
            return interpreterResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Override
    public void cancel(InterpreterContext context) throws InterpreterException {
        if (this.opened) {
            this.intp.cancel(context);
        }
    }

    @Override
    public Interpreter.FormType getFormType() throws InterpreterException {
        return this.intp.getFormType();
    }

    @Override
    public int getProgress(InterpreterContext context) throws InterpreterException {
        if (this.opened) {
            return this.intp.getProgress(context);
        }
        return 0;
    }

    @Override
    public Scheduler getScheduler() {
        return this.intp.getScheduler();
    }

    @Override
    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) throws InterpreterException {
        this.open();
        return this.intp.completion(buf, cursor, interpreterContext);
    }

    @Override
    public String getClassName() {
        return this.intp.getClassName();
    }

    @Override
    public InterpreterGroup getInterpreterGroup() {
        return this.intp.getInterpreterGroup();
    }

    @Override
    public void setInterpreterGroup(InterpreterGroup interpreterGroup) {
        this.intp.setInterpreterGroup(interpreterGroup);
    }

    @Override
    public URL[] getClassloaderUrls() {
        return this.intp.getClassloaderUrls();
    }

    @Override
    public void setClassloaderUrls(URL[] urls) {
        this.intp.setClassloaderUrls(urls);
    }

    @Override
    public void registerHook(String noteId, String event, String cmd) throws InvalidHookException {
        this.intp.registerHook(noteId, event, cmd);
    }

    @Override
    public void registerHook(String event, String cmd) throws InvalidHookException {
        this.intp.registerHook(event, cmd);
    }

    @Override
    public String getHook(String noteId, String event) {
        return this.intp.getHook(noteId, event);
    }

    @Override
    public String getHook(String event) {
        return this.intp.getHook(event);
    }

    @Override
    public void unregisterHook(String noteId, String event) {
        this.intp.unregisterHook(noteId, event);
    }

    @Override
    public void unregisterHook(String event) {
        this.intp.unregisterHook(event);
    }

    @Override
    public void setUserName(String userName) {
        this.intp.setUserName(userName);
    }

    @Override
    public void setZeppelinConfiguration(ZeppelinConfiguration zConf) {
        this.intp.setZeppelinConfiguration(zConf);
    }

    @Override
    public String getUserName() {
        return this.intp.getUserName();
    }
}

