/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.helium.HeliumRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeliumLocalRegistry
extends HeliumRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeliumLocalRegistry.class);
    private static final Gson gson = new Gson();

    public HeliumLocalRegistry(String name, String uri) {
        super(name, uri);
    }

    @Override
    public synchronized List<HeliumPackage> getAll() throws IOException {
        LinkedList<HeliumPackage> result = new LinkedList<HeliumPackage>();
        File file = new File(this.uri());
        File[] files = file.listFiles();
        if (files == null) {
            return result;
        }
        for (File f : files) {
            HeliumPackage pkgInfo;
            if (f.getName().startsWith(".") || (pkgInfo = this.readPackageInfo(f)) == null) continue;
            result.add(pkgInfo);
        }
        return result;
    }

    private HeliumPackage readPackageInfo(File f) {
        try {
            JsonReader reader = new JsonReader((Reader)new StringReader(FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8)));
            reader.setLenient(true);
            return (HeliumPackage)gson.fromJson(reader, HeliumPackage.class);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

