/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util.iterator;

import java.util.NoSuchElementException;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.MapFilter;
import org.apache.jena.util.iterator.NiceIterator;

public class MapFilterIterator<T, X>
extends NiceIterator<X>
implements ExtendedIterator<X> {
    MapFilter<T, X> f;
    X current;
    boolean dead;
    ClosableIterator<T> underlying;

    public MapFilterIterator(MapFilter<T, X> fl, ExtendedIterator<T> e2) {
        this.f = fl;
        this.current = null;
        this.dead = false;
        this.underlying = e2;
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        while (this.underlying.hasNext()) {
            this.current = this.f.accept(this.underlying.next());
            if (this.current == null) continue;
            return true;
        }
        this.current = null;
        this.dead = true;
        return false;
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    @Override
    public synchronized void remove() {
        if (this.current != null || this.dead) {
            throw new IllegalStateException("FilterIterator does not permit calls to hasNext between calls to next and remove.");
        }
        this.underlying.remove();
    }

    @Override
    public synchronized X next() {
        if (this.hasNext()) {
            X r = this.current;
            this.current = null;
            return r;
        }
        throw new NoSuchElementException();
    }
}

