/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.path.eval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterRoot;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.eval.PathEval;
import org.apache.jena.sparql.path.eval.PathEvaluator;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.graph.GraphContainerUtils;
import org.apache.jena.sparql.util.graph.GraphList;
import org.apache.jena.sparql.vocabulary.ListPFunction;
import org.apache.jena.vocabulary.RDFS;

public abstract class PathEngine {
    private final boolean doingRDFSmember;
    private final boolean doingListMember;
    private final Graph graph;
    private final Context context;
    private final PropertyFunctionRegistry registry;
    private static Binding binding = BindingFactory.binding();
    private static Node RDFSmember = RDFS.Nodes.member;
    private static Node ListMember = ListPFunction.nListMember;

    protected PathEngine(Graph graph, Context context) {
        boolean doingRDFSmember$ = false;
        boolean doingListMember$ = false;
        PropertyFunctionRegistry registry$ = null;
        if ((context == null || context.isTrueOrUndef(ARQ.propertyFunctions)) && (registry$ = PropertyFunctionRegistry.chooseRegistry(context)) != null) {
            doingRDFSmember$ = registry$.get(RDFSmember.getURI()) != null;
            doingListMember$ = registry$.get(ListMember.getURI()) != null;
        }
        this.registry = registry$;
        this.doingRDFSmember = doingRDFSmember$;
        this.doingListMember = doingListMember$;
        this.graph = graph;
        this.context = context;
    }

    protected final Iter<Node> eval(Path path, Node node) {
        return PathEval.eval$(this.graph, node, path, this);
    }

    protected final void eval(Path path, Node node, Collection<Node> output) {
        PathEval.eval$(this.graph, node, path, this, output);
    }

    protected abstract void flipDirection();

    protected abstract boolean direction();

    protected final Iterator<Node> doOne(Node node, Node property) {
        Iter<Node> iter2 = null;
        if (this.direction()) {
            Iter<Triple> iter1 = Iter.iter(this.graphFind(node, property, Node.ANY));
            iter2 = iter1.map(Triple::getObject);
        } else {
            Iter<Triple> iter1 = Iter.iter(this.graphFind(Node.ANY, property, node));
            iter2 = iter1.map(Triple::getSubject);
        }
        return iter2;
    }

    protected abstract void doSeq(Path var1, Path var2, Node var3, Collection<Node> var4);

    protected abstract void doAlt(Path var1, Path var2, Node var3, Collection<Node> var4);

    protected abstract void doZeroOrMore(Path var1, Node var2, Collection<Node> var3);

    protected abstract void doOneOrMore(Path var1, Node var2, Collection<Node> var3);

    protected abstract void doZeroOrOne(Path var1, Node var2, Collection<Node> var3);

    protected abstract void doNegatedPropertySet(P_NegPropSet var1, Node var2, Collection<Node> var3);

    protected void doZeroOrMoreN(Path pathStep, Node node, Collection<Node> output) {
        this.doZeroOrMore(pathStep, node, output);
    }

    protected void doOneOrMoreN(Path pathStep, Node node, Collection<Node> output) {
        this.doOneOrMore(pathStep, node, output);
    }

    protected abstract void doZero(Path var1, Node var2, Collection<Node> var3);

    protected abstract void doFixedLengthPath(Path var1, Node var2, long var3, Collection<Node> var5);

    protected abstract void doMultiLengthPath(Path var1, Node var2, long var3, long var5, Collection<Node> var7);

    protected final void fill(Iterator<Node> iter, Collection<Node> output) {
        while (iter.hasNext()) {
            output.add(iter.next());
        }
    }

    protected static long dec(long x) {
        return x <= 0L ? x : x - 1L;
    }

    protected Iterator<Node> stepExcludeForwards(Node node, List<Node> excludedNodes) {
        Iter<Triple> iter1 = this.forwardLinks(node, excludedNodes);
        Iter<Node> r1 = iter1.map(Triple::getObject);
        return r1;
    }

    protected Iterator<Node> stepExcludeBackwards(Node node, List<Node> excludedNodes) {
        Iter<Triple> iter1 = this.backwardLinks(node, excludedNodes);
        Iter<Node> r1 = iter1.map(Triple::getSubject);
        return r1;
    }

    protected Iter<Triple> forwardLinks(Node x, Collection<Node> excludeProperties) {
        Iter<Triple> iter1 = Iter.iter(this.graphFind(x, Node.ANY, Node.ANY));
        if (excludeProperties != null) {
            iter1 = iter1.filter(new PathEvaluator.FilterExclude(excludeProperties));
        }
        return iter1;
    }

    protected Iter<Triple> backwardLinks(Node x, Collection<Node> excludeProperties) {
        Iter<Triple> iter1 = Iter.iter(this.graphFind(Node.ANY, Node.ANY, x));
        if (excludeProperties != null) {
            iter1 = iter1.filter(new PathEvaluator.FilterExclude(excludeProperties));
        }
        return iter1;
    }

    protected Iterator<Triple> graphFind(Node s, Node p, Node o) {
        return this.graphFind(this.graph, s, p, o, this.context);
    }

    private Iterator<Triple> graphFind(Graph graph, Node s, Node p, Node o, Context context) {
        if (this.doingRDFSmember && RDFSmember.equals(p)) {
            return GraphContainerUtils.rdfsMember(graph, s, o);
        }
        if (this.doingListMember && ListMember.equals(p)) {
            return GraphList.listMember(graph, s, o);
        }
        return this.graphFind2(graph, s, p, o, context);
    }

    private Iterator<Triple> graphFind2(Graph graph, Node s, Node p, Node o, Context context) {
        PropertyFunctionFactory f;
        if (p != null && p.isURI() && this.registry != null && (f = this.registry.get(p.getURI())) != null) {
            return this.graphFindWorker(graph, s, f, p, o, context);
        }
        return graph.find(s, p, o);
    }

    private Iterator<Triple> graphFindWorker(Graph graph, Node s, PropertyFunctionFactory f, Node p, Node o, Context context) {
        PropertyFunction pf = f.create(p.getURI());
        PropFuncArg sv = PathEngine.arg(s, "S");
        PropFuncArg ov = PathEngine.arg(o, "O");
        QueryIterator r = QueryIterRoot.create(new ExecutionContext(context, graph, null, null));
        QueryIterator qIter = pf.exec(r, sv, p, ov, new ExecutionContext(ARQ.getContext(), graph, null, null));
        if (!qIter.hasNext()) {
            return Iter.nullIterator();
        }
        ArrayList<Triple> array = new ArrayList<Triple>();
        while (qIter.hasNext()) {
            Binding b = (Binding)qIter.next();
            Node st = PathEngine.value(sv, b);
            Node ot = PathEngine.value(ov, b);
            array.add(Triple.create(st, p, ot));
        }
        return array.iterator();
    }

    private static PropFuncArg arg(Node x, String name) {
        if (x == null || Node.ANY.equals(x)) {
            return new PropFuncArg(Var.alloc(name));
        }
        return new PropFuncArg(x);
    }

    private static Node value(PropFuncArg arg, Binding b) {
        Node x = arg.getArg();
        if (!Var.isVar(x)) {
            return x;
        }
        return b.get(Var.alloc(x));
    }
}

