/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.Deque;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.AlgebraQuad;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.ExprVar;

public class TransformQuadBlockGraph
extends TransformCopy {
    private Deque<AlgebraQuad.QuadSlot> tracker;
    private OpVisitor beforeVisitor;
    private OpVisitor afterVisitor;

    public TransformQuadBlockGraph(Deque<AlgebraQuad.QuadSlot> tracker, OpVisitor before, OpVisitor after) {
        this.tracker = tracker;
        this.beforeVisitor = before;
        this.afterVisitor = after;
    }

    private Node getNode() {
        return this.tracker.peek().rewriteGraphName;
    }

    @Override
    public Op transform(OpGraph opGraph, Op op) {
        boolean noPattern = false;
        AlgebraQuad.QuadSlot qSlot = this.tracker.peek();
        Node actualName = qSlot.actualGraphName;
        Node rewriteName = qSlot.rewriteGraphName;
        if (OpBGP.isBGP(op)) {
            if (((OpBGP)op).getPattern().isEmpty()) {
                noPattern = true;
            }
        } else if (op instanceof OpTable && ((OpTable)op).isJoinIdentity()) {
            noPattern = true;
        }
        if (noPattern) {
            return new OpDatasetNames(opGraph.getNode());
        }
        if (actualName != rewriteName) {
            op = OpAssign.assign(op, Var.alloc(actualName), new ExprVar(rewriteName));
        }
        return op;
    }

    @Override
    public Op transform(OpPropFunc opPropFunc, Op subOp) {
        if (opPropFunc.getSubOp() != subOp) {
            opPropFunc = new OpPropFunc(opPropFunc.getProperty(), opPropFunc.getSubjectArgs(), opPropFunc.getObjectArgs(), subOp);
        }
        return new OpGraph(this.getNode(), opPropFunc);
    }

    @Override
    public Op transform(OpPath opPath) {
        return new OpGraph(this.getNode(), opPath);
    }

    @Override
    public Op transform(OpBGP opBGP) {
        return OpQuadBlock.create(this.getNode(), opBGP.getPattern());
    }

    @Override
    public Op transform(OpExt opExt) {
        return opExt.apply(this, this.beforeVisitor, this.afterVisitor);
    }
}

