/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset.rw;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetReader;
import org.apache.jena.riot.resultset.ResultSetReaderFactory;
import org.apache.jena.riot.resultset.rw.JSONResultsKW;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.vocabulary.RDF;

public class ResultSetReaderJSON
implements ResultSetReader {
    public static final ResultSetReaderFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.SPARQLResultSetJSON)) {
            throw new ResultSetException("ResultSet for JSON asked for a " + lang);
        }
        return new ResultSetReaderJSON();
    };

    private ResultSetReaderJSON() {
    }

    @Override
    public SPARQLResult readAny(InputStream in, Context context) {
        return ResultSetReaderJSON.process(in, null, context);
    }

    private static SPARQLResult process(InputStream in, Model model, Context context) {
        if (context == null) {
            context = ARQ.getContext();
        }
        RS_JSON exec = new RS_JSON(context);
        exec.parse(in);
        if (model == null) {
            model = GraphFactory.makeJenaDefaultModel();
        }
        if (exec.rows != null) {
            QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(exec.rows.iterator());
            ResultSetStream rs = new ResultSetStream(Var.varNames(exec.vars), model, qIter);
            return new SPARQLResult(rs);
        }
        return new SPARQLResult(exec.booleanResult);
    }

    static class RS_JSON {
        final Context context;
        Boolean booleanResult = null;
        List<Binding> rows = null;
        List<Var> vars = null;
        final LabelToNode labelMap;

        RS_JSON(Context context) {
            this.context = context;
            boolean inputGraphBNodeLabels = context != null && context.isTrue(ARQ.inputGraphBNodeLabels);
            this.labelMap = inputGraphBNodeLabels ? SyntaxLabels.createLabelToNodeAsGiven() : SyntaxLabels.createLabelToNode();
            this.rows = null;
        }

        private void parse(InputStream in) {
            JsonObject obj = JSON.parse(in);
            if (obj.hasKey(JSONResultsKW.kBoolean)) {
                RS_JSON.checkContains(obj, true, true, JSONResultsKW.kHead, JSONResultsKW.kBoolean);
                this.booleanResult = obj.get(JSONResultsKW.kBoolean).getAsBoolean().value();
                this.rows = null;
                return;
            }
            this.rows = new ArrayList<Binding>(1000);
            RS_JSON.checkContains(obj, true, true, JSONResultsKW.kHead, JSONResultsKW.kResults);
            if (!obj.get(JSONResultsKW.kHead).isObject()) {
                throw new ResultSetException("Key 'head' must have a JSON object as value: found: " + obj.get(JSONResultsKW.kHead));
            }
            JsonObject head = obj.get(JSONResultsKW.kHead).getAsObject();
            if (head.hasKey(JSONResultsKW.kLink)) {
                ArrayList<String> links = new ArrayList<String>();
                if (head.get(JSONResultsKW.kLink).isString()) {
                    Log.warn(this, "Link field is a string, should be an array of strings");
                    links.add(head.get(JSONResultsKW.kLink).getAsString().value());
                } else {
                    if (!head.get(JSONResultsKW.kLink).isArray()) {
                        throw new ResultSetException("Key 'link' must have be an array: found: " + obj.get(JSONResultsKW.kLink));
                    }
                    for (JsonValue v : head.get(JSONResultsKW.kLink).getAsArray()) {
                        if (!v.isString()) {
                            throw new ResultSetException("Key 'link' must have be an array of strings: found: " + v);
                        }
                        links.add(v.getAsString().value());
                    }
                }
            }
            this.vars = RS_JSON.parseVars(head);
            JsonObject results = obj.get(JSONResultsKW.kResults).getAsObject();
            if (!results.get(JSONResultsKW.kBindings).isArray()) {
                throw new ResultSetException("'bindings' must be an array");
            }
            JsonArray array = results.get(JSONResultsKW.kBindings).getAsArray();
            Iterator<JsonValue> iter = array.iterator();
            while (iter.hasNext()) {
                BindingMap b = BindingFactory.create();
                JsonValue v = iter.next();
                if (!v.isObject()) {
                    throw new ResultSetException("Entry in 'bindings' array must be an object {}");
                }
                JsonObject x = v.getAsObject();
                Set<String> varNames = x.keys();
                for (String vn : varNames) {
                    JsonValue vt = x.get(vn);
                    if (!vt.isObject()) {
                        throw new ResultSetException("Binding for variable '" + vn + "' is not a JSON object: " + vt);
                    }
                    Node n = RS_JSON.parseOneTerm(vt.getAsObject(), this.labelMap);
                    b.add(Var.alloc(vn), n);
                }
                this.rows.add(b);
            }
        }

        private static List<Var> parseVars(JsonObject obj) {
            if (!obj.get(JSONResultsKW.kVars).isArray()) {
                throw new ResultSetException("Key 'vars' must be a JSON array");
            }
            JsonArray a = obj.get(JSONResultsKW.kVars).getAsArray();
            Iterator<JsonValue> iter = a.iterator();
            ArrayList<Var> vars = new ArrayList<Var>();
            while (iter.hasNext()) {
                JsonValue v = iter.next();
                if (!v.isString()) {
                    throw new ResultSetException("Entries in vars array must be strings");
                }
                Var var = Var.alloc(v.getAsString().value());
                vars.add(var);
            }
            return vars;
        }

        private static Node parseOneTerm(JsonObject term, LabelToNode labelMap) {
            RS_JSON.checkContains(term, false, false, JSONResultsKW.kType, JSONResultsKW.kValue, JSONResultsKW.kXmlLang, JSONResultsKW.kDatatype);
            String type = RS_JSON.stringOrNull(term, JSONResultsKW.kType);
            String v = RS_JSON.stringOrNull(term, JSONResultsKW.kValue);
            if (JSONResultsKW.kUri.equals(type)) {
                RS_JSON.checkContains(term, false, true, JSONResultsKW.kType, JSONResultsKW.kValue);
                String uri = v;
                Node n = NodeFactory.createURI(v);
                return n;
            }
            if (JSONResultsKW.kLiteral.equals(type) || JSONResultsKW.kTypedLiteral.equals(type)) {
                String lang = RS_JSON.stringOrNull(term, JSONResultsKW.kXmlLang);
                String dtStr = RS_JSON.stringOrNull(term, JSONResultsKW.kDatatype);
                if (lang != null && dtStr != null && !dtStr.equals(RDF.dtLangString.getURI())) {
                    throw new ResultSetException("Both language and datatype defined, datatype is not rdf:langString:\n" + term);
                }
                RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtStr);
                return NodeFactory.createLiteral(v, lang, dt);
            }
            if (JSONResultsKW.kBnode.equals(type)) {
                return (Node)labelMap.get(null, v);
            }
            throw new ResultSetException("Object key not recognized as valid for an RDF term: " + term);
        }

        private static String stringOrNull(JsonObject obj, String key) {
            JsonValue v = obj.get(key);
            if (v == null) {
                return null;
            }
            if (!v.isString()) {
                throw new ResultSetException("Not a string: key: " + key);
            }
            return v.getAsString().value();
        }

        private static void checkContains(JsonObject term, boolean allowUndefinedKeys, boolean requireAllExpectedKeys, String ... keys) {
            List<String> expectedKeys = Arrays.asList(keys);
            HashSet<String> declared = new HashSet<String>();
            for (String k : term.keys()) {
                if (!expectedKeys.contains(k) && !allowUndefinedKeys) {
                    throw new ResultSetException("Expected only object keys " + Arrays.asList(keys) + " but encountered '" + k + "'");
                }
                if (!expectedKeys.contains(k)) continue;
                declared.add(k);
            }
            if (requireAllExpectedKeys && declared.size() < expectedKeys.size()) {
                throw new ResultSetException("One or more of the required keys " + expectedKeys + " was not found");
            }
        }
    }
}

