/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.dv.xs;

import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.jena.ext.xerces.impl.dv.ValidationContext;
import org.apache.jena.ext.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.jena.ext.xerces.impl.dv.xs.SchemaDateTimeException;

public class YearMonthDV
extends AbstractDateTimeDV {
    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return this.parse(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "gYearMonth"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String str2) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData date2 = new AbstractDateTimeDV.DateTimeData(str2, this);
        int len = str2.length();
        int end = this.getYearMonth(str2, 0, len, date2);
        date2.day = 1;
        this.parseTimeZone(str2, end, len, date2);
        this.validateDateTime(date2);
        this.saveUnnormalized(date2);
        if (date2.utc != 0 && date2.utc != 90) {
            this.normalize(date2);
        }
        date2.position = 0;
        return date2;
    }

    @Override
    protected String dateToString(AbstractDateTimeDV.DateTimeData date2) {
        StringBuffer message = new StringBuffer(25);
        this.append(message, date2.year, 4);
        message.append('-');
        this.append(message, date2.month, 2);
        this.append(message, (char)date2.utc, 0);
        return message.toString();
    }

    @Override
    protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData date2) {
        return datatypeFactory.newXMLGregorianCalendar(date2.unNormYear, date2.unNormMonth, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, date2.hasTimeZone() ? date2.timezoneHr * 60 + date2.timezoneMin : Integer.MIN_VALUE);
    }
}

