/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class LocaleUtils {
    private static final char UNDERSCORE = '_';
    private static final String UNDETERMINED = "und";
    private static final char DASH = '-';
    private static final ConcurrentMap<String, List<Locale>> cLanguagesByCountry = new ConcurrentHashMap<String, List<Locale>>();
    private static final ConcurrentMap<String, List<Locale>> cCountriesByLanguage = new ConcurrentHashMap<String, List<Locale>>();

    public static List<Locale> availableLocaleList() {
        return SyncAvoid.AVAILABLE_LOCALE_LIST;
    }

    private static List<Locale> availableLocaleList(Predicate<Locale> predicate) {
        return LocaleUtils.availableLocaleList().stream().filter(predicate).collect(Collectors.toList());
    }

    public static Set<Locale> availableLocaleSet() {
        return SyncAvoid.AVAILABLE_LOCALE_SET;
    }

    public static List<Locale> countriesByLanguage(String languageCode) {
        if (languageCode == null) {
            return Collections.emptyList();
        }
        return cCountriesByLanguage.computeIfAbsent(languageCode, lc -> Collections.unmodifiableList(LocaleUtils.availableLocaleList(locale -> languageCode.equals(locale.getLanguage()) && !locale.getCountry().isEmpty() && locale.getVariant().isEmpty())));
    }

    public static boolean isAvailableLocale(Locale locale) {
        return LocaleUtils.availableLocaleSet().contains(locale);
    }

    private static boolean isISO3166CountryCode(String str2) {
        return StringUtils.isAllUpperCase(str2) && str2.length() == 2;
    }

    private static boolean isISO639LanguageCode(String str2) {
        return StringUtils.isAllLowerCase(str2) && (str2.length() == 2 || str2.length() == 3);
    }

    public static boolean isLanguageUndetermined(Locale locale) {
        return locale == null || UNDETERMINED.equals(locale.toLanguageTag());
    }

    private static boolean isNumericAreaCode(String str2) {
        return StringUtils.isNumeric(str2) && str2.length() == 3;
    }

    public static List<Locale> languagesByCountry(String countryCode) {
        if (countryCode == null) {
            return Collections.emptyList();
        }
        return cLanguagesByCountry.computeIfAbsent(countryCode, k -> Collections.unmodifiableList(LocaleUtils.availableLocaleList(locale -> countryCode.equals(locale.getCountry()) && locale.getVariant().isEmpty())));
    }

    public static List<Locale> localeLookupList(Locale locale) {
        return LocaleUtils.localeLookupList(locale, locale);
    }

    public static List<Locale> localeLookupList(Locale locale, Locale defaultLocale) {
        ArrayList<Locale> list = new ArrayList<Locale>(4);
        if (locale != null) {
            list.add(locale);
            if (!locale.getVariant().isEmpty()) {
                list.add(new Locale(locale.getLanguage(), locale.getCountry()));
            }
            if (!locale.getCountry().isEmpty()) {
                list.add(new Locale(locale.getLanguage(), ""));
            }
            if (!list.contains(defaultLocale)) {
                list.add(defaultLocale);
            }
        }
        return Collections.unmodifiableList(list);
    }

    private static Locale parseLocale(String str2) {
        if (LocaleUtils.isISO639LanguageCode(str2)) {
            return new Locale(str2);
        }
        String[] segments = str2.indexOf(95) != -1 ? str2.split(String.valueOf('_'), -1) : str2.split(String.valueOf('-'), -1);
        String language = segments[0];
        if (segments.length == 2) {
            String country = segments[1];
            if (LocaleUtils.isISO639LanguageCode(language) && LocaleUtils.isISO3166CountryCode(country) || LocaleUtils.isNumericAreaCode(country)) {
                return new Locale(language, country);
            }
        } else if (segments.length == 3) {
            String country = segments[1];
            String variant = segments[2];
            if (LocaleUtils.isISO639LanguageCode(language) && (country.isEmpty() || LocaleUtils.isISO3166CountryCode(country) || LocaleUtils.isNumericAreaCode(country)) && !variant.isEmpty()) {
                return new Locale(language, country, variant);
            }
        }
        throw new IllegalArgumentException("Invalid locale format: " + str2);
    }

    public static Locale toLocale(Locale locale) {
        return locale != null ? locale : Locale.getDefault();
    }

    public static Locale toLocale(String str2) {
        if (str2 == null) {
            return null;
        }
        if (str2.isEmpty()) {
            return new Locale("", "");
        }
        if (str2.contains("#")) {
            throw new IllegalArgumentException("Invalid locale format: " + str2);
        }
        int len = str2.length();
        if (len < 2) {
            throw new IllegalArgumentException("Invalid locale format: " + str2);
        }
        char ch0 = str2.charAt(0);
        if (ch0 == '_' || ch0 == '-') {
            if (len < 3) {
                throw new IllegalArgumentException("Invalid locale format: " + str2);
            }
            char ch1 = str2.charAt(1);
            char ch2 = str2.charAt(2);
            if (!Character.isUpperCase(ch1) || !Character.isUpperCase(ch2)) {
                throw new IllegalArgumentException("Invalid locale format: " + str2);
            }
            if (len == 3) {
                return new Locale("", str2.substring(1, 3));
            }
            if (len < 5) {
                throw new IllegalArgumentException("Invalid locale format: " + str2);
            }
            if (str2.charAt(3) != ch0) {
                throw new IllegalArgumentException("Invalid locale format: " + str2);
            }
            return new Locale("", str2.substring(1, 3), str2.substring(4));
        }
        return LocaleUtils.parseLocale(str2);
    }

    static class SyncAvoid {
        private static final List<Locale> AVAILABLE_LOCALE_LIST;
        private static final Set<Locale> AVAILABLE_LOCALE_SET;

        SyncAvoid() {
        }

        static {
            ArrayList<Locale> list = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
            AVAILABLE_LOCALE_LIST = Collections.unmodifiableList(list);
            AVAILABLE_LOCALE_SET = Collections.unmodifiableSet(new HashSet<Locale>(list));
        }
    }
}

