/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.Address;
import com.kenai.jaffl.CallingConvention;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.annotations.IgnoreError;
import com.kenai.jaffl.annotations.SaveError;
import com.kenai.jaffl.byref.ByReference;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jffi.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InvokerUtil {
    InvokerUtil() {
    }

    static final Type getNativeReturnType(Method method2) {
        return InvokerUtil.getNativeReturnType(method2.getReturnType());
    }

    static final Type getNativeReturnType(Class type2) {
        if (Void.class.isAssignableFrom(type2) || Void.TYPE == type2) {
            return Type.VOID;
        }
        if (Boolean.class.isAssignableFrom(type2) || Boolean.TYPE == type2) {
            return Type.SINT32;
        }
        if (Byte.class.isAssignableFrom(type2) || Byte.TYPE == type2) {
            return Type.SINT8;
        }
        if (Short.class.isAssignableFrom(type2) || Short.TYPE == type2) {
            return Type.SINT16;
        }
        if (Integer.class.isAssignableFrom(type2) || Integer.TYPE == type2) {
            return Type.SINT32;
        }
        if (Long.class.isAssignableFrom(type2) || Long.TYPE == type2) {
            return Type.SINT64;
        }
        if (NativeLong.class.isAssignableFrom(type2)) {
            return Platform.getPlatform().longSize() == 32 ? Type.SINT32 : Type.SINT64;
        }
        if (Float.class.isAssignableFrom(type2) || Float.TYPE == type2) {
            return Type.FLOAT;
        }
        if (Double.class.isAssignableFrom(type2) || Double.TYPE == type2) {
            return Type.DOUBLE;
        }
        if (Enum.class.isAssignableFrom(type2)) {
            return Type.SINT32;
        }
        if (Pointer.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (Address.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (Struct.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (String.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unsupported return type: " + type2);
    }

    static final Type getNativeParameterType(Class type2) {
        if (Byte.class.isAssignableFrom(type2) || Byte.TYPE == type2) {
            return Type.SINT8;
        }
        if (Short.class.isAssignableFrom(type2) || Short.TYPE == type2) {
            return Type.SINT16;
        }
        if (Integer.class.isAssignableFrom(type2) || Integer.TYPE == type2) {
            return Type.SINT32;
        }
        if (Long.class.isAssignableFrom(type2) || Long.TYPE == type2) {
            return Type.SINT64;
        }
        if (NativeLong.class.isAssignableFrom(type2)) {
            return Platform.getPlatform().longSize() == 32 ? Type.SINT32 : Type.SINT64;
        }
        if (Float.class.isAssignableFrom(type2) || Float.TYPE == type2) {
            return Type.FLOAT;
        }
        if (Double.class.isAssignableFrom(type2) || Double.TYPE == type2) {
            return Type.DOUBLE;
        }
        if (Boolean.class.isAssignableFrom(type2) || Boolean.TYPE == type2) {
            return Type.SINT32;
        }
        if (Enum.class.isAssignableFrom(type2)) {
            return Type.SINT32;
        }
        if (Pointer.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (Address.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (Struct.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (Buffer.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (CharSequence.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (ByReference.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (type2.isArray()) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + type2);
    }

    public static final boolean requiresErrno(Method method2) {
        boolean saveError = true;
        for (Annotation a : method2.getAnnotations()) {
            if (a instanceof IgnoreError) {
                saveError = false;
                continue;
            }
            if (!(a instanceof SaveError)) continue;
            saveError = true;
        }
        return saveError;
    }

    public static final com.kenai.jffi.CallingConvention getCallingConvention(Map<LibraryOption, ?> libraryOptions) {
        CallingConvention convention = (CallingConvention)((Object)libraryOptions.get((Object)LibraryOption.CallingConvention));
        if (convention instanceof com.kenai.jffi.CallingConvention) {
            return (com.kenai.jffi.CallingConvention)((Object)convention);
        }
        if (convention instanceof CallingConvention) {
            switch (convention) {
                case DEFAULT: {
                    return com.kenai.jffi.CallingConvention.DEFAULT;
                }
                case STDCALL: {
                    return com.kenai.jffi.CallingConvention.STDCALL;
                }
            }
        } else if (convention != null) {
            throw new IllegalArgumentException("unknown calling convention: " + (Object)((Object)convention));
        }
        return com.kenai.jffi.CallingConvention.DEFAULT;
    }
}

