/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.extend.impl;

import com.openhtmltopdf.extend.FSCacheEx;
import com.openhtmltopdf.extend.FSCacheValue;
import com.openhtmltopdf.util.XRLog;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class FSDefaultCacheStore
implements FSCacheEx<String, FSCacheValue> {
    private final Map<String, FSCacheValue> _store = new ConcurrentHashMap<String, FSCacheValue>();

    @Override
    public void put(String key, FSCacheValue value) {
        XRLog.load(Level.INFO, "Putting key(" + key + ") in cache.");
        this._store.put(key, value);
    }

    @Override
    public FSCacheValue get(String key, Callable<? extends FSCacheValue> loader) {
        FSCacheValue value;
        if (this._store.containsKey(key)) {
            return this.get(key);
        }
        try {
            value = loader.call();
            if (value != null) {
                this._store.put(key, value);
            }
        }
        catch (Exception e) {
            XRLog.exception("Could not load cache value for key(" + key + ")", e);
            value = null;
        }
        XRLog.load(Level.INFO, (value == null ? "Missed" : "Hit") + " key(" + key + ") from cache.");
        return value;
    }

    @Override
    public FSCacheValue get(String key) {
        FSCacheValue value = this._store.get(key);
        XRLog.load(Level.INFO, (value == null ? "Missed" : "Hit") + " key(" + key + ") from cache.");
        return value;
    }
}

