/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import io.prometheus.client.Gauge;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.ShuffleTaskInfo;
import org.apache.uniffle.server.ShuffleTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNShuffleDataSizeOfAppCalcTask {
    private static final Logger LOG = LoggerFactory.getLogger(TopNShuffleDataSizeOfAppCalcTask.class);
    private final int topNShuffleDataNumber;
    private final int topNShuffleDataTaskRefreshInterval;
    private final Gauge gaugeTotalDataSize;
    private final Gauge gaugeInMemoryDataSize;
    private final Gauge gaugeOnLocalFileDataSize;
    private final Gauge gaugeOnHadoopDataSize;
    private final ShuffleTaskManager shuffleTaskManager;
    private final ScheduledExecutorService scheduler;

    public TopNShuffleDataSizeOfAppCalcTask(ShuffleTaskManager taskManager, ShuffleServerConf conf) {
        this.topNShuffleDataNumber = conf.getInteger(ShuffleServerConf.TOP_N_APP_SHUFFLE_DATA_SIZE_NUMBER);
        this.topNShuffleDataTaskRefreshInterval = conf.getInteger(ShuffleServerConf.TOP_N_APP_SHUFFLE_DATA_REFRESH_INTERVAL);
        this.shuffleTaskManager = taskManager;
        this.gaugeTotalDataSize = ShuffleServerMetrics.gaugeTotalDataSizeUsage;
        this.gaugeInMemoryDataSize = ShuffleServerMetrics.gaugeInMemoryDataSizeUsage;
        this.gaugeOnLocalFileDataSize = ShuffleServerMetrics.gaugeOnDiskDataSizeUsage;
        this.gaugeOnHadoopDataSize = ShuffleServerMetrics.gaugeOnHadoopDataSizeUsage;
        this.scheduler = Executors.newScheduledThreadPool(1);
    }

    private void calcTopNShuffleDataSize() {
        List<Map.Entry<String, ShuffleTaskInfo>> topNTaskInfo = this.calcTopNTotalDataSizeTaskInfo();
        this.gaugeTotalDataSize.clear();
        for (Map.Entry<String, ShuffleTaskInfo> taskInfo : topNTaskInfo) {
            ((Gauge.Child)this.gaugeTotalDataSize.labels(new String[]{taskInfo.getKey()})).set((double)taskInfo.getValue().getTotalDataSize());
        }
        topNTaskInfo = this.calcTopNInMemoryDataSizeTaskInfo();
        this.gaugeInMemoryDataSize.clear();
        for (Map.Entry<String, ShuffleTaskInfo> taskInfo : topNTaskInfo) {
            ((Gauge.Child)this.gaugeInMemoryDataSize.labels(new String[]{taskInfo.getKey()})).set((double)taskInfo.getValue().getInMemoryDataSize());
        }
        topNTaskInfo = this.calcTopNOnLocalFileDataSizeTaskInfo();
        this.gaugeOnLocalFileDataSize.clear();
        for (Map.Entry<String, ShuffleTaskInfo> taskInfo : topNTaskInfo) {
            ((Gauge.Child)this.gaugeOnLocalFileDataSize.labels(new String[]{taskInfo.getKey()})).set((double)taskInfo.getValue().getOnLocalFileDataSize());
        }
        topNTaskInfo = this.calcTopNOnHadoopDataSizeTaskInfo();
        this.gaugeOnHadoopDataSize.clear();
        for (Map.Entry<String, ShuffleTaskInfo> taskInfo : topNTaskInfo) {
            ((Gauge.Child)this.gaugeOnHadoopDataSize.labels(new String[]{taskInfo.getKey()})).set((double)taskInfo.getValue().getOnHadoopDataSize());
        }
    }

    public List<Map.Entry<String, ShuffleTaskInfo>> calcTopNTotalDataSizeTaskInfo() {
        return this.shuffleTaskManager.getShuffleTaskInfos().entrySet().stream().sorted((e1, e2) -> Long.compare(((ShuffleTaskInfo)e2.getValue()).getTotalDataSize(), ((ShuffleTaskInfo)e1.getValue()).getTotalDataSize())).limit(this.topNShuffleDataNumber).collect(Collectors.toList());
    }

    public List<Map.Entry<String, ShuffleTaskInfo>> calcTopNInMemoryDataSizeTaskInfo() {
        return this.shuffleTaskManager.getShuffleTaskInfos().entrySet().stream().sorted((e1, e2) -> Long.compare(((ShuffleTaskInfo)e2.getValue()).getInMemoryDataSize(), ((ShuffleTaskInfo)e1.getValue()).getInMemoryDataSize())).limit(this.topNShuffleDataNumber).collect(Collectors.toList());
    }

    public List<Map.Entry<String, ShuffleTaskInfo>> calcTopNOnLocalFileDataSizeTaskInfo() {
        return this.shuffleTaskManager.getShuffleTaskInfos().entrySet().stream().sorted((e1, e2) -> Long.compare(((ShuffleTaskInfo)e2.getValue()).getOnLocalFileDataSize(), ((ShuffleTaskInfo)e1.getValue()).getOnLocalFileDataSize())).limit(this.topNShuffleDataNumber).collect(Collectors.toList());
    }

    public List<Map.Entry<String, ShuffleTaskInfo>> calcTopNOnHadoopDataSizeTaskInfo() {
        return this.shuffleTaskManager.getShuffleTaskInfos().entrySet().stream().sorted((e1, e2) -> Long.compare(((ShuffleTaskInfo)e2.getValue()).getOnHadoopDataSize(), ((ShuffleTaskInfo)e1.getValue()).getOnHadoopDataSize())).limit(this.topNShuffleDataNumber).collect(Collectors.toList());
    }

    public void start() {
        LOG.info("TopNShuffleDataSizeOfAppCalcTask start schedule.");
        this.scheduler.scheduleAtFixedRate(this::calcTopNShuffleDataSize, 0L, this.topNShuffleDataTaskRefreshInterval, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

