/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.reader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.Aggregator;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.ShuffleReadMetrics;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.shuffle.FunctionUtils;
import org.apache.spark.shuffle.RssShuffleHandle;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.reader.RssFetchFailedIterator;
import org.apache.spark.shuffle.reader.RssShuffleDataIterator;
import org.apache.spark.util.CompletionIterator;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.collection.ExternalSorter;
import org.apache.uniffle.client.api.ShuffleManagerClient;
import org.apache.uniffle.client.api.ShuffleReadClient;
import org.apache.uniffle.client.factory.ShuffleClientFactory;
import org.apache.uniffle.client.request.RssReportShuffleReadMetricRequest;
import org.apache.uniffle.client.response.RssReportShuffleReadMetricResponse;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleReadTimes;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.compression.Codec;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.apache.uniffle.storage.handler.impl.ShuffleServerReadCost;
import org.apache.uniffle.storage.handler.impl.ShuffleServerReadCostTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product2;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.runtime.AbstractFunction0;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;

public class RssShuffleReader<K, C>
implements ShuffleReader<K, C> {
    private static final Logger LOG = LoggerFactory.getLogger(RssShuffleReader.class);
    private final Map<Integer, List<ShuffleServerInfo>> partitionToShuffleServers;
    private String appId;
    private int shuffleId;
    private int startPartition;
    private int endPartition;
    private TaskContext context;
    private ShuffleDependency<K, ?, C> shuffleDependency;
    private int numMaps;
    private Serializer serializer;
    private long taskAttemptId;
    private String taskId;
    private String basePath;
    private int partitionNum;
    private Map<Integer, Roaring64NavigableMap> partitionToExpectBlocks;
    private Roaring64NavigableMap taskIdBitmap;
    private Configuration hadoopConf;
    private int mapStartIndex;
    private int mapEndIndex;
    private ShuffleReadMetrics readMetrics;
    private RssConf rssConf;
    private ShuffleDataDistributionType dataDistributionType;
    private Supplier<ShuffleManagerClient> managerClientSupplier;
    private ShuffleServerReadCostTracker shuffleServerReadCostTracker = new ShuffleServerReadCostTracker();
    private boolean isShuffleReadFailed = false;
    private Optional<String> shuffleReadReason = Optional.empty();
    private ShuffleReadTimes shuffleReadTimes = new ShuffleReadTimes();

    public RssShuffleReader(int startPartition, int endPartition, int mapStartIndex, int mapEndIndex, TaskContext context, RssShuffleHandle<K, ?, C> rssShuffleHandle, String basePath, Configuration hadoopConf, int partitionNum, Map<Integer, Roaring64NavigableMap> partitionToExpectBlocks, Roaring64NavigableMap taskIdBitmap, ShuffleReadMetrics readMetrics, Supplier<ShuffleManagerClient> managerClientSupplier, RssConf rssConf, ShuffleDataDistributionType dataDistributionType, Map<Integer, List<ShuffleServerInfo>> allPartitionToServers) {
        this.appId = rssShuffleHandle.getAppId();
        this.startPartition = startPartition;
        this.endPartition = endPartition;
        this.mapStartIndex = mapStartIndex;
        this.mapEndIndex = mapEndIndex;
        this.context = context;
        this.numMaps = rssShuffleHandle.getNumMaps();
        this.shuffleDependency = rssShuffleHandle.getDependency();
        this.shuffleId = this.shuffleDependency.shuffleId();
        this.serializer = rssShuffleHandle.getDependency().serializer();
        this.taskId = "" + context.taskAttemptId() + "_" + context.attemptNumber();
        this.taskAttemptId = context.taskAttemptId();
        this.basePath = basePath;
        this.partitionNum = partitionNum;
        this.partitionToExpectBlocks = partitionToExpectBlocks;
        this.taskIdBitmap = taskIdBitmap;
        this.hadoopConf = hadoopConf;
        this.readMetrics = readMetrics;
        this.partitionToShuffleServers = allPartitionToServers;
        this.rssConf = rssConf;
        this.dataDistributionType = dataDistributionType;
        this.managerClientSupplier = managerClientSupplier;
    }

    public Iterator<Product2<K, C>> read() {
        Object resultIter;
        LOG.info("Shuffle read started:" + this.getReadInfo());
        InterruptibleIterator rssShuffleDataIterator = new MultiPartitionIterator();
        if (this.shuffleDependency.keyOrdering().isDefined()) {
            Option aggregator = Option.empty();
            if (this.shuffleDependency.aggregator().isDefined()) {
                aggregator = this.shuffleDependency.mapSideCombine() ? Option.apply((Object)new Aggregator(x -> x, ((Aggregator)this.shuffleDependency.aggregator().get()).mergeCombiners(), ((Aggregator)this.shuffleDependency.aggregator().get()).mergeCombiners())) : Option.apply((Object)((Aggregator)this.shuffleDependency.aggregator().get()));
            }
            final ExternalSorter sorter = new ExternalSorter(this.context, aggregator, Option.empty(), this.shuffleDependency.keyOrdering(), this.serializer);
            LOG.info("Inserting aggregated records to sorter");
            long startTime = System.currentTimeMillis();
            sorter.insertAll((Iterator)rssShuffleDataIterator);
            LOG.info("Inserted aggregated records to sorter: millis:" + (System.currentTimeMillis() - startTime));
            this.context.taskMetrics().incMemoryBytesSpilled(sorter.memoryBytesSpilled());
            this.context.taskMetrics().incPeakExecutionMemory(sorter.peakMemoryUsedBytes());
            this.context.taskMetrics().incDiskBytesSpilled(sorter.diskBytesSpilled());
            AbstractFunction0<BoxedUnit> fn0 = new AbstractFunction0<BoxedUnit>(){

                public BoxedUnit apply() {
                    sorter.stop();
                    return BoxedUnit.UNIT;
                }
            };
            AbstractFunction1<TaskContext, Void> fn1 = new AbstractFunction1<TaskContext, Void>(){

                public Void apply(TaskContext context) {
                    sorter.stop();
                    return null;
                }
            };
            this.context.addTaskCompletionListener((Function1)fn1);
            resultIter = CompletionIterator$.MODULE$.apply(sorter.iterator(), (Function0)fn0);
        } else if (this.shuffleDependency.aggregator().isDefined()) {
            Aggregator aggregator = (Aggregator)this.shuffleDependency.aggregator().get();
            resultIter = this.shuffleDependency.mapSideCombine() ? aggregator.combineCombinersByKey((Iterator)rssShuffleDataIterator, this.context) : aggregator.combineValuesByKey((Iterator)rssShuffleDataIterator, this.context);
        } else {
            resultIter = rssShuffleDataIterator;
        }
        if (!(resultIter instanceof InterruptibleIterator)) {
            resultIter = new InterruptibleIterator(this.context, resultIter);
        }
        if (this.rssConf.getBoolean(RssSparkConfig.RSS_RESUBMIT_STAGE_WITH_FETCH_FAILURE_ENABLED) && this.rssConf.getInteger(RssClientConf.SHUFFLE_MANAGER_GRPC_PORT, 0) > 0) {
            resultIter = RssFetchFailedIterator.newBuilder().appId(this.appId).shuffleId(this.shuffleId).partitionId(this.startPartition).stageAttemptId(this.context.stageAttemptNumber()).managerClientSupplier(this.managerClientSupplier).build(resultIter);
        }
        return resultIter;
    }

    private String getReadInfo() {
        return "appId=" + this.appId + ", shuffleId=" + this.shuffleId + ",taskId=" + this.taskId + ", partitions: [" + this.startPartition + ", " + this.endPartition + "), maps: [" + this.mapStartIndex + ", " + this.mapEndIndex + ")";
    }

    @VisibleForTesting
    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    private void postShuffleReadMetricsToDriver() {
        ShuffleManagerClient client;
        if (this.managerClientSupplier != null && (client = this.managerClientSupplier.get()) != null) {
            try {
                RssReportShuffleReadMetricResponse response = client.reportShuffleReadMetric(new RssReportShuffleReadMetricRequest(this.context.stageId(), this.shuffleId, this.context.taskAttemptId(), this.shuffleServerReadCostTracker.list().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> new RssReportShuffleReadMetricRequest.TaskShuffleReadMetric(((ShuffleServerReadCost)x.getValue()).getDurationMillis(), ((ShuffleServerReadCost)x.getValue()).getReadBytes(), ((ShuffleServerReadCost)x.getValue()).getMemoryReadDurationMillis(), ((ShuffleServerReadCost)x.getValue()).getMemoryReadBytes(), ((ShuffleServerReadCost)x.getValue()).getLocalfileReadDurationMillis(), ((ShuffleServerReadCost)x.getValue()).getLocalfileReadBytes(), ((ShuffleServerReadCost)x.getValue()).getHadoopReadLocalFileDurationMillis(), ((ShuffleServerReadCost)x.getValue()).getHadoopReadLocalFileBytes()))), this.isShuffleReadFailed, this.shuffleReadReason, this.shuffleReadTimes));
                if (response != null && response.getStatusCode() != StatusCode.SUCCESS) {
                    LOG.error("Errors on reporting shuffle read metrics to driver");
                }
            }
            catch (Exception e) {
                LOG.error("Errors on post shuffle read metric to driver", (Throwable)e);
            }
        }
    }

    class MultiPartitionIterator<K, C>
    extends AbstractIterator<Product2<K, C>> {
        java.util.Iterator<CompletionIterator<Product2<K, C>, RssShuffleDataIterator<K, C>>> iterator;
        CompletionIterator<Product2<K, C>, RssShuffleDataIterator<K, C>> dataIterator;

        MultiPartitionIterator() {
            ArrayList<CompletionIterator> iterators = Lists.newArrayList();
            if (RssShuffleReader.this.numMaps <= 0) {
                return;
            }
            for (int partition = RssShuffleReader.this.startPartition; partition < RssShuffleReader.this.endPartition; ++partition) {
                if (((Roaring64NavigableMap)RssShuffleReader.this.partitionToExpectBlocks.get(partition)).isEmpty()) {
                    LOG.info("{} partition is empty partition", (Object)partition);
                    continue;
                }
                List shuffleServerInfoList = (List)RssShuffleReader.this.partitionToShuffleServers.get(partition);
                if (shuffleServerInfoList != null && shuffleServerInfoList.size() > 1 && RssShuffleReader.this.rssConf.getBoolean(RssSparkConfig.RSS_READ_REORDER_MULTI_SERVERS_ENABLED)) {
                    Collections.shuffle(shuffleServerInfoList);
                }
                boolean isReplicaFilterEnabled = RssShuffleReader.this.rssConf.getInteger("rss.data.replica", 1) > 1 && shuffleServerInfoList.size() > 1;
                boolean expectedTaskIdsBitmapFilterEnable = RssShuffleReader.this.mapStartIndex != 0 || RssShuffleReader.this.mapEndIndex != Integer.MAX_VALUE || isReplicaFilterEnabled;
                int retryMax = RssShuffleReader.this.rssConf.getInteger("rss.client.retry.max", 50);
                long retryIntervalMax = RssShuffleReader.this.rssConf.getLong("rss.client.retry.interval.max", 10000L);
                boolean compress = RssShuffleReader.this.rssConf.getBoolean("spark.shuffle.compress".substring("spark.".length()), true);
                Optional<Codec> codec = compress ? Codec.newInstance(RssShuffleReader.this.rssConf) : Optional.empty();
                ShuffleClientFactory.ReadClientBuilder builder = ShuffleClientFactory.newReadBuilder().readCostTracker(RssShuffleReader.this.shuffleServerReadCostTracker).appId(RssShuffleReader.this.appId).shuffleId(RssShuffleReader.this.shuffleId).partitionId(partition).basePath(RssShuffleReader.this.basePath).partitionNumPerRange(1).partitionNum(RssShuffleReader.this.partitionNum).blockIdBitmap((Roaring64NavigableMap)RssShuffleReader.this.partitionToExpectBlocks.get(partition)).taskIdBitmap(RssShuffleReader.this.taskIdBitmap).shuffleServerInfoList(shuffleServerInfoList).hadoopConf(RssShuffleReader.this.hadoopConf).shuffleDataDistributionType(RssShuffleReader.this.dataDistributionType).expectedTaskIdsBitmapFilterEnable(expectedTaskIdsBitmapFilterEnable).retryMax(retryMax).retryIntervalMax(retryIntervalMax).rssConf(RssShuffleReader.this.rssConf).taskAttemptId(RssShuffleReader.this.taskAttemptId);
                if (codec.isPresent() && RssShuffleReader.this.rssConf.get(RssSparkConfig.RSS_READ_OVERLAPPING_DECOMPRESSION_ENABLED).booleanValue()) {
                    builder.overlappingDecompressionEnabled(true).codec((Codec)codec.get()).overlappingDecompressionThreadNum(RssShuffleReader.this.rssConf.get(RssSparkConfig.RSS_READ_OVERLAPPING_DECOMPRESSION_THREADS));
                }
                ShuffleReadClient shuffleReadClient = ShuffleClientFactory.getInstance().createShuffleReadClient(builder);
                RssShuffleDataIterator iterator = new RssShuffleDataIterator(RssShuffleReader.this.shuffleDependency.serializer(), shuffleReadClient, RssShuffleReader.this.readMetrics, RssShuffleReader.this.rssConf, codec);
                CompletionIterator completionIterator = CompletionIterator$.MODULE$.apply(iterator, FunctionUtils.once(() -> {
                    RssShuffleReader.this.shuffleReadTimes.merge(iterator.getReadTimes());
                    RssShuffleReader.this.context.taskMetrics().mergeShuffleReadMetrics();
                    return iterator.cleanup();
                }));
                iterators.add(completionIterator);
            }
            this.iterator = iterators.iterator();
            if (this.iterator.hasNext()) {
                this.dataIterator = this.iterator.next();
                this.iterator.remove();
            }
            RssShuffleReader.this.context.addTaskCompletionListener(taskContext -> {
                if (this.dataIterator != null) {
                    this.dataIterator.completion();
                }
                this.iterator.forEachRemaining(CompletionIterator::completion);
            });
        }

        public boolean hasNext() {
            try {
                if (this.dataIterator == null) {
                    return false;
                }
                while (!this.dataIterator.hasNext()) {
                    if (!this.iterator.hasNext()) {
                        RssShuffleReader.this.postShuffleReadMetricsToDriver();
                        return false;
                    }
                    this.dataIterator = this.iterator.next();
                    this.iterator.remove();
                }
                return this.dataIterator.hasNext();
            }
            catch (Exception e) {
                RssShuffleReader.this.isShuffleReadFailed = true;
                RssShuffleReader.this.shuffleReadReason = Optional.ofNullable(e.getMessage());
                RssShuffleReader.this.postShuffleReadMetricsToDriver();
                throw e;
            }
        }

        public Product2<K, C> next() {
            Product2 result = (Product2)this.dataIterator.next();
            return result;
        }
    }
}

