/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer.writable;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.uniffle.common.serializer.DeserializationStream;
import org.apache.uniffle.common.serializer.SerInputStream;
import org.apache.uniffle.common.serializer.writable.WritableSerializerInstance;

public class WritableDeserializationStream<K extends Writable, V extends Writable>
extends DeserializationStream<K, V> {
    public static final int EOF_MARKER = -1;
    private SerInputStream inputStream;
    private DataInputStream dataIn;
    private Class<K> keyClass;
    private Class<V> valueClass;
    private K currentKey;
    private V currentValue;

    public WritableDeserializationStream(WritableSerializerInstance instance, SerInputStream inputStream, Class<K> keyClass, Class<V> valueClass) {
        this.inputStream = inputStream;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    @Override
    public void init() {
        this.inputStream.init();
        this.dataIn = new DataInputStream(this.inputStream);
    }

    @Override
    public boolean nextRecord() throws IOException {
        if (this.inputStream.available() <= 0) {
            return false;
        }
        int currentKeyLength = WritableUtils.readVInt((DataInput)this.dataIn);
        int currentValueLength = WritableUtils.readVInt((DataInput)this.dataIn);
        if (currentKeyLength == -1 && currentValueLength == -1) {
            return false;
        }
        this.currentKey = (Writable)ReflectionUtils.newInstance(this.keyClass, null);
        this.currentKey.readFields((DataInput)this.dataIn);
        this.currentValue = (Writable)ReflectionUtils.newInstance(this.valueClass, null);
        this.currentValue.readFields((DataInput)this.dataIn);
        return true;
    }

    @Override
    public K getCurrentKey() {
        return this.currentKey;
    }

    @Override
    public V getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.dataIn != null) {
            this.dataIn.close();
            this.dataIn = null;
        }
    }
}

