/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;

public final class SpdyHttpHeaders {
    private SpdyHttpHeaders() {
    }

    @Deprecated
    public static void removeStreamID(HttpMessage message) {
        SpdyHttpHeaders.removeStreamId(message);
    }

    public static void removeStreamId(HttpMessage message) {
        message.removeHeader("X-SPDY-Stream-ID");
    }

    @Deprecated
    public static int getStreamID(HttpMessage message) {
        return SpdyHttpHeaders.getStreamId(message);
    }

    public static int getStreamId(HttpMessage message) {
        return HttpHeaders.getIntHeader(message, "X-SPDY-Stream-ID");
    }

    @Deprecated
    public static void setStreamID(HttpMessage message, int streamId) {
        SpdyHttpHeaders.setStreamId(message, streamId);
    }

    public static void setStreamId(HttpMessage message, int streamId) {
        HttpHeaders.setIntHeader(message, "X-SPDY-Stream-ID", streamId);
    }

    @Deprecated
    public static void removeAssociatedToStreamID(HttpMessage message) {
        SpdyHttpHeaders.removeAssociatedToStreamId(message);
    }

    public static void removeAssociatedToStreamId(HttpMessage message) {
        message.removeHeader("X-SPDY-Associated-To-Stream-ID");
    }

    @Deprecated
    public static int getAssociatedToStreamID(HttpMessage message) {
        return SpdyHttpHeaders.getAssociatedToStreamId(message);
    }

    public static int getAssociatedToStreamId(HttpMessage message) {
        return HttpHeaders.getIntHeader(message, "X-SPDY-Associated-To-Stream-ID", 0);
    }

    @Deprecated
    public static void setAssociatedToStreamID(HttpMessage message, int associatedToStreamId) {
        SpdyHttpHeaders.setAssociatedToStreamId(message, associatedToStreamId);
    }

    public static void setAssociatedToStreamId(HttpMessage message, int associatedToStreamId) {
        HttpHeaders.setIntHeader(message, "X-SPDY-Associated-To-Stream-ID", associatedToStreamId);
    }

    public static void removePriority(HttpMessage message) {
        message.removeHeader("X-SPDY-Priority");
    }

    public static byte getPriority(HttpMessage message) {
        return (byte)HttpHeaders.getIntHeader(message, "X-SPDY-Priority", 0);
    }

    public static void setPriority(HttpMessage message, byte priority) {
        HttpHeaders.setIntHeader(message, "X-SPDY-Priority", priority);
    }

    public static void removeUrl(HttpMessage message) {
        message.removeHeader("X-SPDY-URL");
    }

    public static String getUrl(HttpMessage message) {
        return message.getHeader("X-SPDY-URL");
    }

    public static void setUrl(HttpMessage message, String url) {
        message.setHeader("X-SPDY-URL", url);
    }

    public static void removeScheme(HttpMessage message) {
        message.removeHeader("X-SPDY-Scheme");
    }

    public static String getScheme(HttpMessage message) {
        return message.getHeader("X-SPDY-Scheme");
    }

    public static void setScheme(HttpMessage message, String scheme) {
        message.setHeader("X-SPDY-Scheme", scheme);
    }

    public static final class Names {
        public static final String STREAM_ID = "X-SPDY-Stream-ID";
        public static final String ASSOCIATED_TO_STREAM_ID = "X-SPDY-Associated-To-Stream-ID";
        public static final String PRIORITY = "X-SPDY-Priority";
        public static final String URL = "X-SPDY-URL";
        public static final String SCHEME = "X-SPDY-Scheme";

        private Names() {
        }
    }
}

