/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.apache.tez.runtime.library.common.combine.Combiner;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ExceptionReporter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.FetchedInputAllocatorOrderedGrouped;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.RssMergeManager;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.RssShuffleScheduler;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleInputEventHandlerOrderedGrouped;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleScheduler;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.apache.tez.runtime.library.exceptions.InputAlreadyClosedException;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.base.Preconditions;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.Futures;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RssShuffle
implements ExceptionReporter {
    private static final Logger LOG = LoggerFactory.getLogger(RssShuffle.class);
    private final Configuration conf;
    private final InputContext inputContext;
    private final ShuffleInputEventHandlerOrderedGrouped eventHandler;
    @VisibleForTesting
    final RssShuffleScheduler rssScheduler;
    @VisibleForTesting
    final MergeManager merger;
    private final CompressionCodec codec;
    private final boolean ifileReadAhead;
    private final int ifileReadAheadLength;
    private AtomicReference<Throwable> throwable = new AtomicReference();
    private String throwingThreadName = null;
    private final RssRunShuffleCallable rssRunShuffleCallable;
    private volatile ListenableFuture<TezRawKeyValueIterator> rssRunShuffleFuture;
    private final ListeningExecutorService executor;
    private final String srcNameTrimmed;
    private AtomicBoolean isShutDown = new AtomicBoolean(false);
    private AtomicBoolean fetchersClosed = new AtomicBoolean(false);
    private AtomicBoolean schedulerClosed = new AtomicBoolean(false);
    private AtomicBoolean mergerClosed = new AtomicBoolean(false);
    private final long startTime;
    private final TezCounter mergePhaseTime;
    private final TezCounter shufflePhaseTime;
    private Configuration remoteConf;

    public RssShuffle(InputContext inputContext, Configuration conf, int numInputs, long initialMemoryAvailable, int shuffleId, ApplicationAttemptId applicationAttemptId) throws IOException {
        this.inputContext = inputContext;
        this.conf = conf;
        this.srcNameTrimmed = TezUtilsInternal.cleanVertexName((String)inputContext.getSourceVertexName());
        if (ConfigUtils.isIntermediateInputCompressed((Configuration)conf)) {
            Class codecClass = ConfigUtils.getIntermediateInputCompressorClass((Configuration)conf, DefaultCodec.class);
            this.codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            this.codec.getDecompressorType();
        } else {
            this.codec = null;
        }
        this.ifileReadAhead = conf.getBoolean("tez.runtime.ifile.readahead", true);
        this.ifileReadAheadLength = this.ifileReadAhead ? conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000) : 0;
        this.remoteConf = RssShuffle.getRemoteConf(conf);
        LOG.info(this.srcNameTrimmed + ": Shuffle assigned with " + numInputs + " inputs, codec: " + (this.codec == null ? "None" : this.codec.getClass().getName()) + ", ifileReadAhead: " + this.ifileReadAhead);
        this.startTime = System.currentTimeMillis();
        this.merger = this.createMergeManager(initialMemoryAvailable, applicationAttemptId);
        this.rssScheduler = new RssShuffleScheduler(this.inputContext, this.conf, numInputs, this, this.merger, (FetchedInputAllocatorOrderedGrouped)this.merger, this.startTime, this.codec, this.ifileReadAhead, this.ifileReadAheadLength, this.srcNameTrimmed, shuffleId, applicationAttemptId);
        this.mergePhaseTime = inputContext.getCounters().findCounter((Enum)TaskCounter.MERGE_PHASE_TIME);
        this.shufflePhaseTime = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_PHASE_TIME);
        this.eventHandler = new ShuffleInputEventHandlerOrderedGrouped(inputContext, (ShuffleScheduler)this.rssScheduler, ShuffleUtils.isTezShuffleHandler((Configuration)conf));
        ExecutorService rawExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShuffleAndMergeRunner {" + this.srcNameTrimmed + "}").build());
        this.executor = MoreExecutors.listeningDecorator(rawExecutor);
        this.rssRunShuffleCallable = new RssRunShuffleCallable();
    }

    protected MergeManager createMergeManager(long initialMemoryAvailable, ApplicationAttemptId appAttemptId) throws IOException {
        Combiner combiner = TezRuntimeUtils.instantiateCombiner((Configuration)this.conf, (TaskContext)this.inputContext);
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)this.conf);
        LocalDirAllocator localDirAllocator = new LocalDirAllocator("tez.runtime.framework.local.dirs");
        TezCounter spilledRecordsCounter = this.inputContext.getCounters().findCounter((Enum)TaskCounter.SPILLED_RECORDS);
        TezCounter reduceCombineInputCounter = this.inputContext.getCounters().findCounter((Enum)TaskCounter.COMBINE_INPUT_RECORDS);
        TezCounter mergedMapOutputsCounter = this.inputContext.getCounters().findCounter((Enum)TaskCounter.MERGED_MAP_OUTPUTS);
        boolean useRemoteSpill = this.conf.getBoolean("tez.rss.reduce.remote.spill.enable", false);
        if (useRemoteSpill) {
            int replication = this.conf.getInt("tez.rss.reduce.remote.spill.replication", 1);
            int retries = this.conf.getInt("tez.rss.reduce.remote.spill.retries", 5);
            LOG.info("Tez RssShuffle will use RssMergeManager!");
            return new RssMergeManager(this.conf, (FileSystem)localFS, this.inputContext, combiner, spilledRecordsCounter, reduceCombineInputCounter, mergedMapOutputsCounter, this, initialMemoryAvailable, this.codec, this.ifileReadAhead, this.ifileReadAheadLength, this.remoteConf, replication, retries, appAttemptId.toString());
        }
        return new MergeManager(this.conf, (FileSystem)localFS, localDirAllocator, this.inputContext, combiner, spilledRecordsCounter, reduceCombineInputCounter, mergedMapOutputsCounter, (ExceptionReporter)this, initialMemoryAvailable, this.codec, this.ifileReadAhead, this.ifileReadAheadLength);
    }

    private static Configuration getRemoteConf(Configuration conf) {
        String basePath = conf.get("tez.rss.remote.storage.path");
        String remoteStorageConf = conf.get("tez.rss.remote.storage.conf");
        RemoteStorageInfo remoteStorageInfo = new RemoteStorageInfo(basePath, remoteStorageConf);
        Configuration remoteConf = new Configuration(conf);
        if (!remoteStorageInfo.isEmpty()) {
            for (Map.Entry<String, String> entry : remoteStorageInfo.getConfItems().entrySet()) {
                remoteConf.set(entry.getKey(), entry.getValue());
            }
        }
        return remoteConf;
    }

    public void handleEvents(List<Event> events) throws IOException {
        if (!this.isShutDown.get()) {
            this.eventHandler.handleEvents(events);
        } else {
            LOG.info(this.srcNameTrimmed + ": Ignoring events since already shutdown. EventCount: " + events.size());
        }
    }

    public boolean isInputReady() throws IOException, InterruptedException, TezException {
        if (this.isShutDown.get()) {
            throw new InputAlreadyClosedException();
        }
        if (this.throwable.get() != null) {
            this.handleThrowable(this.throwable.get());
        }
        if (this.rssRunShuffleFuture == null) {
            return false;
        }
        return this.rssRunShuffleFuture.isDone();
    }

    private void handleThrowable(Throwable t) throws IOException, InterruptedException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof InterruptedException) {
            throw (InterruptedException)t;
        }
        throw new UndeclaredThrowableException(t);
    }

    public TezRawKeyValueIterator waitForInput() throws IOException, InterruptedException, TezException {
        Preconditions.checkState(this.rssRunShuffleFuture != null, "waitForInput can only be called after run");
        TezRawKeyValueIterator kvIter = null;
        try {
            kvIter = (TezRawKeyValueIterator)this.rssRunShuffleFuture.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.handleThrowable(cause);
        }
        if (this.isShutDown.get()) {
            throw new InputAlreadyClosedException();
        }
        if (this.throwable.get() != null) {
            this.handleThrowable(this.throwable.get());
        }
        return kvIter;
    }

    public void run() throws IOException {
        this.merger.configureAndStart();
        this.rssRunShuffleFuture = this.executor.submit((Callable)((Object)this.rssRunShuffleCallable));
        Futures.addCallback(this.rssRunShuffleFuture, new RssShuffleRunnerFutureCallback(), MoreExecutors.directExecutor());
        this.executor.shutdown();
    }

    public void shutdown() {
        if (!this.isShutDown.getAndSet(true)) {
            LOG.info("Shutting down Shuffle for source: " + this.srcNameTrimmed);
            this.rssRunShuffleFuture.cancel(true);
            this.cleanupIgnoreErrors();
        }
    }

    private void cleanupShuffleSchedulerIgnoreErrors() {
        try {
            this.cleanupShuffleScheduler();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info(this.srcNameTrimmed + ": Interrupted while attempting to close the scheduler during cleanup. Ignoring");
        }
    }

    private void cleanupShuffleScheduler() throws InterruptedException {
        if (!this.schedulerClosed.getAndSet(true)) {
            this.rssScheduler.close();
        }
    }

    private void cleanupMerger(boolean ignoreErrors) throws Throwable {
        if (!this.mergerClosed.getAndSet(true)) {
            try {
                this.merger.close(false);
            }
            catch (InterruptedException e) {
                if (ignoreErrors) {
                    Thread.currentThread().interrupt();
                    LOG.info(this.srcNameTrimmed + ": Interrupted while attempting to close the merger during cleanup. Ignoring");
                }
                throw e;
            }
            catch (Throwable e) {
                if (ignoreErrors) {
                    LOG.info("{}: Exception while trying to shutdown merger, Ignoring", (Object)this.srcNameTrimmed, (Object)e);
                }
                throw e;
            }
        }
    }

    private void cleanupIgnoreErrors() {
        try {
            if (this.eventHandler != null) {
                this.eventHandler.logProgress(true);
            }
            try {
                this.cleanupShuffleSchedulerIgnoreErrors();
            }
            catch (Exception e) {
                LOG.warn("Error cleaning up shuffle scheduler. Ignoring and continuing with shutdown. Message={}", (Object)e.getMessage());
            }
            this.cleanupMerger(true);
        }
        catch (Throwable t) {
            LOG.info("{}: Error in cleaning up.., ", (Object)this.srcNameTrimmed, (Object)t);
        }
    }

    @InterfaceAudience.Private
    public synchronized void reportException(Throwable t) {
        if (this.throwable.get() == null) {
            LOG.info(this.srcNameTrimmed + ": Setting throwable in reportException with message [" + t.getMessage() + "] from thread [" + Thread.currentThread().getName());
            this.throwable.set(t);
            this.throwingThreadName = Thread.currentThread().getName();
            this.cleanupShuffleSchedulerIgnoreErrors();
        }
    }

    @InterfaceAudience.Private
    public synchronized void killSelf(Exception exception, String message) {
        if (!this.isShutDown.get() && this.throwable.get() == null) {
            this.shutdown();
            this.inputContext.killSelf((Throwable)exception, message);
        }
    }

    @InterfaceAudience.Private
    public static long getInitialMemoryRequirement(Configuration conf, long maxAvailableTaskMemory) {
        return MergeManager.getInitialMemoryRequirement((Configuration)conf, (long)maxAvailableTaskMemory);
    }

    private class RssShuffleRunnerFutureCallback
    implements FutureCallback<TezRawKeyValueIterator> {
        private RssShuffleRunnerFutureCallback() {
        }

        @Override
        public void onSuccess(TezRawKeyValueIterator result) {
            LOG.info(RssShuffle.this.srcNameTrimmed + ": RSSShuffle Runner thread complete");
        }

        @Override
        public void onFailure(Throwable t) {
            if (RssShuffle.this.isShutDown.get()) {
                LOG.info(RssShuffle.this.srcNameTrimmed + ": Already shutdown. Ignoring error");
            } else {
                LOG.error(RssShuffle.this.srcNameTrimmed + ": RSSShuffleRunner failed with error", t);
                RssShuffle.this.inputContext.reportFailure(TaskFailureType.NON_FATAL, t, "RSSShuffle Runner Failed");
                RssShuffle.this.cleanupIgnoreErrors();
            }
        }
    }

    public static class RssShuffleError
    extends IOException {
        private static final long serialVersionUID = 5753909320586607881L;

        RssShuffleError(String msg, Throwable t) {
            super(msg, t);
        }
    }

    private class RssRunShuffleCallable
    extends CallableWithNdc<TezRawKeyValueIterator> {
        private RssRunShuffleCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TezRawKeyValueIterator callInternal() throws IOException, InterruptedException {
            if (!RssShuffle.this.isShutDown.get()) {
                try {
                    RssShuffle.this.rssScheduler.start();
                }
                catch (Throwable e) {
                    throw new RssShuffleError("Error during shuffle", e);
                }
                finally {
                    RssShuffle.this.cleanupShuffleScheduler();
                }
            }
            RssShuffle e = RssShuffle.this;
            synchronized (e) {
                if (RssShuffle.this.throwable.get() != null) {
                    throw new RssShuffleError("error in shuffle in " + RssShuffle.this.throwingThreadName, (Throwable)RssShuffle.this.throwable.get());
                }
            }
            RssShuffle.this.shufflePhaseTime.setValue(System.currentTimeMillis() - RssShuffle.this.startTime);
            RssShuffle.this.cleanupShuffleScheduler();
            TezRawKeyValueIterator kvIter = null;
            RssShuffle.this.inputContext.notifyProgress();
            try {
                kvIter = RssShuffle.this.merger.close(true);
            }
            catch (Throwable e2) {
                RssShuffle.this.throwable.set(e2);
                throw new RssShuffleError("Error while doing final merge ", e2);
            }
            RssShuffle.this.mergePhaseTime.setValue(System.currentTimeMillis() - RssShuffle.this.startTime);
            RssShuffle.this.inputContext.notifyProgress();
            RssShuffle rssShuffle = RssShuffle.this;
            synchronized (rssShuffle) {
                if (RssShuffle.this.throwable.get() != null) {
                    throw new RssShuffleError("error in shuffle in " + RssShuffle.this.throwingThreadName, (Throwable)RssShuffle.this.throwable.get());
                }
            }
            RssShuffle.this.inputContext.inputIsReady();
            LOG.info("merge complete for input vertex : " + RssShuffle.this.srcNameTrimmed);
            return kvIter;
        }
    }
}

