/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.common.ReconfigurableRegistry;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.ShufflePartitionedData;
import org.apache.uniffle.common.StorageType;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.exception.ExceedHugePartitionHardLimitException;
import org.apache.uniffle.common.exception.FileNotFoundException;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.merger.MergeState;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.netty.client.TransportClient;
import org.apache.uniffle.common.netty.handle.BaseMessageHandler;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleDataRequest;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleDataResponse;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleIndexRequest;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleIndexResponse;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleIndexV2Response;
import org.apache.uniffle.common.netty.protocol.GetMemoryShuffleDataRequest;
import org.apache.uniffle.common.netty.protocol.GetMemoryShuffleDataResponse;
import org.apache.uniffle.common.netty.protocol.GetSortedShuffleDataRequest;
import org.apache.uniffle.common.netty.protocol.GetSortedShuffleDataResponse;
import org.apache.uniffle.common.netty.protocol.RequestMessage;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.netty.protocol.SendShuffleDataRequest;
import org.apache.uniffle.common.netty.protocol.SendShuffleDataRequestV1;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.server.ShuffleDataReadEvent;
import org.apache.uniffle.server.ShuffleServer;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.ShuffleTaskInfo;
import org.apache.uniffle.server.ShuffleTaskManager;
import org.apache.uniffle.server.audit.ServerRpcAuditContext;
import org.apache.uniffle.server.buffer.PreAllocatedBufferInfo;
import org.apache.uniffle.server.buffer.ShuffleBufferManager;
import org.apache.uniffle.server.merge.MergeStatus;
import org.apache.uniffle.shaded.guava.collect.Lists;
import org.apache.uniffle.shaded.guava.collect.Sets;
import org.apache.uniffle.storage.common.StorageReadMetrics;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleServerNettyHandler
implements BaseMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleServerNettyHandler.class);
    private static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"SHUFFLE_SERVER_RPC_AUDIT_LOG");
    private static final int RPC_TIMEOUT = 60000;
    private final ShuffleServer shuffleServer;
    private boolean isRpcAuditLogEnabled;
    private List<String> rpcAuditExcludeOpList;

    public ShuffleServerNettyHandler(ShuffleServer shuffleServer) {
        this.shuffleServer = shuffleServer;
        this.isRpcAuditLogEnabled = (Boolean)shuffleServer.getShuffleServerConf().getReconfigurableConf(ShuffleServerConf.SERVER_RPC_AUDIT_LOG_ENABLED).get();
        this.rpcAuditExcludeOpList = (List)shuffleServer.getShuffleServerConf().getReconfigurableConf(ShuffleServerConf.SERVER_RPC_RPC_AUDIT_LOG_EXCLUDE_LIST).get();
        ReconfigurableRegistry.register(Sets.newHashSet(ShuffleServerConf.SERVER_RPC_AUDIT_LOG_ENABLED.key(), ShuffleServerConf.SERVER_RPC_RPC_AUDIT_LOG_EXCLUDE_LIST.key()), (conf, changedProperties) -> {
            if (changedProperties == null) {
                return;
            }
            if (changedProperties.contains(ShuffleServerConf.SERVER_RPC_AUDIT_LOG_ENABLED.key())) {
                this.isRpcAuditLogEnabled = conf.getBoolean(ShuffleServerConf.SERVER_RPC_AUDIT_LOG_ENABLED);
            }
            if (changedProperties.contains(ShuffleServerConf.SERVER_RPC_RPC_AUDIT_LOG_EXCLUDE_LIST.key())) {
                this.rpcAuditExcludeOpList = (List)conf.get(ShuffleServerConf.SERVER_RPC_RPC_AUDIT_LOG_EXCLUDE_LIST);
            }
        });
    }

    public void receive(TransportClient client, RequestMessage msg) {
        this.shuffleServer.getNettyMetrics().incCounter(msg.getClass().getName());
        if (msg instanceof SendShuffleDataRequestV1) {
            this.handleSendShuffleDataRequest(client, (SendShuffleDataRequestV1)msg);
        } else if (msg instanceof GetLocalShuffleDataRequest) {
            this.handleGetLocalShuffleData(client, (GetLocalShuffleDataRequest)msg);
        } else if (msg instanceof GetLocalShuffleIndexRequest) {
            this.handleGetLocalShuffleIndexRequest(client, (GetLocalShuffleIndexRequest)msg);
        } else if (msg instanceof GetMemoryShuffleDataRequest) {
            this.handleGetMemoryShuffleDataRequest(client, (GetMemoryShuffleDataRequest)msg);
        } else if (msg instanceof GetSortedShuffleDataRequest) {
            this.handleGetSortedShuffleDataRequest(client, (GetSortedShuffleDataRequest)msg);
        } else {
            throw new RssException("Can not handle message " + msg.type());
        }
        this.shuffleServer.getNettyMetrics().decCounter(msg.getClass().getName());
    }

    public void exceptionCaught(Throwable cause, TransportClient client) {
        LOG.error("exception caught {}", (Object)client.getSocketAddress(), (Object)cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSendShuffleDataRequest(TransportClient client, SendShuffleDataRequestV1 req) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("sendShuffleData", client);){
            RpcResponse rpcResponse;
            long transportTime;
            String appId = req.getAppId();
            int shuffleId = req.getShuffleId();
            long requireBufferId = req.getRequireId();
            int stageAttemptNumber = req.getStageAttemptNumber();
            ShuffleBufferManager shuffleBufferManager = this.shuffleServer.getShuffleBufferManager();
            ShuffleTaskManager shuffleTaskManager = this.shuffleServer.getShuffleTaskManager();
            PreAllocatedBufferInfo info = shuffleTaskManager.getAndRemovePreAllocatedBuffer(requireBufferId);
            int requireSize = info == null ? 0 : info.getRequireSize();
            int requireBlocksSize = Math.max(requireSize - req.getDecodedLength(), 0);
            boolean isPreAllocated = info != null;
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            auditContext.withArgs("requireBufferId=" + requireBufferId + ", requireSize=" + requireSize + ", isPreAllocated=" + isPreAllocated + ", requireBlocksSize=" + requireBlocksSize + ", stageAttemptNumber=" + stageAttemptNumber + ", partitionCount=" + req.getPartitionToBlocks().size());
            ShuffleTaskInfo taskInfo = this.shuffleServer.getShuffleTaskManager().getShuffleTaskInfo(appId);
            if (taskInfo == null) {
                RpcResponse rpcResponse2 = new RpcResponse(req.getRequestId(), StatusCode.APP_NOT_FOUND, "appId: " + appId + " not found");
                String errorMsg = "APP_NOT_FOUND error, requireBufferId[" + requireBufferId + "] for appId[" + appId + "], shuffleId[" + shuffleId + "], isPreAllocated[" + isPreAllocated + "]";
                LOG.error(errorMsg);
                ShuffleServerMetrics.counterAppNotFound.inc();
                ShuffleServerNettyHandler.releaseNettyBufferAndMetrics(req, appId, shuffleId, requireBufferId, requireBlocksSize, shuffleBufferManager, info, isPreAllocated);
                auditContext.withStatusCode(rpcResponse2.getStatusCode());
                client.getChannel().writeAndFlush((Object)rpcResponse2);
                return;
            }
            Integer latestStageAttemptNumber = taskInfo.getLatestStageAttemptNumber(shuffleId);
            if (stageAttemptNumber < latestStageAttemptNumber) {
                String responseMessage = "A retry has occurred at the Stage, sending data is invalid.";
                RpcResponse rpcResponse3 = new RpcResponse(req.getRequestId(), StatusCode.STAGE_RETRY_IGNORE, responseMessage);
                LOG.warn("Stage retry occurred, appId[" + appId + "], shuffleId[" + shuffleId + "], stageAttemptNumber[" + stageAttemptNumber + "], latestStageAttemptNumber[" + latestStageAttemptNumber + "]");
                ShuffleServerNettyHandler.releaseNettyBufferAndMetrics(req, appId, shuffleId, requireBufferId, requireBlocksSize, shuffleBufferManager, info, isPreAllocated);
                auditContext.withStatusCode(rpcResponse3.getStatusCode());
                client.getChannel().writeAndFlush((Object)rpcResponse3);
                return;
            }
            long timestamp = req.getTimestamp();
            if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
                this.shuffleServer.getNettyMetrics().recordTransportTime(SendShuffleDataRequest.class.getName(), transportTime);
            }
            StatusCode ret = StatusCode.SUCCESS;
            String responseMessage = "OK";
            if (req.getPartitionToBlocks().size() > 0) {
                ShuffleServerMetrics.counterTotalReceivedDataSize.inc((double)requireBlocksSize);
                if (!isPreAllocated) {
                    req.getPartitionToBlocks().values().stream().flatMap(Collection::stream).forEach(block -> block.getData().release());
                    String errorMsg = "Can't find requireBufferId[" + requireBufferId + "] for appId[" + appId + "], shuffleId[" + shuffleId + "], probably because the pre-allocated buffer has expired. Please increase the expiration time using " + ShuffleServerConf.SERVER_PRE_ALLOCATION_EXPIRED.key() + " in ShuffleServer's configuration";
                    LOG.warn(errorMsg);
                    RpcResponse rpcResponse4 = new RpcResponse(req.getRequestId(), StatusCode.INTERNAL_ERROR, errorMsg);
                    auditContext.withStatusCode(rpcResponse4.getStatusCode());
                    client.getChannel().writeAndFlush((Object)rpcResponse4);
                    return;
                }
                long start = System.currentTimeMillis();
                shuffleBufferManager.releaseMemory(req.getDecodedLength(), false, true);
                List<ShufflePartitionedData> shufflePartitionedDataList = this.toPartitionedDataList(req);
                long alreadyReleasedSize = 0L;
                boolean hasFailureOccurred = false;
                for (ShufflePartitionedData spd : shufflePartitionedDataList) {
                    String errorMsg;
                    String shuffleDataInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + spd.getPartitionId() + "]";
                    try {
                        if (hasFailureOccurred) continue;
                        ret = shuffleTaskManager.cacheShuffleData(appId, shuffleId, isPreAllocated, spd);
                        if (ret != StatusCode.SUCCESS) {
                            String errorMsg2 = "Error happened when shuffleEngine.write for " + shuffleDataInfo + ", statusCode=" + ret;
                            LOG.error(errorMsg2);
                            responseMessage = errorMsg2;
                            hasFailureOccurred = true;
                            continue;
                        }
                        if (this.shuffleServer.isRemoteMergeEnable()) {
                            this.shuffleServer.getShuffleMergeManager().setDirect(appId, shuffleId, true);
                        }
                        long toReleasedSize = spd.getTotalBlockEncodedLength();
                        shuffleTaskManager.releasePreAllocatedSize(toReleasedSize);
                        alreadyReleasedSize += toReleasedSize;
                        shuffleTaskManager.updateCachedBlockIds(appId, shuffleId, spd.getPartitionId(), spd.getBlockList());
                    }
                    catch (ExceedHugePartitionHardLimitException e) {
                        errorMsg = "ExceedHugePartitionHardLimitException Error happened when shuffleEngine.write for " + shuffleDataInfo + ": " + e.getMessage();
                        ShuffleServerMetrics.counterTotalHugePartitionExceedHardLimitNum.inc();
                        ret = StatusCode.EXCEED_HUGE_PARTITION_HARD_LIMIT;
                        responseMessage = errorMsg;
                        LOG.error(errorMsg);
                        hasFailureOccurred = true;
                    }
                    catch (Exception e) {
                        errorMsg = "Error happened when shuffleEngine.write for " + shuffleDataInfo + ": " + e.getMessage();
                        ret = StatusCode.INTERNAL_ERROR;
                        responseMessage = errorMsg;
                        LOG.error(errorMsg, (Throwable)e);
                        hasFailureOccurred = true;
                    }
                    finally {
                        if (!hasFailureOccurred) continue;
                        Arrays.stream(spd.getBlockList()).forEach(block -> block.getData().release());
                        shuffleBufferManager.releaseMemory(spd.getTotalBlockEncodedLength(), false, false);
                    }
                }
                if ((long)requireBlocksSize > alreadyReleasedSize) {
                    shuffleTaskManager.releasePreAllocatedSize((long)requireBlocksSize - alreadyReleasedSize);
                }
                rpcResponse = new RpcResponse(req.getRequestId(), ret, responseMessage);
                long costTime = System.currentTimeMillis() - start;
                this.shuffleServer.getNettyMetrics().recordProcessTime(SendShuffleDataRequest.class.getName(), costTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cache Shuffle Data for appId[" + appId + "], shuffleId[" + shuffleId + "], cost " + costTime + " ms with " + shufflePartitionedDataList.size() + " blocks and " + requireBlocksSize + " bytes");
                }
            } else {
                rpcResponse = new RpcResponse(req.getRequestId(), StatusCode.INTERNAL_ERROR, "No data in request");
            }
            auditContext.withStatusCode(rpcResponse.getStatusCode());
            client.getChannel().writeAndFlush((Object)rpcResponse);
        }
    }

    private static void releaseNettyBufferAndMetrics(SendShuffleDataRequestV1 req, String appId, int shuffleId, long requireBufferId, long requireBlocksSize, ShuffleBufferManager shuffleBufferManager, PreAllocatedBufferInfo info, boolean isPreAllocated) {
        if (isPreAllocated) {
            shuffleBufferManager.releaseMemory(info.getRequireSize(), false, true);
        }
        if (MapUtils.isNotEmpty((Map)req.getPartitionToBlocks())) {
            req.getPartitionToBlocks().values().stream().flatMap(Collection::stream).forEach(block -> block.getData().release());
            ShuffleServerMetrics.counterTotalReceivedDataSize.inc((double)requireBlocksSize);
        } else {
            LOG.error("Failed to handle send shuffle data request, no blocks found in this request. appId: {}, shuffleId: {}, requireBufferId: {}", new Object[]{appId, shuffleId, requireBufferId});
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleGetMemoryShuffleDataRequest(TransportClient client, GetMemoryShuffleDataRequest req) {
        auditContext = this.createAuditContext("getMemoryShuffleData", client);
        var4_4 = null;
        try {
            appId = req.getAppId();
            shuffleId = req.getShuffleId();
            partitionId = req.getPartitionId();
            blockId = req.getLastBlockId();
            readBufferSize = req.getReadBufferSize();
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            auditContext.withArgs("requestId=" + req.getRequestId() + ", partitionId=" + partitionId + ", blockId=" + blockId + ", readBufferSize=" + readBufferSize);
            status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                response = new GetMemoryShuffleDataResponse(req.getRequestId(), status, status.toString(), Lists.newArrayList(), Unpooled.EMPTY_BUFFER);
                client.getChannel().writeAndFlush((Object)response);
                return;
            }
            timestamp = req.getTimestamp();
            if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
                this.shuffleServer.getNettyMetrics().recordTransportTime(GetMemoryShuffleDataRequest.class.getName(), transportTime);
            }
            msg = "OK";
            requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]";
            if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(readBufferSize)) {
                shuffleDataResult = null;
                try {
                    start = System.currentTimeMillis();
                    shuffleDataResult = this.shuffleServer.getShuffleTaskManager().getInMemoryShuffleData(appId, shuffleId, partitionId, blockId, readBufferSize, req.getExpectedTaskIdsBitmap());
                    data = NettyManagedBuffer.EMPTY_BUFFER;
                    bufferSegments = Lists.newArrayList();
                    if (shuffleDataResult != null) {
                        data = shuffleDataResult.getManagedBuffer();
                        bufferSegments = shuffleDataResult.getBufferSegments();
                        ShuffleServerMetrics.counterTotalReadDataSize.inc((double)data.size());
                        ShuffleServerMetrics.counterTotalReadMemoryDataSize.inc((double)data.size());
                        ShuffleServerMetrics.gaugeReadMemoryDataThreadNum.inc();
                        ShuffleServerMetrics.gaugeReadMemoryDataBufferSize.inc((double)readBufferSize);
                    }
                    auditContext.withStatusCode(status);
                    auditContext.withReturnValue("len=" + data.size() + ", bufferSegments=" + bufferSegments.size());
                    response = new GetMemoryShuffleDataResponse(req.getRequestId(), status, msg, bufferSegments, (ManagedBuffer)data);
                    listener = new ReleaseMemoryAndRecordReadTimeListener(start, readBufferSize, data.size(), requestInfo, (RequestMessage)req, (RpcResponse)response, client);
                    client.getChannel().writeAndFlush((Object)response).addListener((GenericFutureListener)listener);
                    return;
                }
                catch (Exception e) {
                    this.shuffleServer.getShuffleBufferManager().releaseReadMemory(readBufferSize);
                    if (shuffleDataResult != null) {
                        shuffleDataResult.release();
                    }
                    status = StatusCode.INTERNAL_ERROR;
                    msg = "Error happened when get in memory shuffle data for " + requestInfo + ", " + e.getMessage();
                    ShuffleServerNettyHandler.LOG.error(msg, (Throwable)e);
                    response = new GetMemoryShuffleDataResponse(req.getRequestId(), status, msg, Lists.newArrayList(), Unpooled.EMPTY_BUFFER);
lbl57:
                    // 2 sources

                    while (true) {
                        auditContext.withStatusCode(response.getStatusCode());
                        client.getChannel().writeAndFlush((Object)response);
                        return;
                    }
                }
            }
            status = StatusCode.NO_BUFFER;
            msg = "Can't require memory to get in memory shuffle data";
        }
        catch (Throwable var5_7) {
            var4_4 = var5_7;
            throw var5_7;
        }
        ShuffleServerNettyHandler.LOG.warn("{} for {}", (Object)msg, (Object)requestInfo);
        response = new GetMemoryShuffleDataResponse(req.getRequestId(), status, msg, Lists.newArrayList(), Unpooled.EMPTY_BUFFER);
        ** while (true)
        finally {
            if (auditContext != null) {
                if (var4_4 != null) {
                    try {
                        auditContext.close();
                    }
                    catch (Throwable var13_15) {
                        var4_4.addSuppressed(var13_15);
                    }
                } else {
                    auditContext.close();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleGetLocalShuffleIndexRequest(TransportClient client, GetLocalShuffleIndexRequest req) {
        auditContext = this.createAuditContext("getLocalShuffleIndex", client);
        var4_4 = null;
        try {
            block26: {
                appId = req.getAppId();
                shuffleId = req.getShuffleId();
                partitionId = req.getPartitionId();
                partitionNumPerRange = req.getPartitionNumPerRange();
                partitionNum = req.getPartitionNum();
                requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]";
                auditContext.withAppId(appId);
                auditContext.withShuffleId(shuffleId);
                auditContext.withArgs("requestId=" + req.getRequestId() + ", partitionId=" + partitionId + ", partitionNumPerRange=" + partitionNumPerRange + ", partitionNum=" + partitionNum);
                status = this.verifyRequest(appId);
                if (status != StatusCode.SUCCESS) {
                    auditContext.withStatusCode(status);
                    response = new GetLocalShuffleIndexResponse(req.getRequestId(), status, status.toString(), Unpooled.EMPTY_BUFFER, 0L);
                    client.getChannel().writeAndFlush((Object)response);
                    return;
                }
                msg = "OK";
                range = ShuffleStorageUtils.getPartitionRange((int)partitionId, (int)partitionNumPerRange, (int)partitionNum);
                storage = this.shuffleServer.getStorageManager().selectStorage(new ShuffleDataReadEvent(appId, shuffleId, partitionId, range[0]));
                if (storage != null) {
                    storage.updateReadMetrics(new StorageReadMetrics(appId, shuffleId));
                }
                assumedFileSize = this.shuffleServer.getShuffleServerConf().getLong(ShuffleServerConf.SERVER_SHUFFLE_INDEX_SIZE_HINT);
                if (!this.shuffleServer.getShuffleBufferManager().requireReadMemory(assumedFileSize)) break block26;
                shuffleIndexResult = null;
                try {
                    start = System.currentTimeMillis();
                    shuffleIndexResult = this.shuffleServer.getShuffleTaskManager().getShuffleIndex(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum);
                    data = shuffleIndexResult.getManagedBuffer();
                    ShuffleServerMetrics.counterTotalReadDataSize.inc((double)data.size());
                    ShuffleServerMetrics.counterTotalReadLocalIndexFileSize.inc((double)data.size());
                    ShuffleServerMetrics.gaugeReadLocalIndexFileThreadNum.inc();
                    ShuffleServerMetrics.gaugeReadLocalIndexFileBufferSize.inc((double)assumedFileSize);
                    auditContext.withStatusCode(status);
                    auditContext.withReturnValue("len=" + data.size());
                    response = new GetLocalShuffleIndexV2Response(req.getRequestId(), status, msg, data, shuffleIndexResult.getDataFileLen(), shuffleIndexResult.getStorageIds());
                    listener = new ReleaseMemoryAndRecordReadTimeListener(start, assumedFileSize, data.size(), requestInfo, (RequestMessage)req, (RpcResponse)response, client);
                    client.getChannel().writeAndFlush((Object)response).addListener((GenericFutureListener)listener);
                    return;
                }
                catch (FileNotFoundException indexFileNotFoundException) {
                    block27: {
                        this.shuffleServer.getShuffleBufferManager().releaseReadMemory(assumedFileSize);
                        if (shuffleIndexResult != null) {
                            shuffleIndexResult.release();
                        }
                        ShuffleServerNettyHandler.LOG.warn("Index file for {} is not found, maybe the data has been flushed to cold storage or partial data still in another shuffle server(when partition split is enabled).", (Object)requestInfo, (Object)indexFileNotFoundException);
                        response = new GetLocalShuffleIndexV2Response(req.getRequestId(), status, msg, Unpooled.EMPTY_BUFFER, 0L);
                        break block27;
                        catch (Exception e) {
                            this.shuffleServer.getShuffleBufferManager().releaseReadMemory(assumedFileSize);
                            if (shuffleIndexResult != null) {
                                shuffleIndexResult.release();
                            }
                            status = StatusCode.INTERNAL_ERROR;
                            msg = "Error happened when get shuffle index for " + requestInfo + ", " + e.getMessage();
                            ShuffleServerNettyHandler.LOG.error(msg, (Throwable)e);
                            response = new GetLocalShuffleIndexV2Response(req.getRequestId(), status, msg, Unpooled.EMPTY_BUFFER, 0L);
                        }
                    }
lbl65:
                    // 2 sources

                    while (true) {
                        auditContext.withStatusCode(response.getStatusCode());
                        client.getChannel().writeAndFlush((Object)response);
                        return;
                    }
                }
            }
            status = StatusCode.NO_BUFFER;
            msg = "Can't require memory to get shuffle index";
        }
        catch (Throwable var5_7) {
            var4_4 = var5_7;
            throw var5_7;
        }
        ShuffleServerNettyHandler.LOG.warn("{} for {}", (Object)msg, (Object)requestInfo);
        response = new GetLocalShuffleIndexV2Response(req.getRequestId(), status, msg, Unpooled.EMPTY_BUFFER, 0L);
        ** while (true)
        finally {
            if (auditContext != null) {
                if (var4_4 != null) {
                    try {
                        auditContext.close();
                    }
                    catch (Throwable var13_16) {
                        var4_4.addSuppressed(var13_16);
                    }
                } else {
                    auditContext.close();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleGetLocalShuffleData(TransportClient client, GetLocalShuffleDataRequest req) {
        auditContext = this.createAuditContext("getLocalShuffleData", client);
        var4_4 = null;
        try {
            appId = req.getAppId();
            shuffleId = req.getShuffleId();
            partitionId = req.getPartitionId();
            partitionNumPerRange = req.getPartitionNumPerRange();
            partitionNum = req.getPartitionNum();
            offset = req.getOffset();
            length = req.getLength();
            storageId = req.getStorageId();
            auditContext.withAppId(appId);
            auditContext.withShuffleId(shuffleId);
            auditContext.withArgs("requestId=" + req.getRequestId() + ", partitionId=" + partitionId + ", partitionNumPerRange=" + partitionNumPerRange + ", partitionNum=" + partitionNum + ", offset=" + offset + ", length=" + length + ", storageId=" + storageId);
            status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                response = new GetLocalShuffleDataResponse(req.getRequestId(), status, status.toString(), (ManagedBuffer)new NettyManagedBuffer(Unpooled.EMPTY_BUFFER));
                client.getChannel().writeAndFlush((Object)response);
                return;
            }
            timestamp = req.getTimestamp();
            if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
                this.shuffleServer.getNettyMetrics().recordTransportTime(GetLocalShuffleDataRequest.class.getName(), transportTime);
            }
            storageType = ((StorageType)this.shuffleServer.getShuffleServerConf().get(RssBaseConf.RSS_STORAGE_TYPE)).name();
            msg = "OK";
            requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "], offset[" + offset + "], length[" + length + "]";
            range = ShuffleStorageUtils.getPartitionRange((int)partitionId, (int)partitionNumPerRange, (int)partitionNum);
            storage = this.shuffleServer.getStorageManager().selectStorage(new ShuffleDataReadEvent(appId, shuffleId, partitionId, range[0], req.getStorageId()));
            if (storage != null) {
                storage.updateReadMetrics(new StorageReadMetrics(appId, shuffleId));
            }
            if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(length)) {
                sdr = null;
                try {
                    start = System.currentTimeMillis();
                    sdr = this.shuffleServer.getShuffleTaskManager().getShuffleData(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, storageType, offset, length, storageId);
                    ShuffleServerMetrics.counterTotalReadDataSize.inc((double)sdr.getDataLength());
                    ShuffleServerMetrics.counterTotalReadLocalDataFileSize.inc((double)sdr.getDataLength());
                    ShuffleServerMetrics.gaugeReadLocalDataFileThreadNum.inc();
                    ShuffleServerMetrics.gaugeReadLocalDataFileBufferSize.inc((double)length);
                    response = new GetLocalShuffleDataResponse(req.getRequestId(), status, msg, sdr.getManagedBuffer());
                    listener = new ReleaseMemoryAndRecordReadTimeListener(start, length, sdr.getDataLength(), requestInfo, (RequestMessage)req, (RpcResponse)response, client);
                    client.getChannel().writeAndFlush((Object)response).addListener((GenericFutureListener)listener);
                    auditContext.withStatusCode(response.getStatusCode());
                    auditContext.withReturnValue("len=" + sdr.getDataLength());
                    return;
                }
                catch (Exception e) {
                    this.shuffleServer.getShuffleBufferManager().releaseReadMemory(length);
                    if (sdr != null) {
                        sdr.release();
                    }
                    status = StatusCode.INTERNAL_ERROR;
                    msg = "Error happened when get shuffle data for " + requestInfo + ", " + e.getMessage();
                    ShuffleServerNettyHandler.LOG.error(msg, (Throwable)e);
                    response = new GetLocalShuffleDataResponse(req.getRequestId(), status, msg, (ManagedBuffer)new NettyManagedBuffer(Unpooled.EMPTY_BUFFER));
lbl62:
                    // 2 sources

                    while (true) {
                        auditContext.withStatusCode(response.getStatusCode());
                        client.getChannel().writeAndFlush((Object)response);
                        return;
                    }
                }
            }
            status = StatusCode.NO_BUFFER;
            msg = "Can't require memory to get shuffle data";
        }
        catch (Throwable var5_18) {
            var4_4 = var5_18;
            throw var5_18;
        }
        ShuffleServerNettyHandler.LOG.warn("{} for {}", (Object)msg, (Object)requestInfo);
        response = new GetLocalShuffleDataResponse(req.getRequestId(), status, msg, (ManagedBuffer)new NettyManagedBuffer(Unpooled.EMPTY_BUFFER));
        ** while (true)
        finally {
            if (auditContext != null) {
                if (var4_4 != null) {
                    try {
                        auditContext.close();
                    }
                    catch (Throwable var16_19) {
                        var4_4.addSuppressed(var16_19);
                    }
                } else {
                    auditContext.close();
                }
            }
        }
    }

    public void handleGetSortedShuffleDataRequest(TransportClient client, GetSortedShuffleDataRequest req) {
        long transportTime;
        long start = System.currentTimeMillis();
        long requestId = req.getRequestId();
        String appId = req.getAppId();
        int shuffleId = req.getShuffleId();
        int partitionId = req.getPartitionId();
        long blockId = req.getBlockId();
        long timestamp = req.getTimestamp();
        if (timestamp > 0L && (transportTime = start - timestamp) > 0L) {
            this.shuffleServer.getNettyMetrics().recordTransportTime(GetSortedShuffleDataRequest.class.getName(), transportTime);
        }
        StatusCode status = StatusCode.SUCCESS;
        String msg = "OK";
        String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "], blockId[" + blockId + "]";
        if (!this.shuffleServer.isRemoteMergeEnable()) {
            msg = "Remote merge is disabled";
            status = StatusCode.INTERNAL_ERROR;
            GetSortedShuffleDataResponse response = new GetSortedShuffleDataResponse(requestId, status, msg, -1L, MergeState.INTERNAL_ERROR.code(), Unpooled.EMPTY_BUFFER);
            client.getChannel().writeAndFlush((Object)response);
            return;
        }
        MergeStatus mergeStatus = this.shuffleServer.getShuffleMergeManager().tryGetBlock(appId, shuffleId, partitionId, blockId);
        MergeState mergeState = mergeStatus.getState();
        long readBlockSize = mergeStatus.getSize();
        if (mergeState == MergeState.INITED || mergeState == MergeState.MERGING && readBlockSize == -1L || mergeState == MergeState.DONE && readBlockSize == -1L || mergeState == MergeState.INTERNAL_ERROR) {
            msg = mergeState.name();
            GetSortedShuffleDataResponse response = new GetSortedShuffleDataResponse(requestId, status, msg, -1L, mergeState.code(), Unpooled.EMPTY_BUFFER);
            client.getChannel().writeAndFlush((Object)response);
            return;
        }
        if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(readBlockSize)) {
            ShuffleDataResult sdr = null;
            try {
                sdr = this.shuffleServer.getShuffleMergeManager().getShuffleData(appId, shuffleId, partitionId, blockId);
                GetSortedShuffleDataResponse response = new GetSortedShuffleDataResponse(requestId, status, msg, blockId + 1L, mergeState.code(), sdr.getManagedBuffer());
                ReleaseMemoryAndRecordReadTimeListener listener = new ReleaseMemoryAndRecordReadTimeListener(start, readBlockSize, sdr.getDataLength(), requestInfo, (RequestMessage)req, (RpcResponse)response, client);
                client.getChannel().writeAndFlush((Object)response).addListener((GenericFutureListener)listener);
            }
            catch (Exception e) {
                this.shuffleServer.getShuffleBufferManager().releaseReadMemory(readBlockSize);
                if (sdr != null) {
                    sdr.release();
                }
                status = StatusCode.INTERNAL_ERROR;
                msg = "Error happened when get shuffle data for " + requestInfo + ", " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                GetSortedShuffleDataResponse response = new GetSortedShuffleDataResponse(requestId, status, msg, -1L, MergeState.INTERNAL_ERROR.code(), Unpooled.EMPTY_BUFFER);
                client.getChannel().writeAndFlush((Object)response);
            }
        } else {
            status = StatusCode.NO_BUFFER;
            msg = "Can't require read memory to get sorted shuffle data";
            LOG.error(msg + " for " + requestInfo);
            GetSortedShuffleDataResponse response = new GetSortedShuffleDataResponse(requestId, status, msg, -1L, mergeState.code(), Unpooled.EMPTY_BUFFER);
            client.getChannel().writeAndFlush((Object)response);
        }
    }

    private List<ShufflePartitionedData> toPartitionedDataList(SendShuffleDataRequestV1 req) {
        ArrayList<ShufflePartitionedData> ret = Lists.newArrayList();
        for (Map.Entry entry : req.getPartitionToBlocks().entrySet()) {
            ret.add(this.toPartitionedData((Integer)entry.getKey(), (List)entry.getValue()));
        }
        return ret;
    }

    private ShufflePartitionedData toPartitionedData(int partitionId, List<ShufflePartitionedBlock> blocks) {
        if (blocks == null || blocks.isEmpty()) {
            return new ShufflePartitionedData(partitionId, 0L, 0L, new ShufflePartitionedBlock[0]);
        }
        ShufflePartitionedBlock[] ret = new ShufflePartitionedBlock[blocks.size()];
        long encodedLength = 0L;
        long dataLength = 0L;
        int i = 0;
        Iterator<ShufflePartitionedBlock> iterator = blocks.iterator();
        while (iterator.hasNext()) {
            ShufflePartitionedBlock block;
            ret[i] = block = iterator.next();
            encodedLength += ret[i].getEncodedLength();
            dataLength += (long)ret[i].getDataLength();
            ++i;
        }
        return new ShufflePartitionedData(partitionId, encodedLength, dataLength, ret);
    }

    private StatusCode verifyRequest(String appId) {
        if (StringUtils.isNotBlank((CharSequence)appId) && this.shuffleServer.getShuffleTaskManager().isAppExpired(appId)) {
            return StatusCode.NO_REGISTER;
        }
        return StatusCode.SUCCESS;
    }

    private ServerRpcAuditContext createAuditContext(String command, TransportClient transportClient) {
        Logger auditLogger = null;
        if (this.isRpcAuditLogEnabled && !this.rpcAuditExcludeOpList.contains(command)) {
            auditLogger = AUDIT_LOGGER;
        }
        ServerRpcAuditContext auditContext = new ServerRpcAuditContext(auditLogger);
        if (auditLogger != null) {
            auditContext.withCommand(command).withFrom(transportClient.getSocketAddress().toString()).withCreationTimeNs(System.nanoTime());
        }
        return auditContext;
    }

    class ReleaseMemoryAndRecordReadTimeListener
    implements ChannelFutureListener {
        private final long readStartedTime;
        private final long readBufferSize;
        private final long dataSize;
        private final String requestInfo;
        private final RequestMessage request;
        private final RpcResponse response;
        private final TransportClient client;

        ReleaseMemoryAndRecordReadTimeListener(long readStartedTime, long readBufferSize, long dataSize, String requestInfo, RequestMessage request, RpcResponse response, TransportClient client) {
            this.readStartedTime = readStartedTime;
            this.readBufferSize = readBufferSize;
            this.dataSize = dataSize;
            this.requestInfo = requestInfo;
            this.request = request;
            this.response = response;
            this.client = client;
        }

        public void operationComplete(ChannelFuture future) {
            GetMemoryShuffleDataResponse getMemoryShuffleDataResponse;
            ShuffleServerNettyHandler.this.shuffleServer.getShuffleBufferManager().releaseReadMemory(this.readBufferSize);
            long readTime = System.currentTimeMillis() - this.readStartedTime;
            ShuffleServerMetrics.counterTotalReadTime.inc((double)readTime);
            ShuffleServerNettyHandler.this.shuffleServer.getNettyMetrics().recordProcessTime(this.request.getClass().getName(), readTime);
            if (this.request instanceof GetLocalShuffleDataRequest) {
                ShuffleServerMetrics.gaugeReadLocalDataFileThreadNum.dec();
                ShuffleServerMetrics.gaugeReadLocalDataFileBufferSize.dec((double)this.readBufferSize);
            } else if (this.request instanceof GetLocalShuffleIndexRequest) {
                ShuffleServerMetrics.gaugeReadLocalIndexFileThreadNum.dec();
                ShuffleServerMetrics.gaugeReadLocalIndexFileBufferSize.dec((double)this.readBufferSize);
            } else if (this.request instanceof GetMemoryShuffleDataRequest && CollectionUtils.isNotEmpty((Collection)(getMemoryShuffleDataResponse = (GetMemoryShuffleDataResponse)this.response).getBufferSegments())) {
                ShuffleServerMetrics.gaugeReadMemoryDataThreadNum.dec();
                ShuffleServerMetrics.gaugeReadMemoryDataBufferSize.dec((double)this.readBufferSize);
            }
            if (!future.isSuccess()) {
                Throwable cause = future.cause();
                String errorMsg = "Error happened when executing " + this.request.getOperationType() + " for " + this.requestInfo + ", " + cause.getMessage();
                if (future.channel().isWritable()) {
                    GetLocalShuffleDataResponse errorResponse;
                    if (this.request instanceof GetLocalShuffleDataRequest) {
                        errorResponse = new GetLocalShuffleDataResponse(this.request.getRequestId(), StatusCode.INTERNAL_ERROR, errorMsg, (ManagedBuffer)new NettyManagedBuffer(Unpooled.EMPTY_BUFFER));
                    } else if (this.request instanceof GetLocalShuffleIndexRequest) {
                        errorResponse = new GetLocalShuffleIndexResponse(this.request.getRequestId(), StatusCode.INTERNAL_ERROR, errorMsg, Unpooled.EMPTY_BUFFER, 0L);
                    } else if (this.request instanceof GetMemoryShuffleDataRequest) {
                        errorResponse = new GetMemoryShuffleDataResponse(this.request.getRequestId(), StatusCode.INTERNAL_ERROR, errorMsg, Lists.newArrayList(), Unpooled.EMPTY_BUFFER);
                    } else if (this.request instanceof GetSortedShuffleDataRequest) {
                        errorResponse = new GetSortedShuffleDataResponse(this.request.getRequestId(), StatusCode.INTERNAL_ERROR, errorMsg, -1L, MergeState.INTERNAL_ERROR.code(), Unpooled.EMPTY_BUFFER);
                    } else {
                        LOG.error("Cannot handle request {}", (Object)this.request.type(), (Object)cause);
                        return;
                    }
                    this.client.getChannel().writeAndFlush((Object)errorResponse);
                }
                LOG.error("Failed to execute {} for {}. Took {} ms and could not retrieve {} bytes of data", new Object[]{this.request.getOperationType(), this.requestInfo, readTime, this.dataSize, cause});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Successfully executed {} for {}. Took {} ms and retrieved {} bytes of data", new Object[]{this.request.getOperationType(), this.requestInfo, readTime, this.dataSize});
            }
        }
    }
}

