/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.buffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.ShufflePartitionedData;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleFlushManager;
import org.apache.uniffle.server.buffer.AbstractShuffleBuffer;
import org.apache.uniffle.shaded.guava.collect.Lists;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class ShuffleBufferWithLinkedList
extends AbstractShuffleBuffer {
    private Set<ShufflePartitionedBlock> blocks = new LinkedHashSet<ShufflePartitionedBlock>();
    private Map<Long, Set<ShufflePartitionedBlock>> inFlushBlockMap = JavaUtils.newConcurrentMap();

    @Override
    public synchronized long append(ShufflePartitionedData data) {
        if (this.evicted) {
            return -1L;
        }
        long currentEncodedLength = 0L;
        long currentDataLength = 0L;
        for (ShufflePartitionedBlock block : data.getBlockList()) {
            if (this.addBlock(block)) {
                currentEncodedLength += block.getEncodedLength();
                currentDataLength += (long)block.getDataLength();
                continue;
            }
            this.releaseBlock(block);
        }
        this.encodedLength += currentEncodedLength;
        this.dataLength += currentDataLength;
        return currentEncodedLength;
    }

    protected boolean addBlock(ShufflePartitionedBlock block) {
        return this.blocks.add(block);
    }

    protected void releaseBlock(ShufflePartitionedBlock block) {
        block.getData().release();
    }

    @Override
    public synchronized ShuffleDataFlushEvent toFlushEvent(String appId, int shuffleId, int startPartition, int endPartition, Supplier<Boolean> isValid, ShuffleDataDistributionType dataDistributionType) {
        if (this.blocks.isEmpty()) {
            return null;
        }
        Collection<ShufflePartitionedBlock> spBlocks = this.blocks;
        Set<ShufflePartitionedBlock> inFlushedQueueBlocks = this.blocks;
        if (dataDistributionType == ShuffleDataDistributionType.LOCAL_ORDER) {
            LinkedList<ShufflePartitionedBlock> orderedSpBlocks = new LinkedList<ShufflePartitionedBlock>(this.blocks);
            orderedSpBlocks.sort(Comparator.comparingLong(ShufflePartitionedBlock::getTaskAttemptId));
            spBlocks = orderedSpBlocks;
        }
        long eventId = ShuffleFlushManager.ATOMIC_EVENT_ID.getAndIncrement();
        ShuffleDataFlushEvent event = new ShuffleDataFlushEvent(eventId, appId, shuffleId, startPartition, endPartition, this.encodedLength, this.dataLength, spBlocks, isValid, this);
        event.addCleanupCallback(this.createCallbackForFlush(event));
        this.inFlushBlockMap.put(eventId, inFlushedQueueBlocks);
        this.blocks = new LinkedHashSet<ShufflePartitionedBlock>();
        this.inFlushSize.addAndGet(this.encodedLength);
        this.encodedLength = 0L;
        this.dataLength = 0L;
        return event;
    }

    protected Runnable createCallbackForFlush(ShuffleDataFlushEvent event) {
        Set<ShufflePartitionedBlock> inFlushedQueueBlocks = this.blocks;
        return () -> {
            this.clearInFlushBuffer(event.getEventId());
            inFlushedQueueBlocks.forEach(this::releaseBlock);
            this.inFlushSize.addAndGet(-event.getEncodedLength());
        };
    }

    @Override
    public Set<ShufflePartitionedBlock> getBlocks() {
        return this.blocks;
    }

    @Override
    public int getBlockCount() {
        return this.getBlocks().size();
    }

    @Override
    public long getInFlushBlockCount() {
        return this.inFlushBlockMap.values().stream().mapToLong(Set::size).sum();
    }

    @Override
    public int getInFlushEventCount() {
        return this.inFlushBlockMap.size();
    }

    @Override
    public synchronized long release() {
        Throwable lastException = null;
        int failedToReleaseSize = 0;
        long releasedSize = 0L;
        this.evicted = true;
        for (ShufflePartitionedBlock spb : this.blocks) {
            try {
                this.releaseBlock(spb);
                releasedSize += spb.getEncodedLength();
            }
            catch (Throwable t) {
                lastException = t;
                failedToReleaseSize = (int)((long)failedToReleaseSize + spb.getEncodedLength());
            }
        }
        if (lastException != null) {
            LOG.warn("Failed to release shuffle blocks with size {}. Maybe it has been released by others.", (Object)failedToReleaseSize, lastException);
        }
        return releasedSize;
    }

    @Override
    public synchronized void clearInFlushBuffer(long eventId) {
        this.inFlushBlockMap.remove(eventId);
    }

    @Override
    public Map<Long, Set<ShufflePartitionedBlock>> getInFlushBlockMap() {
        return this.inFlushBlockMap;
    }

    @Override
    protected void updateBufferSegmentsAndResultBlocks(long lastBlockId, long readBufferSize, List<BufferSegment> bufferSegments, List<ShufflePartitionedBlock> resultBlocks, Roaring64NavigableMap expectedTaskIds) {
        long nextBlockId = lastBlockId;
        ArrayList<Long> eventIdList = Lists.newArrayList(this.inFlushBlockMap.keySet());
        List<Long> sortedEventId = this.sortFlushingEventId(eventIdList);
        int offset = 0;
        boolean hasLastBlockId = false;
        if (!this.inFlushBlockMap.isEmpty()) {
            for (Long eventId : sortedEventId) {
                if (nextBlockId == -1L) {
                    this.updateSegmentsWithoutBlockId(offset, (Collection<ShufflePartitionedBlock>)this.inFlushBlockMap.get(eventId), readBufferSize, bufferSegments, resultBlocks, expectedTaskIds);
                    hasLastBlockId = true;
                } else {
                    hasLastBlockId = this.updateSegmentsWithBlockId(offset, this.inFlushBlockMap.get(eventId), readBufferSize, nextBlockId, bufferSegments, resultBlocks, expectedTaskIds);
                    if (hasLastBlockId) {
                        nextBlockId = -1L;
                    }
                }
                if (!bufferSegments.isEmpty()) {
                    offset = this.calculateDataLength(bufferSegments);
                }
                if ((long)offset < readBufferSize) continue;
                break;
            }
        }
        if (this.blocks.size() > 0 && (long)offset < readBufferSize) {
            if (nextBlockId == -1L) {
                this.updateSegmentsWithoutBlockId(offset, this.blocks, readBufferSize, bufferSegments, resultBlocks, expectedTaskIds);
                hasLastBlockId = true;
            } else {
                hasLastBlockId = this.updateSegmentsWithBlockId(offset, this.blocks, readBufferSize, nextBlockId, bufferSegments, resultBlocks, expectedTaskIds);
            }
        }
        if (!(this.inFlushBlockMap.isEmpty() && this.blocks.size() <= 0 || offset != 0 || hasLastBlockId)) {
            this.updateBufferSegmentsAndResultBlocks(-1L, readBufferSize, bufferSegments, resultBlocks, expectedTaskIds);
        }
    }

    private boolean updateSegmentsWithBlockId(int offset, Set<ShufflePartitionedBlock> cachedBlocks, long readBufferSize, long lastBlockId, List<BufferSegment> bufferSegments, List<ShufflePartitionedBlock> readBlocks, Roaring64NavigableMap expectedTaskIds) {
        int currentOffset = offset;
        boolean foundBlockId = false;
        for (ShufflePartitionedBlock block : cachedBlocks) {
            if (!foundBlockId) {
                if (block.getBlockId() != lastBlockId) continue;
                foundBlockId = true;
                continue;
            }
            if (expectedTaskIds != null && !expectedTaskIds.contains(block.getTaskAttemptId())) continue;
            bufferSegments.add(new BufferSegment(block.getBlockId(), (long)currentOffset, block.getDataLength(), block.getUncompressLength(), block.getCrc(), block.getTaskAttemptId()));
            readBlocks.add(block);
            if ((long)(currentOffset += block.getDataLength()) < readBufferSize) continue;
            break;
        }
        return foundBlockId;
    }
}

