/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.util.NettyUtils;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.buffer.ShuffleBuffer;
import org.apache.uniffle.shaded.guava.collect.Lists;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractShuffleBuffer
implements ShuffleBuffer {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractShuffleBuffer.class);
    protected long encodedLength = 0L;
    protected long dataLength;
    protected AtomicLong inFlushSize = new AtomicLong();
    protected volatile boolean evicted = false;
    public static final long BUFFER_EVICTED = -1L;

    @Override
    public synchronized ShuffleDataFlushEvent toFlushEvent(String appId, int shuffleId, int startPartition, int endPartition, Supplier<Boolean> isValid) {
        return this.toFlushEvent(appId, shuffleId, startPartition, endPartition, isValid, ShuffleDataDistributionType.NORMAL);
    }

    @Override
    public long getEncodedLength() {
        return this.encodedLength;
    }

    @Override
    public long getDataLength() {
        return this.dataLength;
    }

    @Override
    public synchronized ShuffleDataResult getShuffleData(long lastBlockId, int readBufferSize) {
        return this.getShuffleData(lastBlockId, readBufferSize, null);
    }

    @Override
    public synchronized ShuffleDataResult getShuffleData(long lastBlockId, int readBufferSize, Roaring64NavigableMap expectedTaskIds) {
        try {
            ArrayList<BufferSegment> bufferSegments = Lists.newArrayList();
            ArrayList<ShufflePartitionedBlock> readBlocks = Lists.newArrayList();
            this.updateBufferSegmentsAndResultBlocks(lastBlockId, readBufferSize, bufferSegments, readBlocks, expectedTaskIds);
            if (!bufferSegments.isEmpty()) {
                CompositeByteBuf byteBuf = new CompositeByteBuf((ByteBufAllocator)NettyUtils.getSharedUnpooledByteBufAllocator((boolean)true), true, 1024);
                this.updateShuffleData(readBlocks, byteBuf);
                return new ShuffleDataResult((ByteBuf)byteBuf, bufferSegments);
            }
        }
        catch (Exception e) {
            LOG.error("Exception happened when getShuffleData in buffer", (Throwable)e);
        }
        return new ShuffleDataResult();
    }

    protected abstract void updateBufferSegmentsAndResultBlocks(long var1, long var3, List<BufferSegment> var5, List<ShufflePartitionedBlock> var6, Roaring64NavigableMap var7);

    protected int calculateDataLength(List<BufferSegment> bufferSegments) {
        BufferSegment bufferSegment = bufferSegments.get(bufferSegments.size() - 1);
        return bufferSegment.getOffset() + bufferSegment.getLength();
    }

    private void updateShuffleData(List<ShufflePartitionedBlock> readBlocks, CompositeByteBuf data) {
        int offset = 0;
        for (ShufflePartitionedBlock block : readBlocks) {
            try {
                data.addComponent(true, block.getData().retain());
            }
            catch (Exception e) {
                LOG.error("Unexpected exception for System.arraycopy, length[" + block.getDataLength() + "], offset[" + offset + "], dataLength[" + data.capacity() + "]", (Throwable)e);
                throw e;
            }
            offset += block.getDataLength();
        }
    }

    protected List<Long> sortFlushingEventId(List<Long> eventIdList) {
        eventIdList.sort((id1, id2) -> {
            if (id1 > id2) {
                return 1;
            }
            return -1;
        });
        return eventIdList;
    }

    protected void updateSegmentsWithoutBlockId(int offset, Collection<ShufflePartitionedBlock> cachedBlocks, long readBufferSize, List<BufferSegment> bufferSegments, List<ShufflePartitionedBlock> readBlocks, Roaring64NavigableMap expectedTaskIds) {
        int currentOffset = offset;
        for (ShufflePartitionedBlock block : cachedBlocks) {
            if (expectedTaskIds != null && !expectedTaskIds.contains(block.getTaskAttemptId())) continue;
            bufferSegments.add(new BufferSegment(block.getBlockId(), (long)currentOffset, block.getDataLength(), block.getUncompressLength(), block.getCrc(), block.getTaskAttemptId()));
            readBlocks.add(block);
            if ((long)(currentOffset += block.getDataLength()) < readBufferSize) continue;
            break;
        }
    }

    @Override
    public long getInFlushSize() {
        return this.inFlushSize.get();
    }
}

